/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.rsam;

import gov.usgs.plot.data.RSAMData;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.swarm.Icons;
import gov.usgs.volcanoes.swarm.SwarmUtil;
import gov.usgs.volcanoes.swarm.Throbber;
import gov.usgs.volcanoes.swarm.chooser.DataChooser;
import gov.usgs.volcanoes.swarm.data.RsamSource;
import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.volcanoes.swarm.rsam.RsamViewPanel;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettings;
import gov.usgs.volcanoes.swarm.rsam.RsamViewSettingsToolbar;
import gov.usgs.volcanoes.swarm.rsam.SettingsListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RsamViewerFrame
extends JInternalFrame
implements Runnable,
SettingsListener {
    public static final long serialVersionUID = -1L;
    private static final int H_TO_S = 3600;
    private static final int D_TO_S = 86400;
    private static final int W_TO_S = 604800;
    private long intervalMs = 5000L;
    private static final int[] SPANS_S = new int[]{3600, 43200, 86400, 172800, 604800, 1209600, 2419200};
    private int spanIndex;
    private SeismicDataSource dataSource;
    private String channel;
    private Thread updateThread;
    private boolean run;
    private JToolBar toolBar;
    private RsamViewSettings settings;
    private RsamViewPanel viewPanel;
    private JPanel mainPanel;
    private JPanel rsamPanel;
    private Throbber throbber;

    public RsamViewerFrame(SeismicDataSource sds, String ch) {
        super(ch + ", [" + sds + "]", true, true, false, true);
        this.dataSource = sds;
        this.channel = ch;
        this.settings = new RsamViewSettings();
        this.settings.addListener(this);
        this.run = true;
        this.updateThread = new Thread((Runnable)this, "RsamViewerFrame-" + sds + "-" + ch);
        this.createUI();
        this.settings.setSpanLength(172800);
    }

    private void createUI() {
        this.setFrameIcon(Icons.rsam_values);
        this.mainPanel = new JPanel(new BorderLayout());
        this.viewPanel = new RsamViewPanel(this.settings);
        this.viewPanel.setChannel(this.channel);
        this.rsamPanel = new JPanel(new BorderLayout());
        this.rsamPanel.add((Component)this.viewPanel, "Center");
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 3, 3), LineBorder.createGrayLineBorder());
        this.rsamPanel.setBorder(border);
        this.mainPanel.add((Component)this.rsamPanel, "Center");
        this.toolBar = SwarmUtil.createToolBar();
        JButton compXButton = SwarmUtil.createToolBarButton(Icons.xminus, "Shrink time axis (Alt-left arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RsamViewerFrame.this.spanIndex > 0) {
                    RsamViewerFrame.this.settings.setSpanLength(SPANS_S[RsamViewerFrame.this.spanIndex - 1]);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "alt LEFT", "compx", compXButton);
        this.toolBar.add(compXButton);
        JButton expXButton = SwarmUtil.createToolBarButton(Icons.xplus, "Expand time axis (Alt-right arrow)", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (RsamViewerFrame.this.spanIndex < SPANS_S.length - 1) {
                    RsamViewerFrame.this.settings.setSpanLength(SPANS_S[RsamViewerFrame.this.spanIndex + 1]);
                }
            }
        });
        Util.mapKeyStrokeToButton(this, "alt RIGHT", "expx", expXButton);
        this.toolBar.add(expXButton);
        this.toolBar.addSeparator();
        new RsamViewSettingsToolbar(this.settings, this.toolBar, this);
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalGlue());
        this.throbber = new Throbber();
        this.toolBar.add(this.throbber);
        this.mainPanel.add((Component)this.toolBar, "North");
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                if (RsamViewerFrame.this.channel != null) {
                    DataChooser.getInstance().setNearest(RsamViewerFrame.this.channel);
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                RsamViewerFrame.this.throbber.close();
                RsamViewerFrame.this.pause();
                SwarmInternalFrames.remove(RsamViewerFrame.this);
                RsamViewerFrame.this.dataSource.close();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.mainPanel);
        this.setSize(750, 280);
        this.setVisible(true);
        this.updateThread.start();
    }

    public synchronized void getRsam() {
        this.throbber.increment();
        this.viewPanel.setWorking(true);
        double now = CurrentTime.getInstance().nowJ2K();
        double st = now - (double)this.settings.getSpanLength();
        int period = this.settings.getType() == RsamViewSettings.ViewType.VALUES ? this.settings.valuesPeriodS : this.settings.countsPeriodS;
        st -= st % (double)period;
        double et = now;
        et += (double)period - et % (double)period;
        RSAMData data = ((RsamSource)((Object)this.dataSource)).getRsam(this.channel, st, et, period);
        this.viewPanel.setData(data, now - (double)this.settings.getSpanLength(), now);
        this.viewPanel.setChannel(this.channel);
        this.viewPanel.setWorking(false);
        this.viewPanel.repaint();
        this.throbber.decrement();
    }

    public void pause() {
        this.run = false;
        this.updateThread.interrupt();
    }

    public void run() {
        while (this.run) {
            try {
                this.getRsam();
                Thread.sleep(this.intervalMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.dataSource.close();
    }

    public void settingsChanged() {
        int i;
        int spanLength = this.settings.getSpanLength();
        for (i = 0; i < SPANS_S.length && SPANS_S[i] < spanLength; ++i) {
        }
        this.spanIndex = i;
        this.getRsam();
    }
}

