/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.swarm.wave;

import gov.usgs.volcanoes.swarm.data.SeismicDataSource;
import gov.usgs.volcanoes.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.volcanoes.swarm.wave.MultiMonitor;
import java.util.HashMap;
import java.util.Map;

public final class SwarmMultiMonitors {
    private static final Map<String, MultiMonitor> monitors = new HashMap<String, MultiMonitor>();

    private SwarmMultiMonitors() {
    }

    public static void removeMonitor(MultiMonitor mm) {
        monitors.remove(mm.getDataSource().getName());
        SwarmInternalFrames.remove(mm);
        mm = null;
    }

    public static MultiMonitor getMonitor(SeismicDataSource source) {
        MultiMonitor monitor = monitors.get(source.getName());
        if (monitor == null) {
            monitor = new MultiMonitor(source);
            monitors.put(source.getName(), monitor);
            SwarmInternalFrames.add(monitor);
        }
        return monitor;
    }

    public static void monitorChannelSelected(SeismicDataSource source, String channel) {
        MultiMonitor monitor = SwarmMultiMonitors.getMonitor(source);
        monitor.setVisible(true);
        monitor.addChannel(channel);
    }
}

