/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.NonBooleanException;
import freemarker.core.NumericalRange;
import freemarker.core.ParameterRole;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

final class Range
extends Expression {
    final Expression lho;
    final Expression rho;

    Range(Expression lho, Expression rho) {
        this.lho = lho;
        this.rho = rho;
    }

    boolean hasRho() {
        return this.rho != null;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        int min = this.lho.evalToNumber(env).intValue();
        int max = 0;
        if (this.rho != null) {
            max = this.rho.evalToNumber(env).intValue();
            return new NumericalRange(min, max);
        }
        return new NumericalRange(min);
    }

    boolean evalToBoolean(Environment env) throws TemplateException {
        throw new NonBooleanException(this, new NumericalRange(0, 0), env);
    }

    public String getCanonicalForm() {
        String rhs = this.rho != null ? this.rho.getCanonicalForm() : "";
        return this.lho.getCanonicalForm() + ".." + rhs;
    }

    String getNodeTypeSymbol() {
        return "..";
    }

    boolean isLiteral() {
        boolean rightIsLiteral = this.rho == null || this.rho.isLiteral();
        return this.constantValue != null || this.lho.isLiteral() && rightIsLiteral;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new Range(this.lho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.rho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.lho;
            }
            case 1: {
                return this.rho;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        return ParameterRole.forBinaryOperatorOperand(idx);
    }
}

