/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import java.io.File;
import java.util.ArrayList;

public enum FileType {
    SAC(".sac", ".*[_\\.](sac|SAC)", "SAC file", false),
    SEED(".mseed", ".*\\.m?seed", "SEED/miniSEED file", true),
    TEXT(".txt", ".*\\.(txt|mat)", "Matlab-readable text file", false),
    SEISAN(".seisan", ".*\\.(seisan)", "Seisan file", true),
    UNKNOWN(".unknown", ".ukn", "Unknown file type", false);

    public final String extensionRE;
    public final String extension;
    public final String description;
    public final boolean isCollective;
    protected static FileType[] knownTypes;

    private FileType(String extension, String extensionRE, String description, boolean isCollective) {
        this.extension = extension;
        this.extensionRE = extensionRE;
        this.description = description;
        this.isCollective = isCollective;
    }

    public String toString() {
        return this.description;
    }

    public static FileType fromFileName(String fileName) {
        for (FileType t : FileType.values()) {
            if (!fileName.matches(t.extensionRE)) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static FileType fromFile(File f) {
        return FileType.fromFileName(f.getPath().toLowerCase());
    }

    public static FileType[] getKnownTypes() {
        return knownTypes;
    }

    static {
        ArrayList<FileType> types = new ArrayList<FileType>();
        for (FileType type : FileType.values()) {
            if (type == UNKNOWN) continue;
            types.add(type);
        }
        knownTypes = types.toArray(new FileType[0]);
    }
}

