/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.plot.map.GeoLabel;
import gov.usgs.proj.GeoRange;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class GeoLabelSet {
    private List<GeoLabel> geoLabels;

    public GeoLabelSet() {
        this.geoLabels = new ArrayList<GeoLabel>();
    }

    public GeoLabelSet(List<GeoLabel> list) {
        this.geoLabels = list;
    }

    public GeoLabelSet(String indexFilename) {
        this();
        try {
            BufferedReader in = new BufferedReader(new FileReader(indexFilename));
            String s = null;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                GeoLabel l = new GeoLabel(s);
                this.geoLabels.add(l);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendFile(String indexFilename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(indexFilename));
            String s = null;
            while ((s = in.readLine()) != null) {
                GeoLabel l;
                if ((s = s.trim()).length() <= 0 || s.startsWith("#") || (l = GeoLabel.fromString(s)) == null) continue;
                this.geoLabels.add(l);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(GeoLabel gl) {
        this.geoLabels.add(gl);
    }

    public List<GeoLabel> getGeoLabels() {
        return this.geoLabels;
    }

    public GeoLabelSet getSubset(GeoRange range) {
        ArrayList<GeoLabel> result = new ArrayList<GeoLabel>();
        for (GeoLabel l : this.geoLabels) {
            if (!range.contains(l.location)) continue;
            result.add(l);
        }
        return new GeoLabelSet(result);
    }
}

