/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.FileType;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.swarm.FileTypeDialog;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.data.AbstractCachingDataSource;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.util.CurrentTime;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class FileDataSource
extends AbstractCachingDataSource {
    private static final FileDataSource INSTANCE = new FileDataSource();
    private Map<String, double[]> channelTimes = new HashMap<String, double[]>();
    private Set<String> openFiles = new HashSet<String>();
    private static SwarmConfig swarmConfig;

    private FileDataSource() {
        this.maxSize = Integer.MAX_VALUE;
        this.storeInUserConfig = false;
        this.name = "Files";
        swarmConfig = SwarmConfig.getInstance();
    }

    public static FileDataSource getInstance() {
        return INSTANCE;
    }

    @Override
    public void flush() {
        List<String> channels = this.getChannels();
        if (channels != null) {
            for (String ch : channels) {
                swarmConfig.removeMetadata(ch);
            }
        }
        super.flush();
        this.openFiles.clear();
        this.channelTimes.clear();
        this.fireChannelsUpdated();
    }

    private void updateChannelTimes(String channel, double t1, double t2) {
        double[] ct = this.channelTimes.get(channel);
        if (ct == null) {
            ct = new double[]{t1, t2};
            this.channelTimes.put(channel, ct);
        }
        ct[0] = Math.min(ct[0], t1);
        ct[1] = Math.max(ct[1], t2);
    }

    public void openFiles(File[] fs) {
        FileTypeDialog dialog = null;
        for (int i = 0; i < fs.length; ++i) {
            String fileName = fs[i].getPath();
            if (this.openFiles.contains(fileName)) continue;
            SeismicDataFile file = SeismicDataFile.getFile(fileName);
            if (file == null) {
                if (dialog == null) {
                    dialog = new FileTypeDialog();
                }
                if (!dialog.isOpen() || dialog.isOpen() && !dialog.isAssumeSame()) {
                    dialog.setFilename(fs[i].getName());
                    dialog.setVisible(true);
                }
                FileType fileType = dialog.isCancelled() ? FileType.UNKNOWN : dialog.getFileType();
                logger.warning("user input file type: " + fs[i].getPath() + " -> " + (Object)((Object)fileType));
                file = SeismicDataFile.getFile(fileName, fileType);
            }
            if (file != null) {
                this.readFile(file);
                FileDataSource.swarmConfig.lastPath = fs[i].getParent();
                continue;
            }
            JOptionPane.showMessageDialog(applicationFrame, "Could not open file: " + fileName, "Error", 0);
        }
    }

    private void readFile(final SeismicDataFile file) {
        final String fileName = file.getFileName();
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                Throwable result = null;
                FileDataSource.this.fireChannelsProgress(fileName, 0.0);
                try {
                    AbstractCachingDataSource.logger.fine("opening file: " + fileName);
                    file.read();
                    double progress = 0.2;
                    FileDataSource.this.fireChannelsProgress(fileName, progress);
                    int channelCount = file.getChannels().size();
                    double progressInc = 0.8 / (double)channelCount;
                    for (String channel : file.getChannels()) {
                        Metadata md = swarmConfig.getMetadata(channel, true);
                        md.addGroup(file.getGroup());
                        Wave wave = file.getWave(channel);
                        FileDataSource.this.fireChannelsProgress(fileName, progress += progressInc);
                        FileDataSource.this.updateChannelTimes(channel, wave.getStartTime(), wave.getEndTime());
                        FileDataSource.this.fireChannelsProgress(fileName, progress += progressInc);
                        FileDataSource.this.cacheWaveAsHelicorder(channel, wave);
                        FileDataSource.this.putWave(channel, wave);
                    }
                    swarmConfig.assignMetadataSource(file.getChannels(), FileDataSource.this);
                    FileDataSource.this.openFiles.add(fileName);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    result = t;
                }
                FileDataSource.this.fireChannelsProgress(fileName, 1.0);
                FileDataSource.this.fireChannelsUpdated();
                MapFrame.getInstance().reset(false);
                return result;
            }

            @Override
            public void finished() {
                if (this.getValue() != null) {
                    JOptionPane.showMessageDialog(AbstractCachingDataSource.applicationFrame, "Could not open file: " + fileName, "Error", 0);
                }
            }
        };
        worker.start();
    }

    @Override
    public HelicorderData getHelicorder(String channel, double t1, double t2, GulperListener gl) {
        double[] ct = this.channelTimes.get(channel = channel.replace(' ', '$'));
        if (ct == null) {
            return null;
        }
        double dt = t2 - t1;
        double now = CurrentTime.getInstance().nowJ2K();
        if (Math.abs(now - t2) < 3600.0) {
            t2 = ct[1];
            t1 = t2 - dt;
        }
        return super.getHelicorder(channel, t1, t2, gl);
    }

    @Override
    public Wave getWave(String station, double t1, double t2) {
        List waves = (List)this.waveCache.get(station.replace(' ', '$'));
        if (waves == null) {
            return null;
        }
        ArrayList<Wave> parts = new ArrayList<Wave>();
        double minT = 1.0E300;
        double maxT = -1.0E300;
        for (AbstractCachingDataSource.CachedWave cw : waves) {
            if (!cw.wave.overlaps(t1, t2)) continue;
            parts.add(cw.wave);
            minT = Math.min(minT, cw.t1);
            maxT = Math.max(maxT, cw.t2);
        }
        if (parts.size() == 1) {
            return (Wave)parts.get(0);
        }
        Wave wave = Wave.join(parts, minT, maxT);
        if (wave != null) {
            wave = wave.subset(t1, t2);
        }
        return wave;
    }

    @Override
    public String toConfigString() {
        return this.name + ";file:";
    }
}

