/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotJob
implements Comparable<PlotJob> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlotJob.class);
    public final long plotEndMs;
    public final long plotTimeMs;
    public final SubnetPlotter subnet;

    public PlotJob(SubnetPlotter subnet, long plotEndMs) {
        this.plotEndMs = plotEndMs;
        this.subnet = subnet;
        this.plotTimeMs = plotEndMs + (long)subnet.embargoMs;
    }

    public PlotJob(SubnetPlotter subnet) {
        this.subnet = subnet;
        this.plotEndMs = this.findPlotEnd();
        this.plotTimeMs = this.plotEndMs + (long)subnet.embargoMs;
    }

    private long findPlotEnd() {
        long startTime = System.currentTimeMillis();
        startTime -= startTime % 600000L;
        return startTime;
    }

    @Override
    public int compareTo(PlotJob o) {
        return (int)(this.plotTimeMs - o.plotTimeMs);
    }
}

