/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.constraint;

import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.winston.Channel;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeSimpleConstraint;

public class FdsnChannelConstraint
implements FdsnConstraint {
    public final String network;
    public final String station;
    public final String channel;
    public final String location;
    private FdsnTimeSimpleConstraint timeConstraint;

    public FdsnChannelConstraint(String station, String channel, String network, String location) {
        this.station = this.stringToString(station, ".*");
        this.channel = this.stringToString(channel, ".*");
        this.network = this.stringToString(network, ".*");
        this.location = this.stringToString(location, ".*");
        if (this.station == null) {
            System.out.println("is null");
        } else if (this.station.equals("null")) {
            System.out.println("is text null");
        }
    }

    public void setTimeConstraint(FdsnTimeSimpleConstraint c) {
        this.timeConstraint = c;
    }

    private String stringToString(String in, String def) {
        if (in == null) {
            return def;
        }
        if ("".equals(in)) {
            return def;
        }
        if ("null".equals(in)) {
            return def;
        }
        return in;
    }

    @Override
    public boolean matches(Channel chan) {
        if (chan == null) {
            return false;
        }
        String net = chan.network;
        if (net != null && !net.matches(this.network)) {
            return false;
        }
        String cha = chan.channel;
        if (cha != null && !cha.matches(this.channel)) {
            return false;
        }
        String sta = chan.station;
        if (sta != null && !sta.matches(this.station)) {
            return false;
        }
        String loc = chan.location;
        if (loc != null && !loc.matches(this.location)) {
            return false;
        }
        if (this.timeConstraint != null) {
            return this.timeConstraint.matches(chan);
        }
        return true;
    }

    public boolean matches(TraceBuf buf) {
        if (buf == null) {
            return false;
        }
        String net = buf.network();
        if (net != null && !net.matches(this.network)) {
            return false;
        }
        String cha = buf.channel();
        if (cha != null && !cha.matches(this.channel)) {
            return false;
        }
        String sta = buf.station();
        if (sta != null && !sta.matches(this.station)) {
            return false;
        }
        String loc = buf.location();
        if (loc != null && !loc.matches(this.location)) {
            return false;
        }
        if (this.timeConstraint != null) {
            return this.timeConstraint.matches(buf);
        }
        return true;
    }

    public FdsnTimeSimpleConstraint getTimeConstraint() {
        return this.timeConstraint;
    }

    public String toString() {
        return "FdsnChannelConstraint: " + this.station + ":" + this.channel + ":" + this.network + ":" + this.location;
    }
}

