/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.util.Time;
import gov.usgs.winston.server.WWSClient;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.ScnlPanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportSACPanel
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    private static final Color RED = new Color(16752762);
    private static final String DEFAULT_CHUNK_SIZE = "900";
    private static final String DEFAULT_WAIT_TIME = "0";
    private JTextField waveServerF;
    private JTextField portF;
    private ScnlPanel scnlPanel;
    private FilePanel filePanel;
    private JTextField start;
    private JTextField end;
    private JTextField chunkSize;
    private JTextField waitTime;
    private JButton exportB;

    public ExportSACPanel() {
        super("Export SAC");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Export SAC File"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:max(40dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Source Wave Server");
        builder.append("Host", (Component)this.waveServerF);
        builder.nextLine();
        builder.append("Port", (Component)this.portF);
        builder.nextLine();
        builder.appendSeparator("Channel");
        builder.append("SCNL", (Component)this.scnlPanel);
        builder.nextLine();
        builder.appendSeparator("Destination File");
        builder.append("SAC File", (Component)this.filePanel);
        builder.nextLine();
        builder.appendSeparator("Time Range");
        builder.append("Start", (Component)this.start);
        builder.nextLine();
        builder.append("End", (Component)this.end);
        builder.nextLine();
        builder.appendSeparator("Schedule");
        builder.append("Gulp Size (s)", (Component)this.chunkSize);
        builder.nextLine();
        builder.append("Gulp Delay (s)", (Component)this.waitTime);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.exportB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        this.waveServerF = new JTextField(15);
        this.portF = new JTextField();
        this.portF.setText("16022");
        this.scnlPanel = new ScnlPanel();
        this.filePanel = new FilePanel(FilePanel.Type.SAVE);
        this.start = new JTextField(15);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        this.start.setText(Time.format("yyyyMMddHHmmss", cal.getTime()));
        this.start.setToolTipText("yyyyMMddHHmmss");
        this.start.getDocument().addDocumentListener(new TimeRangeDocumentListener(this.start));
        this.end = new JTextField(15);
        this.end.setText(Time.format("yyyyMMddHHmmss", new Date()));
        this.end.setToolTipText("yyyyMMddHHmmss");
        this.end.getDocument().addDocumentListener(new TimeRangeDocumentListener(this.end));
        this.chunkSize = new JTextField(5);
        this.chunkSize.setText(DEFAULT_CHUNK_SIZE);
        this.waitTime = new JTextField(5);
        this.waitTime.setText(DEFAULT_WAIT_TIME);
        this.exportB = new JButton("Export");
        this.exportB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportSACPanel.this.start();
            }
        });
    }

    @Override
    protected void go() {
        double wt;
        double cs;
        this.exportB.setEnabled(false);
        String server = this.waveServerF.getText().trim();
        int port = Integer.parseInt(this.portF.getText().trim());
        String scnl = this.scnlPanel.getSCNL('$');
        String file = this.filePanel.getFileName();
        try {
            cs = Double.parseDouble(this.chunkSize.getText());
        }
        catch (Exception e) {
            cs = 0.0;
        }
        try {
            wt = Double.parseDouble(this.waitTime.getText());
        }
        catch (Exception e) {
            wt = 0.0;
        }
        try {
            double[] d = Time.parseTimeRange(this.start.getText() + "," + this.end.getText());
            System.out.println("Starting export...");
            if (cs == 0.0) {
                WWSClient.outputSac(server, port, d[0], d[1], scnl, file);
            } else {
                WWSClient.outputSac(server, port, d[0], d[1], scnl, file, cs, wt);
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        System.out.println("Done.");
        this.exportB.setEnabled(true);
    }

    @Override
    public boolean needsWinston() {
        return false;
    }

    public class TimeRangeDocumentListener
    implements DocumentListener {
        JTextField f;

        public TimeRangeDocumentListener(JTextField f) {
            this.f = f;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.f.setBackground(this.validateTime() ? Color.white : RED);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private boolean validateTime() {
            try {
                Time.parseTimeRange(this.f.getText());
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }
    }

    public class TimeRangeOption {
        String title;
        String value;

        public TimeRangeOption(String t, String v) {
            this.title = t;
            this.value = v;
        }

        public String toString() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }
}

