/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.Command;
import gov.usgs.net.Connections;
import gov.usgs.net.Server;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Log;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommandHandler
extends Thread {
    protected static final int COMMAND_BUFFER_SIZE = 2048;
    protected Server server;
    protected Map<String, Command> commands;
    protected Command executeCommand;
    protected String executeCommandInfo;
    protected SocketChannel channel;
    protected SelectionKey selectionKey;
    protected int slowCommandTime;
    protected static Connections connections = Connections.getInstance();
    protected Logger logger = Log.getLogger("gov.usgs.net");

    public CommandHandler(Server svr, String name) {
        this.server = svr;
        this.commands = new HashMap<String, Command>();
        this.slowCommandTime = 0;
        this.setName(name);
        this.start();
    }

    protected abstract void setupCommandHandlers();

    protected void addCommand(String id, Command cmd) {
        this.commands.put(id, cmd);
    }

    protected Command getCommand(String cmd) {
        Command command = this.commands.get(cmd);
        return command;
    }

    protected synchronized void doCommand(SocketChannel ch, SelectionKey key, String cmd) {
        this.channel = ch;
        this.selectionKey = key;
        String cmdName = "";
        int indexSpace = cmd.indexOf(32);
        int indexColon = cmd.indexOf(58);
        if (indexSpace == -1 && indexColon == -1) {
            cmdName = cmd.trim();
        } else {
            int index = -1;
            if (indexSpace == -1 || indexColon == -1) {
                index = indexSpace;
                if (index == -1) {
                    index = indexColon;
                }
            } else {
                index = Math.min(indexSpace, indexColon);
            }
            if (index == -1) {
                index = indexColon;
            }
            cmdName = cmd.substring(0, index);
        }
        Command command = this.getCommand(cmdName);
        if (command != null) {
            this.executeCommand = command;
            this.executeCommandInfo = cmd;
        } else if (cmdName.equalsIgnoreCase("quit")) {
            this.closeConnection();
        }
        this.notify();
    }

    public void closeConnection() {
        this.server.closeConnection(this.channel, this.selectionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException ignoreException) {
                // empty catch block
            }
            if (this.executeCommand == null) continue;
            try {
                String commandLine = this.executeCommandInfo;
                int eol = commandLine.indexOf(10);
                if (eol != -1) {
                    commandLine = commandLine.substring(0, eol);
                }
                CodeTimer ct = new CodeTimer(commandLine);
                this.executeCommand.doCommand(this.executeCommandInfo, this.channel);
                ct.stop();
                if (this.slowCommandTime <= 0 || !(ct.getRunTimeMillis() > (double)this.slowCommandTime)) continue;
                this.logger.log(Level.INFO, String.format(Server.getHost(this.channel) + "/slow command (%1.2f ms) " + commandLine, ct.getRunTimeMillis()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.log(Level.SEVERE, "Unhandled exception in main CommandHandler loop.", e);
                continue;
            }
            finally {
                this.executeCommand = null;
                connections.endCommand(this.channel);
                this.server.addCommandHandler(this);
                continue;
            }
            break;
        }
    }
}

