/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.ConnectionStatistics;
import gov.usgs.net.Connections;
import gov.usgs.net.NetTools;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Log;
import gov.usgs.util.Pool;
import gov.usgs.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Server {
    protected ByteBuffer inBuffer = ByteBuffer.allocate(65536);
    protected NetTools netTools = new NetTools();
    protected static final int COMMAND_BUFFER_SIZE = 2048;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String name = "Server";
    protected int serverPort = -1;
    protected InetAddress serverIP = null;
    protected boolean keepalive = false;
    protected long connectionIndex = 0L;
    private Pool<CommandHandler> commandHandlerPool;
    protected Logger logger;
    protected int maxReadHandlers = -1;
    protected Connections connections = Connections.getInstance();
    protected boolean dropOldest = true;
    protected long totalBytesSent = 0L;

    protected Server() {
        this.logger = Log.getLogger("gov.usgs.net");
        this.commandHandlerPool = new Pool();
    }

    protected Server(InetAddress a, int p) {
        this();
        this.serverIP = a;
        this.serverPort = p;
    }

    protected void addCommandHandler(CommandHandler rh) {
        this.commandHandlerPool.checkin(rh);
        int max = Math.max(this.maxReadHandlers, this.commandHandlerPool.size());
        if (max > this.maxReadHandlers) {
            this.logger.log(Level.FINE, "command handler pool size: " + max);
        }
        this.maxReadHandlers = max;
    }

    public int getPoolSize() {
        return this.commandHandlerPool.size();
    }

    public static String getHost(SocketChannel channel) {
        String addr;
        try {
            addr = channel.socket().getInetAddress().getHostAddress();
        }
        catch (NullPointerException e) {
            addr = "(closed)";
        }
        return addr;
    }

    public void log(Level level, String msg, SocketChannel channel) {
        String channelString = channel == null ? "" : Server.getHost(channel) + "/";
        String logMsg = channelString + msg;
        this.logger.log(level, logMsg);
    }

    protected void closeConnection(SocketChannel channel, SelectionKey selectionKey) {
        try {
            this.connections.remove(channel);
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
            if (selectionKey != null) {
                selectionKey.cancel();
                selectionKey.selector().wakeup();
                selectionKey.attach(null);
            }
            this.log(Level.FINER, String.format("Connection closed: %d/%d.", this.connections.getNumConnections(), this.connections.getMaxConnections()), channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void dispatchCommand(SocketChannel channel, SelectionKey key, String s) {
        CodeTimer ct = new CodeTimer("getReadHandler");
        CommandHandler ch = this.commandHandlerPool.checkout();
        ct.stop();
        if (ct.getRunTimeMillis() > 1000.0) {
            this.log(Level.FINE, String.format("long wait for read handler: %1.2f ms. ", ct.getRunTimeMillis()), channel);
        }
        ch.doCommand(channel, key, s);
    }

    public void recordSent(SocketChannel channel, int nb) {
        this.totalBytesSent += (long)nb;
        this.connections.sent(channel, nb);
    }

    public void processRead(SelectionKey selectionKey) {
        SocketChannel channel = (SocketChannel)selectionKey.channel();
        if (!channel.isConnected() || !channel.isOpen()) {
            return;
        }
        Object attachment = selectionKey.attachment();
        ByteBuffer commandBuffer = attachment != null ? (ByteBuffer)attachment : ByteBuffer.allocate(2048);
        boolean close = false;
        try {
            this.inBuffer.clear();
            int bytesRead = channel.read(this.inBuffer);
            if (bytesRead == -1) {
                close = true;
            } else {
                this.connections.read(channel, bytesRead);
                this.inBuffer.flip();
                if (this.readLine(this.inBuffer, commandBuffer)) {
                    SocketAddress s;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < 5; ++i) {
                        sb.append((char)commandBuffer.get(i));
                    }
                    String cmd = sb.toString();
                    if ((cmd.startsWith("GET ") || cmd.startsWith("POST ")) && !cmd.contains("HTTP/")) {
                        this.readHTTP(this.inBuffer, commandBuffer);
                    }
                    commandBuffer.flip();
                    String commandString = this.netTools.decoder.decode(commandBuffer).toString();
                    if (this.connections.isTraced(channel) && (s = channel.socket().getRemoteSocketAddress()) != null) {
                        this.logger.log(Level.WARNING, s + ": " + commandString);
                    }
                    this.connections.beginCommand(channel, commandString);
                    this.dispatchCommand(channel, selectionKey, commandString);
                    commandBuffer.clear();
                }
                if (commandBuffer.position() != 0) {
                    selectionKey.attach(commandBuffer);
                } else {
                    selectionKey.attach(null);
                }
            }
        }
        catch (IOException e) {
            close = true;
        }
        catch (BufferOverflowException e) {
            this.logger.log(Level.SEVERE, "Buffer overflow on read.  Possible malicious attack?");
            close = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unhandled exception.", e);
            close = true;
        }
        if (close) {
            this.closeConnection(channel, selectionKey);
        }
    }

    private boolean readLine(ByteBuffer inBuffer, ByteBuffer commandBuffer) {
        boolean foundEoL = false;
        while (!foundEoL && inBuffer.position() < inBuffer.limit()) {
            byte b = inBuffer.get();
            if (b == 10) {
                foundEoL = true;
                continue;
            }
            commandBuffer.put(b);
        }
        return foundEoL;
    }

    private boolean readHTTP(ByteBuffer inBuffer, ByteBuffer commandBuffer) {
        boolean haveCompleteRequest = false;
        commandBuffer.put((byte)10);
        boolean haveHeaders = false;
        while (!haveHeaders && inBuffer.position() < inBuffer.limit()) {
            int position = commandBuffer.position();
            if (!this.readLine(inBuffer, commandBuffer)) continue;
            commandBuffer.put((byte)10);
            haveHeaders = commandBuffer.position() - position < 2;
        }
        int contentLength = 0;
        if (haveHeaders) {
            String[] headers;
            String header = commandBuffer.duplicate().toString();
            for (String headerLine : headers = header.split("/\n/")) {
                if (!headerLine.startsWith("Content-Length:")) continue;
                contentLength = Integer.parseInt(headerLine.substring(15));
            }
            while (contentLength-- > 0 && inBuffer.position() < inBuffer.limit()) {
                commandBuffer.put(inBuffer.get());
            }
            if (contentLength == 0) {
                haveCompleteRequest = true;
            }
        }
        return haveCompleteRequest;
    }

    public void printConnections(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.connections.printConnections(s));
        sb.append("Available command handlers: " + this.commandHandlerPool.size() + "/" + this.maxReadHandlers + "\n");
        sb.append("Total bytes sent:           " + Util.numBytesToString(this.totalBytesSent) + "\n");
        System.out.println(sb);
    }

    public void printCommands(String s) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.connections.printCommands(s));
        sb.append("\nAvailable command handlers: " + this.commandHandlerPool.size() + "/" + this.maxReadHandlers + "\n");
        System.out.println(sb);
    }

    public void dropConnections() {
        this.dropConnections(0L);
    }

    public void dropConnections(long idleLimit) {
        this.logger.info("Dropping connections.");
        ArrayList<SocketChannel> channels = new ArrayList<SocketChannel>(this.connections.connectionCount());
        Map<SocketChannel, ConnectionStatistics> connectionStats = this.connections.getConnections();
        for (SocketChannel sc : connectionStats.keySet()) {
            ConnectionStatistics cs = connectionStats.get(sc);
            if (System.currentTimeMillis() - cs.lastRequestTime <= idleLimit) continue;
            channels.add(sc);
        }
        for (SocketChannel sc : channels) {
            this.closeConnection(sc, null);
        }
    }

    public void dropOldestConnection() {
        long least = Long.MAX_VALUE;
        SocketChannel lc = null;
        Map<SocketChannel, ConnectionStatistics> connectionStats = this.connections.getConnections();
        for (ConnectionStatistics cs : connectionStats.values()) {
            if (cs.lastRequestTime >= least) continue;
            least = cs.lastRequestTime;
            lc = cs.channel;
        }
        if (lc != null) {
            this.closeConnection(lc, null);
        }
    }

    public void toggleTrace(String cmd) {
        try {
            int index = Integer.parseInt(cmd.substring(1));
            this.connections.toggleTrace(index);
        }
        catch (NumberFormatException e) {
            this.logger.warning("Can't parse index. Use 'c' to find the connection index.");
        }
    }

    protected void startListening() {
        if (this.commandHandlerPool.size() <= 0 || this.serverPort == -1) {
            return;
        }
        try {
            Selector selector = Selector.open();
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            serverChannel.configureBlocking(false);
            if (this.serverIP == null) {
                serverChannel.socket().bind(new InetSocketAddress(this.serverPort));
                this.logger.info("listening on IP *.");
            } else {
                serverChannel.socket().bind(new InetSocketAddress(this.serverIP, this.serverPort));
                this.logger.info("listening on IP " + this.serverIP.getHostAddress() + ".");
            }
            serverChannel.register(selector, 16);
            this.logger.info("listening on port " + this.serverPort + ".");
            block4: while (true) {
                selector.select();
                Set<SelectionKey> sk = selector.selectedKeys();
                Iterator<SelectionKey> it = sk.iterator();
                while (true) {
                    if (!it.hasNext()) continue block4;
                    try {
                        SocketChannel channel;
                        SelectionKey selKey = it.next();
                        it.remove();
                        if (!selKey.isValid()) continue;
                        if (selKey.isAcceptable()) {
                            ServerSocketChannel ssChannel = (ServerSocketChannel)selKey.channel();
                            SocketChannel channel2 = ssChannel.accept();
                            if (channel2 == null) {
                                System.err.println("channel is null in net.Server.startListening.");
                                continue;
                            }
                            Socket socket = channel2.socket();
                            if (socket == null) {
                                System.err.println("socket is null in net.Server.startListening.");
                                continue;
                            }
                            socket.setKeepAlive(this.keepalive);
                            socket.setTcpNoDelay(true);
                            ConnectionStatistics cs = this.connections.getConnectionStatistics(channel2);
                            cs.touch();
                            if (this.connections.getMaxConnections() != 0 && this.connections.getNumConnections() > this.connections.getMaxConnections()) {
                                if (this.dropOldest) {
                                    this.logger.severe("Max connections reached, dropped least recently used connection.");
                                    this.dropOldestConnection();
                                } else {
                                    this.logger.severe("Max connections reached, rejected connection.");
                                    channel2.close();
                                    this.closeConnection(channel2, null);
                                    continue;
                                }
                            }
                            this.log(Level.FINER, String.format("Connection accepted: %d/%d", this.connections.getNumConnections(), this.connections.getMaxConnections()), channel2);
                            channel2.configureBlocking(false);
                            channel2.register(selector, 1);
                        }
                        if (!selKey.isValid() || !selKey.isReadable() || !(channel = (SocketChannel)selKey.channel()).isOpen() || !channel.isConnected()) continue;
                        ConnectionStatistics cs = this.connections.getConnectionStatistics(channel);
                        cs.touch();
                        this.processRead(selKey);
                    }
                    catch (CancelledKeyException e) {}
                }
                break;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Fatal exception.", e);
            return;
        }
    }
}

