/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive;

import gov.usgs.pensive.plot.ChannelPlotter;
import gov.usgs.pensive.plot.FullPlotter;
import gov.usgs.pensive.plot.ThumbnailPlotter;
import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.render.Renderer;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.awt.Dimension;
import java.util.logging.Logger;

public class Channel {
    private static final Logger LOGGER = Log.getLogger("gov.usgs");
    public final String name;
    private final ChannelPlotter plot;
    private final ChannelPlotter thumb;

    public Channel(String channel, int index, Dimension plotDimension, Dimension thumbDimension, boolean decorateX, ConfigFile config) {
        this.name = channel;
        this.plot = new FullPlotter(channel, index, plotDimension, decorateX, config);
        this.thumb = new ThumbnailPlotter(channel, index, thumbDimension, config);
    }

    public void updateWave(long plotEndMs, SeismicDataSource dataSource) {
        double t2 = Util.ewToJ2K(plotEndMs / 1000L);
        double t1 = t2 - 600.0;
        Wave w = dataSource.getWave(this.name.replace('_', ' '), t1, t2);
        SliceWave wave = null;
        if (w != null) {
            wave = new SliceWave(w);
            wave.setSlice(t1, t2);
        }
        this.plot.setWave(wave);
        this.thumb.setWave(wave);
    }

    public Renderer plot() {
        return this.plot.plot();
    }

    public Renderer plotThumb() {
        return this.thumb.plot();
    }
}

