/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive;

import gov.usgs.pensive.PlotJob;
import gov.usgs.pensive.WaveSource;
import gov.usgs.pensive.plot.SubnetPlotter;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Pool;
import gov.usgs.util.Util;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlotScheduler
implements Runnable {
    private static final Logger LOGGER = Log.getLogger("gov.usgs");
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_NUMTHREADS = 5;
    private final Pool<WaveSource> plotter;
    private final BlockingQueue<PlotJob> plotJobs;
    private final List<SubnetPlotter> subnets;
    private final int numThreads;
    public final String name;

    public PlotScheduler(String name, ConfigFile config) {
        this.name = name;
        this.numThreads = Util.stringToInt(config.getString("threads"), 5);
        this.subnets = new LinkedList<SubnetPlotter>();
        this.plotJobs = new LinkedBlockingQueue<PlotJob>();
        this.plotter = new Pool();
        for (int i = 0; i < this.numThreads; ++i) {
            String n = name + "-" + i;
            WaveSource p = new WaveSource(n, this.plotJobs, config);
            this.plotter.checkin(p);
            Thread t = new Thread(p);
            t.setName(n);
            t.start();
        }
    }

    public void add(SubnetPlotter subnet) {
        this.subnets.add(subnet);
    }

    public int subnetCount() {
        return this.subnets.size();
    }

    public void schedulePlots() {
        for (SubnetPlotter subnet : this.subnets) {
            try {
                LOGGER.log(Level.FINE, "Scheduling subnet " + subnet.subnetName);
                this.plotJobs.put(new PlotJob(subnet));
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted. Unable to schedule " + subnet.subnetName);
            }
        }
    }

    @Override
    public void run() {
        try {
            LOGGER.log(Level.INFO, "scheduling plots for " + this.name);
            this.schedulePlots();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Caught exception heading for scheduler. " + e.getLocalizedMessage());
        }
    }
}

