/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive.plot;

import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.render.BasicFrameRenderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.plot.render.wave.MinuteMarkingWaveRenderer;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.plot.render.wave.SpectrogramRenderer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

public abstract class ChannelPlotter {
    public static final Color NO_DATA_TEXT_COLOR = new Color(160, 41, 41);
    public static final double WAVE_RATIO = 0.25;
    public static final double DEFAULT_OVERLAP = 0.859375;
    public static final boolean DEFAULT_LOG_POWER = true;
    public static final double DEFAULT_MIN_FREQ = 0.0;
    public static final double DEFAULT_MAX_FREQ = 10.0;
    public static final int DEFAULT_NFFT = 0;
    public static final int DEFAULT_BIN_SIZE = 256;
    public static final int DEFAULT_MAX_POWER = 120;
    public static final int DEFAULT_MIN_POWER = 30;
    protected SliceWave wave;
    protected Font noDataFont;
    protected int index;
    protected Dimension plotDimension;
    protected ConfigFile config;
    private final SliceWaveRenderer waveRenderer;
    protected final SpectrogramRenderer spectrogramRenderer;
    private final BasicFrameRenderer plotFrame;
    protected final int waveHeight;
    protected final String name;

    protected abstract void tweakSpectrogramRenderer(SpectrogramRenderer var1);

    protected abstract void tweakWaveRenderer(SliceWaveRenderer var1);

    protected abstract void tweakNoDataRenderer(TextRenderer var1);

    public ChannelPlotter(String name, int index, Dimension plotDimension, ConfigFile config) {
        this.name = name;
        this.index = index;
        this.plotDimension = plotDimension;
        this.config = config;
        this.waveHeight = (int)((double)plotDimension.height * 0.25);
        this.waveRenderer = this.createWaveRenderer();
        this.spectrogramRenderer = this.createSpectrogramRenderer(config);
        this.plotFrame = new BasicFrameRenderer();
        this.plotFrame.addRenderer(this.waveRenderer);
        this.plotFrame.addRenderer(this.spectrogramRenderer);
    }

    protected SpectrogramRenderer createSpectrogramRenderer(ConfigFile config) {
        SpectrogramRenderer sr = new SpectrogramRenderer();
        sr.yTickMarks = false;
        sr.yTickValues = false;
        sr.xTickMarks = false;
        sr.xTickValues = false;
        sr.xUnits = false;
        sr.xLabel = false;
        sr.setOverlap(Util.stringToDouble(config.getString("overlap"), 0.859375));
        sr.setLogPower(Util.stringToBoolean(config.getString("logPower"), true));
        sr.setMinFreq(Util.stringToDouble(config.getString("minFreq"), 0.0));
        sr.setMaxFreq(Util.stringToDouble(config.getString("maxFreq"), 10.0));
        sr.setNfft(Util.stringToInt(config.getString("nfft"), 0));
        sr.setBinSize(Util.stringToInt(config.getString("binSize"), 256));
        sr.setMinPower(Util.stringToInt(config.getString("minPower"), 30));
        sr.setMaxPower(Util.stringToInt(config.getString("maxPower"), 120));
        sr.setTimeZone("UTC");
        this.tweakSpectrogramRenderer(sr);
        return sr;
    }

    protected SliceWaveRenderer createWaveRenderer() {
        MinuteMarkingWaveRenderer wr = new MinuteMarkingWaveRenderer();
        wr.xTickMarks = false;
        wr.xTickValues = false;
        wr.xUnits = false;
        wr.xLabel = false;
        wr.yTickMarks = false;
        wr.yTickValues = false;
        wr.setColor(Color.BLACK);
        this.tweakWaveRenderer(wr);
        return wr;
    }

    public void setWave(SliceWave wave) {
        this.wave = wave;
    }

    public BasicFrameRenderer plot() {
        if (this.wave == null) {
            return this.noDataRenderer();
        }
        double plotStart = this.wave.getStartTime();
        double plotEnd = this.wave.getStartTime() + 600.0;
        this.waveRenderer.setMinY(this.wave.min());
        this.waveRenderer.setMaxY(this.wave.max());
        this.waveRenderer.setWave(this.wave);
        this.waveRenderer.setViewTimes(plotStart, plotEnd, "UTC");
        this.waveRenderer.update();
        this.spectrogramRenderer.setWave(this.wave);
        this.spectrogramRenderer.setViewStartTime(plotStart);
        this.spectrogramRenderer.setViewEndTime(plotEnd);
        this.spectrogramRenderer.createDefaultFrameDecorator();
        this.spectrogramRenderer.update();
        return this.plotFrame;
    }

    private BasicFrameRenderer noDataRenderer() {
        BasicFrameRenderer fr = new BasicFrameRenderer();
        int top = this.index * this.plotDimension.height;
        TextRenderer tr = new TextRenderer(this.plotDimension.width / 2, top + this.plotDimension.height / 2, this.name + " - no data");
        tr.horizJustification = 1;
        tr.vertJustification = 1;
        tr.color = NO_DATA_TEXT_COLOR;
        tr.font = this.noDataFont;
        this.tweakNoDataRenderer(tr);
        fr.addRenderer(tr);
        return fr;
    }
}

