/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive.plot;

import gov.usgs.pensive.Channel;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class SubnetPlotter {
    private static final Logger LOGGER = Log.getLogger("gov.usgs");
    public static final String DEFAULT_PATH_ROOT = "html";
    public static final String DEFAULT_FILE_PATH_FORMAT = "yyyy/DDD";
    public static final String DEFAULT_FILE_SUFFIX_FORMAT = "_yyyyMMdd-HHmm";
    public static final int DEFAULT_PLOT_WIDTH = 576;
    public static final int DEFAULT_PLOT_HEIGHT = 756;
    public static final int DEFAULT_THUMB_WIDTH = 151;
    public static final int DEFAULT_THUMB_HEIGHT = 198;
    public static final int DEFAULT_EMBARGO = 5;
    public static final int LABEL_HEIGHT = 35;
    public static final int LABEL_WIDTH = 30;
    public static final int DURATION_S = 600;
    private final String pathRoot;
    private final String filePathFormat;
    private final String fileSuffixFormat;
    public final String networkName;
    public final String subnetName;
    public final int embargoMs;
    private final Dimension plotDimension;
    private final Dimension thumbDimension;
    private final List<Channel> channels;
    private int channelHeight;

    public SubnetPlotter(String networkName, String subnetName, ConfigFile config) {
        this.subnetName = subnetName;
        this.networkName = networkName;
        this.pathRoot = Util.stringToString(config.getString("pathRoot"), DEFAULT_PATH_ROOT);
        this.filePathFormat = Util.stringToString(config.getString("filePathFormat"), DEFAULT_FILE_PATH_FORMAT);
        this.fileSuffixFormat = Util.stringToString(config.getString("fileSuffixFormat"), DEFAULT_FILE_SUFFIX_FORMAT);
        this.embargoMs = Util.stringToInt(config.getString("embargo"), 5) * 1000;
        this.plotDimension = new Dimension();
        this.plotDimension.width = Util.stringToInt(config.getString("plotWidth"), 576);
        this.plotDimension.height = Util.stringToInt(config.getString("plotHeight"), 756);
        this.thumbDimension = new Dimension();
        this.thumbDimension.width = Util.stringToInt(config.getString("thumbWidth"), 151);
        this.thumbDimension.height = Util.stringToInt(config.getString("thumbHeight"), 198);
        this.channels = this.createChannels(config.getSubConfig(subnetName, true));
    }

    private List<Channel> createChannels(ConfigFile config) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        List<String> chans = config.getList("channel");
        Dimension plotChanDimension = new Dimension();
        plotChanDimension.height = (this.plotDimension.height - 70) / chans.size();
        plotChanDimension.width = this.plotDimension.width;
        Dimension thumbChanDimension = new Dimension();
        thumbChanDimension.height = this.thumbDimension.height / chans.size();
        thumbChanDimension.width = this.thumbDimension.width;
        int idx = 0;
        for (String channel : chans) {
            boolean decorateX = idx == chans.size() - 1;
            ConfigFile c = config.getSubConfig(channel, true);
            Channel chan = new Channel(channel, idx, plotChanDimension, thumbChanDimension, decorateX, c);
            channels.add(chan);
            ++idx;
        }
        return channels;
    }

    public void plot(long plotEndMs, SeismicDataSource dataSource) {
        Plot plot = new Plot(this.plotDimension.width, this.plotDimension.height);
        Plot thumb = new Plot(this.thumbDimension.width, this.thumbDimension.height);
        for (Channel channel : this.channels) {
            channel.updateWave(plotEndMs, dataSource);
            plot.addRenderer(channel.plot());
            thumb.addRenderer(channel.plotThumb());
        }
        String fileBase = this.generateFileBase(plotEndMs);
        new File(fileBase).getParentFile().mkdirs();
        this.writePNG(plot, fileBase + ".png");
        this.writePNG(thumb, fileBase + "_thumb.png");
    }

    private void writePNG(Plot plot, String fileName) {
        LOGGER.log(Level.FINE, "writting " + fileName);
        try {
            plot.writePNG(fileName);
        }
        catch (PlotException e) {
            LOGGER.log(Level.SEVERE, "Cannot write " + fileName + ": " + e.getLocalizedMessage());
        }
    }

    private String generateFileBase(long timeMs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pathRoot + '/');
        if (this.networkName != null) {
            sb.append(this.networkName + '/');
        }
        sb.append(this.subnetName + '/');
        sb.append(Time.format(this.filePathFormat, timeMs));
        sb.append('/' + this.subnetName);
        sb.append(Time.format(this.fileSuffixFormat, timeMs));
        String name = sb.toString();
        name = name.replaceAll("/+", Matcher.quoteReplacement(File.separator));
        return name;
    }
}

