/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.PlotException;
import gov.usgs.plot.render.Renderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.util.Log;
import gov.usgs.util.png.PngEncoderB;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFrame;

public class Plot
implements Printable {
    protected static final Logger logger = Log.getLogger("gov.usgs.plot.Plot");
    private Dimension size;
    private Color backgroundColor;
    protected List<Renderer> renderers;

    public Plot() {
        this(0, 0);
    }

    public Plot(int w, int h) {
        this.size = new Dimension(w, h);
        this.renderers = new ArrayList<Renderer>();
        this.backgroundColor = Color.WHITE;
    }

    public void clear() {
        this.renderers.clear();
    }

    public List<Renderer> getRenderers() {
        return this.renderers;
    }

    public void addRenderer(Renderer dr) {
        this.renderers.add(dr);
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public BufferedImage getAsBufferedImage(boolean alpha) throws PlotException {
        int type = alpha ? 2 : 1;
        BufferedImage image = new BufferedImage(this.size.width, this.size.height, type);
        Graphics2D imageGraphics = (Graphics2D)image.getGraphics();
        this.render(imageGraphics);
        return image;
    }

    public void writePNG(String fn) throws PlotException {
        BufferedImage image = this.getAsBufferedImage(true);
        PngEncoderB png = new PngEncoderB(image, false, 0, 7);
        try {
            FileOutputStream out = new FileOutputStream(fn);
            byte[] bytes = png.pngEncode();
            out.write(bytes);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.severe(e.getMessage());
            throw new PlotException(e.getMessage());
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            throw new PlotException(e.getMessage());
        }
    }

    public void writeJPEG(String fn) throws PlotException {
        BufferedImage image = this.getAsBufferedImage(false);
        try {
            ImageIO.write((RenderedImage)image, "JPEG", new File(fn));
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            throw new PlotException(e.getMessage());
        }
    }

    public byte[] getPNGBytes() throws PlotException {
        BufferedImage image = this.getAsBufferedImage(true);
        try {
            PngEncoderB png = new PngEncoderB(image, false, 0, 7);
            byte[] bytes = png.pngEncode();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writePS(String fn) {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        String psMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, psMimeType);
        if (factories.length == 0) {
            logger.info("No suitable factories");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            StreamPrintService sps = factories[0].getPrintService(fos);
            DocPrintJob pj = sps.createPrintJob();
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            Book book = new Book();
            PageFormat pf = new PageFormat();
            Paper p = new Paper();
            double w = (double)this.size.width * 0.7;
            double h = (double)this.size.height * 0.7;
            p.setSize(w, h);
            p.setImageableArea(0.0, 0.0, w, h);
            pf.setPaper(p);
            book.append(this, pf);
            SimpleDoc doc = new SimpleDoc(book, flavor, null);
            pj.print(doc, aset);
            fos.close();
        }
        catch (PrintException pe) {
            logger.warning(pe.toString());
        }
        catch (IOException ie) {
            logger.warning(ie.toString());
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform at = g2.getTransform();
            g2.scale(0.7, 0.7);
            try {
                this.render(g2);
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
            }
            g2.setTransform(at);
            return 0;
        }
        return 1;
    }

    public void render(Graphics2D g) throws PlotException {
        if (this.backgroundColor != null) {
            Color origColor = g.getColor();
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.size.width, this.size.height);
            g.setColor(origColor);
        }
        g.setColor(Color.black);
        AffineTransform origAT = g.getTransform();
        for (Renderer renderer : this.renderers) {
            if (renderer instanceof TextRenderer) {
                ((TextRenderer)renderer).antiAlias = true;
            }
            renderer.render(g);
        }
        g.setTransform(origAT);
    }

    public void setSize(int w, int h) {
        this.size.width = w;
        this.size.height = h;
    }

    public void setSize(Dimension d) {
        this.size = d;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public void quickShow() {
        this.quickShow(0, 0);
    }

    public void quickShow(int x, int y) {
        JFrame frame = new JFrame("Plot");
        frame.setSize(this.size.width + 30, this.size.height + 50);
        frame.setLocation(x, y);
        frame.setContentPane(new Container(){
            private static final long serialVersionUID = -1L;

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.translate(10, 10);
                try {
                    Plot.this.render(g2);
                }
                catch (Exception e) {
                    logger.severe(e.getMessage());
                }
            }
        });
        frame.setVisible(true);
    }

    public static void renderArray(Graphics2D g, Renderer[] renderers) {
        if (renderers != null) {
            for (int i = 0; i < renderers.length; ++i) {
                if (renderers[i] == null) continue;
                renderers[i].render(g);
            }
        }
    }
}

