/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.proj.Projection;
import gov.usgs.swarm.SCNL;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Pair;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Metadata
implements Comparable<Metadata> {
    public static final String DEFAULT_METADATA_FILENAME = "SwarmMetadata.config";
    private SCNL scnl;
    private String channel = null;
    private String alias = null;
    private String unit = null;
    private double multiplier = 1.0;
    private double offset = 0.0;
    private boolean linearSet = false;
    private double longitude = Double.NaN;
    private double latitude = Double.NaN;
    private double height = Double.NaN;
    public SeismicDataSource source;
    private TimeZone timeZone = null;
    private boolean tzSet = false;
    private Set<String> groups = null;
    public Map<String, String> ancillaryMetadata = null;

    public Metadata(String ch) {
        this.updateChannel(ch);
    }

    public boolean isTouched() {
        return this.alias != null || this.unit != null || this.multiplier != 1.0 || this.offset != 0.0 || !Double.isNaN(this.longitude) || !Double.isNaN(this.latitude) || !Double.isNaN(this.height) || this.tzSet || this.groups != null || this.ancillaryMetadata != null;
    }

    public void updateTimeZone(String tz) {
        if (!this.tzSet && tz != null && tz.length() >= 1) {
            this.timeZone = TimeZone.getTimeZone(tz);
            this.tzSet = true;
        }
    }

    public void updateChannel(String ch) {
        if (this.channel == null) {
            this.channel = ch;
            this.scnl = new SCNL(this.channel);
        }
    }

    public void updateAlias(String a) {
        if (this.alias == null) {
            this.alias = a;
        }
    }

    public void updateUnits(String u) {
        if (this.unit == null) {
            this.unit = u;
        }
    }

    public void updateLinearCoefficients(double mult, double off) {
        if (!this.linearSet) {
            if (!Double.isNaN(mult)) {
                this.multiplier = mult;
            }
            if (!Double.isNaN(off)) {
                this.offset = off;
            }
            this.linearSet = true;
        }
    }

    public void updateLongitude(double lon) {
        if (Double.isNaN(this.longitude)) {
            this.longitude = lon;
        }
    }

    public void updateLatitude(double lat) {
        if (Double.isNaN(this.latitude)) {
            this.latitude = lat;
        }
    }

    public void updateHeight(double h) {
        if (Double.isNaN(this.height)) {
            this.height = h;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public double getOffset() {
        return this.offset;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getChannel() {
        return this.channel;
    }

    public SCNL getSCNL() {
        return this.scnl;
    }

    public boolean hasLonLat() {
        return !Double.isNaN(this.longitude) && this.longitude != -999.0 && !Double.isNaN(this.latitude) && this.latitude != -999.0;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void addGroup(String g) {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        this.groups.add(g);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void interpret(String s) {
        String[] kv = new String[]{s.substring(0, s.indexOf(":")).trim(), s.substring(s.indexOf(":") + 1).trim()};
        if (kv[0].equals("Alias")) {
            this.alias = kv[1];
        } else if (kv[0].equals("Unit")) {
            this.unit = kv[1];
        } else if (kv[0].equals("Multiplier")) {
            this.multiplier = Double.parseDouble(kv[1]);
        } else if (kv[0].equals("Offset")) {
            this.offset = Double.parseDouble(kv[1]);
        } else if (kv[0].equals("Longitude")) {
            this.longitude = Double.parseDouble(kv[1]);
        } else if (kv[0].equals("Latitude")) {
            this.latitude = Double.parseDouble(kv[1]);
        } else if (kv[0].equals("Height")) {
            this.height = Double.parseDouble(kv[1]);
        } else if (kv[0].equals("TimeZone")) {
            this.timeZone = TimeZone.getTimeZone(kv[1]);
        } else if (kv[0].equals("Group")) {
            this.addGroup(kv[1]);
        } else {
            if (this.ancillaryMetadata == null) {
                this.ancillaryMetadata = new HashMap<String, String>();
            }
            this.ancillaryMetadata.put(kv[0], kv[1]);
        }
    }

    public double getLocationHashCode() {
        return this.longitude * 100000.0 + this.latitude;
    }

    public static Map<String, Metadata> loadMetadata(String fn) {
        HashMap<String, Metadata> data = new HashMap<String, Metadata>();
        ConfigFile cf = new ConfigFile(fn);
        Map<String, List<String>> config = cf.getConfig();
        for (String key : config.keySet()) {
            Metadata md = (Metadata)data.get(key);
            if (md == null) {
                md = new Metadata(key);
                data.put(key, md);
            } else {
                md = (Metadata)data.get(key);
            }
            for (String value : config.get(key)) {
                for (String item : value.split(";")) {
                    md.interpret(item);
                }
            }
        }
        return data;
    }

    public double distanceTo(Point2D.Double pt) {
        if (pt == null || Double.isNaN(this.latitude) || Double.isNaN(this.longitude) || Double.isNaN(pt.x) || Double.isNaN(pt.y)) {
            return Double.NaN;
        }
        return Projection.distanceBetween(new Point2D.Double(this.longitude, this.latitude), pt);
    }

    public double distanceTo(Metadata other) {
        if (other == null || Double.isNaN(this.latitude) || Double.isNaN(this.longitude) || Double.isNaN(other.latitude) || Double.isNaN(other.longitude)) {
            return Double.NaN;
        }
        return Projection.distanceBetween(new Point2D.Double(this.longitude, this.latitude), new Point2D.Double(other.longitude, other.latitude));
    }

    public static Comparator<Pair<Double, String>> getDistanceComparator() {
        return new Comparator<Pair<Double, String>>(){

            @Override
            public int compare(Pair<Double, String> o1, Pair<Double, String> o2) {
                if (Math.abs((Double)o1.item1 - (Double)o2.item1) < 1.0E-5) {
                    return ((String)o1.item2).compareTo((String)o2.item2);
                }
                return Double.compare((Double)o1.item1, (Double)o2.item1);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Double, String>> findNearest(Map<String, Metadata> metadata, Point2D.Double pt, boolean requireDS) {
        ArrayList<Pair<Double, String>> result = new ArrayList<Pair<Double, String>>();
        Map<String, Metadata> map = metadata;
        synchronized (map) {
            for (String key : metadata.keySet()) {
                double d;
                Metadata md = metadata.get(key);
                if (!md.hasLonLat() || requireDS && md.source == null || Double.isNaN(d = md.distanceTo(pt)) || !(d > 0.0)) continue;
                result.add(new Pair<Double, String>(new Double(d), md.channel));
            }
        }
        Collections.sort(result, Metadata.getDistanceComparator());
        return result.size() == 0 ? null : result;
    }

    public static List<Pair<Double, String>> findNearest(Map<String, Metadata> metadata, String channel) {
        Metadata md = metadata.get(channel);
        if (md == null || Double.isNaN(md.latitude) || Double.isNaN(md.longitude)) {
            return null;
        }
        ArrayList<Pair<Double, String>> result = new ArrayList<Pair<Double, String>>();
        for (String key : metadata.keySet()) {
            Metadata other = metadata.get(key);
            double d = md.distanceTo(other);
            if (Double.isNaN(d) || other.channel.equals(channel)) continue;
            result.add(new Pair<Double, String>(new Double(d), other.channel));
        }
        Collections.sort(result, Metadata.getDistanceComparator());
        return result.size() == 0 ? null : result;
    }

    public String toString() {
        return this.channel + "," + this.alias + "," + this.unit + "," + this.multiplier + "," + this.offset + "," + this.longitude + "," + this.latitude + "," + this.height + "," + this.timeZone;
    }

    @Override
    public int compareTo(Metadata o) {
        return this.channel.compareTo(o.channel);
    }

    public Point2D.Double getLonLat() {
        return new Point2D.Double(this.longitude, this.latitude);
    }
}

