/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import gov.usgs.plot.data.Wave;
import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Kioskable;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwarmLayout;
import gov.usgs.swarm.SwarmMenu;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.chooser.DataChooser;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.heli.HelicorderViewerFrame;
import gov.usgs.swarm.internalFrame.InternalFrameListener;
import gov.usgs.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.wave.MultiMonitor;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewerFrame;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.util.ui.GlobalKeyManager;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Swarm
extends JFrame
implements InternalFrameListener {
    private static final long serialVersionUID = -1L;
    private static Swarm application;
    private static JFrame applicationFrame;
    private static JDesktopPane desktop;
    private JSplitPane split;
    private SwarmMenu swarmMenu;
    private CachedDataSource cache;
    private static final String TITLE = "Swarm";
    private static final String VERSION;
    private static final String BUILD_DATE;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int TOP = 3;
    private static final int BOTTOM = 4;
    private static final int BOTTOM_LEFT = 5;
    private static final int BOTTOM_RIGHT = 6;
    private static final int TOP_LEFT = 7;
    private static final int TOP_RIGHT = 8;
    private static boolean fullScreen;
    private int oldState = 0;
    private Dimension oldSize;
    private Point oldLocation;
    private AbstractAction toggleFullScreenAction;
    private static SwarmConfig config;
    private static Logger logger;
    private String lastLayout = "";

    public Swarm(String[] args) {
        super("Swarm [" + VERSION + "]");
        logger = Log.getLogger("gov.usgs.swarm");
        logger.setLevel(Level.ALL);
        if (BUILD_DATE == null) {
            logger.fine("no build version information available");
        } else {
            logger.fine("Swarm version/date: " + VERSION + "/" + BUILD_DATE);
        }
        application = this;
        applicationFrame = this;
        this.setIconImage(Icons.swarm.getImage());
        config = SwarmConfig.getInstance();
        config.createConfig(args);
        this.cache = CachedDataSource.getInstance();
        SwarmInternalFrames.addInternalFrameListener(this);
        this.checkJavaVersion();
        this.setupGlobalKeys();
        this.createUI();
    }

    private void checkJavaVersion() {
        String version = System.getProperty("java.version");
        logger.fine("java.version: " + version);
        if (version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4")) {
            JOptionPane.showMessageDialog(this, "Swarm " + VERSION + " requires at least Java version 1.5 or above.", "Error", 0);
            System.exit(-1);
        }
        Runtime rt = Runtime.getRuntime();
        logger.fine("maximum heap size: " + Util.numBytesToString(rt.maxMemory()));
    }

    private void setupGlobalKeys() {
        GlobalKeyManager m = GlobalKeyManager.getInstance();
        m.getInputMap().put(KeyStroke.getKeyStroke("F12"), "focus");
        m.getActionMap().put("focus", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                System.out.println("Focus check: \nCurrent window: " + kfm.getFocusedWindow() + "\n\n" + "Current component: " + kfm.getFocusOwner() + "\n");
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("alt F12"), "outputcache");
        m.getActionMap().put("outputcache", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Swarm.this.cache != null) {
                    Swarm.this.cache.output();
                }
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("ctrl L"), "savelayout");
        m.getActionMap().put("savelayout", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.saveLayout(null);
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke("ctrl shift L"), "savelastlayout");
        m.getActionMap().put("savelastlayout", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String ll = Swarm.this.swarmMenu.getLastLayoutName();
                if (ll != null) {
                    Swarm.this.saveLayout(ll);
                }
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(122, 0), "fullScreenToggle");
        m.getInputMap().put(KeyStroke.getKeyStroke(122, 128), "fullScreenToggle");
        m.getInputMap().put(KeyStroke.getKeyStroke(92, 128), "fullScreenToggle");
        this.toggleFullScreenAction = new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.toggleFullScreenMode();
            }
        };
        m.getActionMap().put("fullScreenToggle", this.toggleFullScreenAction);
        m.getInputMap().put(KeyStroke.getKeyStroke(39, 128), "flushRight");
        m.getActionMap().put("flushRight", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushRight();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(37, 128), "flushLeft");
        m.getActionMap().put("flushLeft", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushLeft();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(38, 128), "flushTop");
        m.getActionMap().put("flushTop", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushTop();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(40, 128), "flushBottom");
        m.getActionMap().put("flushBottom", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushBottom();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(34, 128), "flushBottomRight");
        m.getActionMap().put("flushBottomRight", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushBottomRight();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(35, 128), "flushBottomLeft");
        m.getActionMap().put("flushBottomLeft", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushBottomLeft();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(33, 128), "flushTopRight");
        m.getActionMap().put("flushTopRight", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushTopRight();
            }
        });
        m.getInputMap().put(KeyStroke.getKeyStroke(36, 128), "flushTopLeft");
        m.getActionMap().put("flushTopLeft", new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.this.flushTopLeft();
            }
        });
    }

    public static String getVersion() {
        return VERSION;
    }

    @Deprecated
    public static Swarm getApplication() {
        return application;
    }

    public static JFrame getApplicationFrame() {
        return applicationFrame;
    }

    private void createUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Swarm.this.closeApp();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SwarmInternalFrames.frameCount() > 0) {
                    JComponent jf = null;
                    for (int i = 0; i < SwarmInternalFrames.frameCount(); ++i) {
                        JInternalFrame f = SwarmInternalFrames.getFrames().get(i);
                        if (!(f instanceof HelicorderViewerFrame)) continue;
                        jf = f;
                        break;
                    }
                    if (jf == null) {
                        jf = SwarmInternalFrames.getFrames().get(0);
                    }
                    jf.requestFocus();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        desktop = new JDesktopPane();
        desktop.setBorder(BorderFactory.createLineBorder(DataChooser.LINE_COLOR));
        desktop.setDragMode(1);
        this.setSize(Swarm.config.windowWidth, Swarm.config.windowHeight);
        this.setLocation(Swarm.config.windowX, Swarm.config.windowY);
        if (Swarm.config.windowMaximized) {
            this.setExtendedState(6);
        }
        this.setDefaultCloseOperation(3);
        DataChooser chooser = DataChooser.getInstance();
        this.split = SwarmUtil.createStrippedSplitPane(1, chooser, desktop);
        this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
        this.split.setDividerSize(4);
        this.setChooserVisible(Swarm.config.chooserVisible);
        chooser.setDividerLocation(Swarm.config.nearestDividerLocation);
        WaveClipboardFrame waveClipboard = WaveClipboardFrame.getInstance();
        desktop.add(waveClipboard);
        waveClipboard.setVisible(Swarm.config.clipboardVisible);
        if (Swarm.config.clipboardMaximized) {
            try {
                waveClipboard.setMaximum(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MapFrame mapFrame = MapFrame.getInstance();
        SwarmInternalFrames.add(mapFrame);
        mapFrame.setVisible(Swarm.config.mapVisible);
        if (Swarm.config.mapMaximized) {
            try {
                mapFrame.setMaximum(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        mapFrame.toFront();
        this.swarmMenu = new SwarmMenu();
        this.setJMenuBar(this.swarmMenu);
        for (SwarmLayout sl : Swarm.config.layouts.values()) {
            this.swarmMenu.addLayout(sl);
        }
        this.setVisible(true);
        long offset = CurrentTime.getInstance().getOffset();
        if (Math.abs(offset) > 600000L) {
            JOptionPane.showMessageDialog(this, "You're system clock is off by more than 10 minutes.\nThis is just for your information, Swarm will not be affected by this.", "System Clock", 1);
        }
    }

    public void setChooserVisible(boolean vis) {
        if (vis) {
            this.split.setRightComponent(desktop);
            this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
            this.setContentPane(this.split);
        } else {
            if (this.isChooserVisible()) {
                Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
            }
            this.setContentPane(desktop);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.validate();
        }
    }

    public boolean isChooserVisible() {
        return this.getContentPane() == this.split;
    }

    public static boolean isFullScreenMode() {
        return fullScreen;
    }

    public void toggleFullScreenMode() {
        this.setFullScreenMode(!fullScreen);
    }

    public void setFullScreenMode(boolean full) {
        if (fullScreen == full) {
            return;
        }
        this.requestFocus();
        fullScreen = full;
        this.dispose();
        this.setUndecorated(full);
        this.setResizable(!full);
        WaveClipboardFrame waveClipboard = WaveClipboardFrame.getInstance();
        waveClipboard.setVisible(!full);
        waveClipboard.toBack();
        if (full) {
            this.setJMenuBar(null);
            Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
            this.oldState = this.getExtendedState();
            this.oldSize = this.getSize();
            this.oldLocation = this.getLocation();
            this.setContentPane(desktop);
            this.setVisible(true);
            this.setExtendedState(6);
            desktop.setSize(this.getSize());
            desktop.setPreferredSize(this.getSize());
        } else {
            this.setJMenuBar(this.swarmMenu);
            this.setExtendedState(this.oldState);
            this.setSize(this.oldSize);
            this.setLocation(this.oldLocation);
            this.setVisible(true);
            this.split.setRightComponent(desktop);
            this.split.setDividerLocation(Swarm.config.chooserDividerLocation);
            this.setContentPane(this.split);
        }
        this.validate();
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (!frame.isVisible() || !(frame instanceof Kioskable)) continue;
            Kioskable f = (Kioskable)((Object)frame);
            f.setKioskMode(full);
        }
        this.tileKioskFrames();
    }

    public void closeApp() {
        Point p = this.getLocation();
        if (this.getExtendedState() == 6) {
            Swarm.config.windowMaximized = true;
        } else {
            Dimension d = this.getSize();
            Swarm.config.windowX = p.x;
            Swarm.config.windowY = p.y;
            Swarm.config.windowWidth = d.width;
            Swarm.config.windowHeight = d.height;
            Swarm.config.windowMaximized = false;
        }
        WaveClipboardFrame waveClipboard = WaveClipboardFrame.getInstance();
        if (waveClipboard.isMaximum()) {
            Swarm.config.clipboardMaximized = true;
        } else {
            Swarm.config.clipboardX = waveClipboard.getX();
            Swarm.config.clipboardY = waveClipboard.getY();
            Swarm.config.clipboardWidth = waveClipboard.getWidth();
            Swarm.config.clipboardHeight = waveClipboard.getHeight();
            Swarm.config.clipboardMaximized = false;
        }
        Swarm.config.clipboardVisible = WaveClipboardFrame.getInstance().isVisible();
        MapFrame mapFrame = MapFrame.getInstance();
        if (mapFrame.isMaximum()) {
            Swarm.config.mapMaximized = true;
        } else {
            Swarm.config.mapX = mapFrame.getX();
            Swarm.config.mapY = mapFrame.getY();
            Swarm.config.mapWidth = mapFrame.getWidth();
            Swarm.config.mapHeight = mapFrame.getHeight();
            Swarm.config.mapMaximized = false;
        }
        Swarm.config.mapVisible = mapFrame.isVisible();
        Swarm.config.chooserDividerLocation = this.split.getDividerLocation();
        Swarm.config.chooserVisible = this.isChooserVisible();
        DataChooser chooser = DataChooser.getInstance();
        Swarm.config.nearestDividerLocation = chooser.getDividerLocation();
        Swarm.config.kiosk = Boolean.toString(fullScreen);
        Swarm.config.userTimes = chooser.getUserTimes();
        if (Swarm.config.saveConfig) {
            ConfigFile configFile = config.toConfigFile();
            configFile.remove("configFile");
            configFile.writeToFile(Swarm.config.configFilename);
        }
        waveClipboard.removeWaves();
        try {
            for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
                frame.setClosed(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void loadClipboardWave(final SeismicDataSource source, final String channel) {
        final WaveViewPanel wvp = new WaveViewPanel();
        wvp.setChannel(channel);
        wvp.setDataSource(source);
        WaveViewPanel cwvp = WaveClipboardFrame.getInstance().getSelected();
        double st = 0.0;
        double et = 0.0;
        if (cwvp == null) {
            double now = CurrentTime.getInstance().nowJ2K();
            st = now - 180.0;
            et = now;
        } else {
            st = cwvp.getStartTime();
            et = cwvp.getEndTime();
        }
        final double fst = st;
        final double fet = et;
        SwingWorker worker = new SwingWorker(){
            WaveClipboardFrame waveClipboard = WaveClipboardFrame.getInstance();

            @Override
            public Object construct() {
                this.waveClipboard.getThrobber().increment();
                Wave sw = source.getWave(channel, fst, fet);
                wvp.setWave(sw, fst, fet);
                return null;
            }

            @Override
            public void finished() {
                this.waveClipboard.getThrobber().decrement();
                this.waveClipboard.setVisible(true);
                this.waveClipboard.toFront();
                try {
                    this.waveClipboard.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.waveClipboard.addWave(wvp);
            }
        };
        worker.start();
    }

    public static WaveViewerFrame openRealtimeWave(SeismicDataSource source, String channel) {
        WaveViewerFrame frame = new WaveViewerFrame(source, channel);
        SwarmInternalFrames.add(frame);
        return frame;
    }

    public static HelicorderViewerFrame openHelicorder(SeismicDataSource source, String channel, double time) {
        source.establish();
        HelicorderViewerFrame frame = new HelicorderViewerFrame(source, channel, time);
        frame.addLinkListeners();
        SwarmInternalFrames.add(frame);
        return frame;
    }

    public void saveLayout(String name) {
        boolean fixedName = name != null;
        SwarmLayout sl = this.getCurrentLayout();
        boolean done = false;
        while (!done) {
            if (name == null) {
                name = (String)JOptionPane.showInputDialog(this, "Enter a name for this layout:", "Save Layout", 1, null, null, this.lastLayout);
            }
            if (name != null) {
                if (Swarm.config.layouts.containsKey(name)) {
                    int opt;
                    boolean overwrite = false;
                    overwrite = !fixedName ? (opt = JOptionPane.showConfirmDialog(this, "A layout by that name already exists.  Overwrite?", "Warning", 0)) == 0 : true;
                    if (overwrite) {
                        if (fixedName) {
                            JOptionPane.showMessageDialog(this, "Layout overwritten.");
                        }
                        this.swarmMenu.removeLayout((SwarmLayout)Swarm.config.layouts.get(name));
                        config.removeLayout((SwarmLayout)Swarm.config.layouts.get(name));
                    }
                }
                if (Swarm.config.layouts.containsKey(name)) continue;
                this.swarmMenu.setLastLayoutName(name);
                sl.setName(name);
                sl.save();
                this.swarmMenu.addLayout(sl);
                config.addLayout(sl);
                done = true;
                this.lastLayout = name;
                continue;
            }
            done = true;
        }
    }

    public SwarmLayout getCurrentLayout() {
        ConfigFile cf = new ConfigFile();
        cf.put("name", "Current Layout");
        cf.put("kiosk", Boolean.toString(Swarm.isFullScreenMode()));
        cf.put("kioskX", Integer.toString(this.getX()));
        cf.put("kioskY", Integer.toString(this.getY()));
        DataChooser.getInstance().saveLayout(cf, "chooser");
        SwarmLayout sl = new SwarmLayout(cf);
        int i = 0;
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (frame instanceof HelicorderViewerFrame) {
                HelicorderViewerFrame hvf = (HelicorderViewerFrame)frame;
                hvf.saveLayout(cf, "helicorder-" + i++);
                continue;
            }
            if (!(frame instanceof MultiMonitor)) continue;
            MultiMonitor mm = (MultiMonitor)frame;
            mm.saveLayout(cf, "monitor-" + i++);
        }
        MapFrame mapFrame = MapFrame.getInstance();
        if (mapFrame.isVisible()) {
            mapFrame.saveLayout(cf, "map");
        }
        return sl;
    }

    public void flush(int position) {
        Dimension ds = desktop.getSize();
        JInternalFrame bingo = null;
        WaveClipboardFrame waveClipboard = WaveClipboardFrame.getInstance();
        if (waveClipboard.isSelected()) {
            bingo = waveClipboard;
        } else {
            for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
                if (!frame.isSelected()) continue;
                bingo = frame;
            }
        }
        if (bingo != null) {
            switch (position) {
                case 1: {
                    bingo.setSize(ds.width / 2, ds.height);
                    bingo.setLocation(0, 0);
                    break;
                }
                case 2: {
                    bingo.setSize(ds.width / 2, ds.height);
                    bingo.setLocation(ds.width / 2, 0);
                    break;
                }
                case 3: {
                    bingo.setSize(ds.width, ds.height / 2);
                    bingo.setLocation(0, 0);
                    break;
                }
                case 4: {
                    bingo.setSize(ds.width, ds.height / 2);
                    bingo.setLocation(0, ds.height / 2);
                    break;
                }
                case 5: {
                    bingo.setSize(ds.width / 2, ds.height / 2);
                    bingo.setLocation(0, ds.height / 2);
                    break;
                }
                case 6: {
                    bingo.setSize(ds.width / 2, ds.height / 2);
                    bingo.setLocation(ds.width / 2, ds.height / 2);
                    break;
                }
                case 7: {
                    bingo.setSize(ds.width / 2, ds.height / 2);
                    bingo.setLocation(0, 0);
                    break;
                }
                case 8: {
                    bingo.setSize(ds.width / 2, ds.height / 2);
                    bingo.setLocation(ds.width / 2, 0);
                }
            }
        }
    }

    public void flushLeft() {
        this.flush(1);
    }

    public void flushRight() {
        this.flush(2);
    }

    public void flushTop() {
        this.flush(3);
    }

    public void flushBottom() {
        this.flush(4);
    }

    public void flushBottomRight() {
        this.flush(6);
    }

    public void flushBottomLeft() {
        this.flush(5);
    }

    public void flushTopRight() {
        this.flush(8);
    }

    public void flushTopLeft() {
        this.flush(7);
    }

    public void tileKioskFrames() {
        Dimension ds = desktop.getSize();
        ArrayList<JInternalFrame> ks = new ArrayList<JInternalFrame>();
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (!frame.isVisible() || !(frame instanceof Kioskable)) continue;
            ks.add(frame);
        }
        if (ks.size() == 0) {
            return;
        }
        int mapCount = 0;
        int heliCount = 0;
        int monitorCount = 0;
        for (JInternalFrame frame : ks) {
            if (frame instanceof MapFrame) {
                ++mapCount;
                continue;
            }
            if (frame instanceof HelicorderViewerFrame) {
                ++heliCount;
                continue;
            }
            if (!(frame instanceof MultiMonitor)) continue;
            ++monitorCount;
        }
        if (ks.size() == 4) {
            int w = ds.width / 2;
            int h = ds.height / 2;
            JInternalFrame hvf0 = (JInternalFrame)ks.get(0);
            JInternalFrame hvf1 = (JInternalFrame)ks.get(1);
            JInternalFrame hvf2 = (JInternalFrame)ks.get(2);
            JInternalFrame hvf3 = (JInternalFrame)ks.get(3);
            hvf0.setSize(w, h);
            hvf0.setLocation(0, 0);
            hvf1.setSize(w, h);
            hvf1.setLocation(w, 0);
            hvf2.setSize(w, h);
            hvf2.setLocation(0, h);
            hvf3.setSize(w, h);
            hvf3.setLocation(w, h);
        } else if (ks.size() == 3 && mapCount == 1 && heliCount == 1 && monitorCount == 1) {
            int w = ds.width / 2;
            int h = ds.height / 2;
            for (JInternalFrame frame : ks) {
                if (frame instanceof MapFrame) {
                    frame.setLocation(w, h);
                    frame.setSize(w, h);
                    continue;
                }
                if (frame instanceof HelicorderViewerFrame) {
                    frame.setLocation(0, 0);
                    frame.setSize(w, h * 2);
                    continue;
                }
                if (!(frame instanceof MultiMonitor)) continue;
                frame.setLocation(w, 0);
                frame.setSize(w, h);
            }
        } else {
            int w = ds.width / ks.size();
            int cx = 0;
            for (int i = 0; i < ks.size(); ++i) {
                JInternalFrame hvf = (JInternalFrame)ks.get(i);
                try {
                    hvf.setIcon(false);
                    hvf.setMaximum(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                hvf.setSize(w, ds.height);
                hvf.setLocation(cx, 0);
                cx += w;
            }
        }
    }

    public void tileHelicorders() {
        Dimension ds = desktop.getSize();
        ArrayList<HelicorderViewerFrame> hcs = new ArrayList<HelicorderViewerFrame>(10);
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (!(frame instanceof HelicorderViewerFrame)) continue;
            hcs.add((HelicorderViewerFrame)frame);
        }
        if (hcs.size() == 0) {
            return;
        }
        if (hcs.size() == 4) {
            int w = ds.width / 2;
            int h = ds.height / 2;
            HelicorderViewerFrame hvf0 = (HelicorderViewerFrame)hcs.get(0);
            HelicorderViewerFrame hvf1 = (HelicorderViewerFrame)hcs.get(1);
            HelicorderViewerFrame hvf2 = (HelicorderViewerFrame)hcs.get(2);
            HelicorderViewerFrame hvf3 = (HelicorderViewerFrame)hcs.get(3);
            hvf0.setSize(w, h);
            hvf0.setLocation(0, 0);
            hvf1.setSize(w, h);
            hvf1.setLocation(w, 0);
            hvf2.setSize(w, h);
            hvf2.setLocation(0, h);
            hvf3.setSize(w, h);
            hvf3.setLocation(w, h);
        } else {
            int w = ds.width / hcs.size();
            int cx = 0;
            for (int i = 0; i < hcs.size(); ++i) {
                HelicorderViewerFrame hvf = (HelicorderViewerFrame)hcs.get(i);
                try {
                    hvf.setIcon(false);
                    hvf.setMaximum(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                hvf.setSize(w, ds.height);
                hvf.setLocation(cx, 0);
                cx += w;
            }
        }
    }

    public void tileWaves() {
        Dimension ds = desktop.getSize();
        int wc = 0;
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (!(frame instanceof WaveViewerFrame)) continue;
            ++wc;
        }
        if (wc == 0) {
            return;
        }
        int h = ds.height / wc;
        int cy = 0;
        for (JInternalFrame frame : SwarmInternalFrames.getFrames()) {
            if (!(frame instanceof WaveViewerFrame)) continue;
            WaveViewerFrame wvf = (WaveViewerFrame)frame;
            try {
                wvf.setIcon(false);
                wvf.setMaximum(false);
            }
            catch (Exception e) {
                // empty catch block
            }
            wvf.setSize(ds.width, h);
            wvf.setLocation(0, cy);
            cy += h;
        }
    }

    public static void setFrameLayer(JInternalFrame c, int layer) {
        desktop.setLayer(c, layer, 0);
    }

    private void parseKiosk() {
        String[] kiosks = Swarm.config.kiosk.split(",");
        if (Swarm.config.kiosk.startsWith("layout:")) {
            String layout = Swarm.config.kiosk.substring(7);
            SwarmLayout sl = (SwarmLayout)Swarm.config.layouts.get(layout);
            if (sl != null) {
                this.lastLayout = layout;
                sl.process();
            } else {
                logger.warning("could not start with layout: " + layout);
            }
        }
        boolean set = false;
        for (int i = 0; i < kiosks.length; ++i) {
            String[] ch = kiosks[i].split(";");
            SeismicDataSource sds = config.getSource(ch[0]);
            if (sds == null) continue;
            Swarm.openHelicorder(sds, ch[1], Double.NaN);
            set = true;
        }
        if (Swarm.config.kiosk.equals("true")) {
            set = true;
        }
        if (set) {
            this.toggleFullScreenMode();
        } else {
            logger.warning("no helicorders, skipping kiosk mode.");
        }
    }

    @Override
    public void internalFrameAdded(final JInternalFrame f) {
        desktop.add(f);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                f.toFront();
                try {
                    f.setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void internalFrameRemoved(JInternalFrame f) {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            UIManager.put("InternalFrame.border", SwarmUtil.getInternalFrameBorder());
        }
        catch (Exception e) {
            // empty catch block
        }
        Swarm swarm = new Swarm(args);
        if (config.isKiosk()) {
            swarm.parseKiosk();
        }
    }

    static {
        String[] ss = Util.getVersion("gov.usgs.swarm");
        if (ss != null && ss.length >= 2) {
            VERSION = ss[0];
            BUILD_DATE = ss[1];
        } else {
            VERSION = "Development";
            BUILD_DATE = null;
        }
        fullScreen = false;
    }
}

