/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data;

import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.net.ReadListener;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.Instrument;
import gov.usgs.winston.server.WWSClient;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WWSSource
extends SeismicDataSource {
    private String params;
    private WWSClient winstonClient;
    private int timeout = 2000;
    private boolean compress = false;
    private int protocolVersion = 1;
    private String server;
    private int port;
    private boolean established;

    public WWSSource() {
    }

    public WWSSource(WWSSource wws) {
        this.name = wws.name;
        this.parse(wws.params);
        this.protocolVersion = wws.protocolVersion;
    }

    @Override
    public void parse(String params) {
        this.params = params;
        String[] ss = params.split(":");
        this.server = ss[0];
        this.port = Integer.parseInt(ss[1]);
        this.timeout = Integer.parseInt(ss[2]);
        this.compress = ss[3].equals("1");
        this.winstonClient = new WWSClient(this.server, this.port);
        this.setTimeout(this.timeout);
    }

    @Override
    public SeismicDataSource getCopy() {
        return new WWSSource(this);
    }

    @Override
    public void establish() {
        if (!this.established) {
            this.protocolVersion = this.winstonClient.getProtocolVersion();
            this.established = true;
        }
    }

    @Override
    public String toConfigString() {
        String typeString = DataSourceType.getShortName(this.getClass());
        return String.format("%s;" + typeString + ":%s:%d:%d:%s", this.name, this.server, this.port, this.timeout, this.compress ? "1" : "0");
    }

    public synchronized void setTimeout(int to) {
        this.winstonClient.setTimeout(to);
    }

    @Override
    public void close() {
        if (this.winstonClient != null) {
            this.winstonClient.close();
        }
    }

    public String getFormattedSCNL(MenuItem mi) {
        return mi.getSCNSCNL(" ");
    }

    public List<String> getMenuList(List<MenuItem> items) {
        ArrayList<String> list = new ArrayList<String>(items.size());
        for (MenuItem mi : items) {
            list.add(this.getFormattedSCNL(mi));
        }
        return list;
    }

    public String[] parseSCNL(String channel) {
        String[] result = new String[4];
        String token = channel.indexOf("$") != -1 ? "$" : " ";
        StringTokenizer st = new StringTokenizer(channel, token);
        result[0] = st.nextToken();
        result[1] = st.nextToken();
        result[2] = st.nextToken();
        result[3] = st.hasMoreTokens() ? st.nextToken() : "--";
        return result;
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        Wave wave = null;
        if (this.useCache) {
            CachedDataSource cache = CachedDataSource.getInstance();
            wave = cache.getWave(station, t1, t2);
        }
        if (wave == null) {
            String[] scnl = this.parseSCNL(station);
            if (this.protocolVersion == 1) {
                wave = this.winstonClient.getRawData(scnl[0], scnl[1], scnl[2], scnl[3], Util.j2KToEW(t1), Util.j2KToEW(t2));
                if (wave != null) {
                    wave.convertToJ2K();
                }
            } else {
                wave = this.winstonClient.getWave(scnl[0], scnl[1], scnl[2], scnl[3], t1, t2, this.compress);
            }
            if (wave == null) {
                return null;
            }
            wave.register();
            if (this.useCache) {
                CachedDataSource cache = CachedDataSource.getInstance();
                cache.putWave(station, wave);
            }
        }
        return wave;
    }

    @Override
    public synchronized HelicorderData getHelicorder(final String station, double t1, double t2, GulperListener gl) {
        CachedDataSource cache = CachedDataSource.getInstance();
        HelicorderData hd = cache.getHelicorder(station, t1, t2, this);
        if (hd == null) {
            String[] scnl = this.parseSCNL(station);
            this.fireHelicorderProgress(station, -1.0);
            this.winstonClient.setReadListener(new ReadListener(){

                @Override
                public void readProgress(double p) {
                    WWSSource.this.fireHelicorderProgress(station, p);
                }
            });
            hd = this.winstonClient.getHelicorder(scnl[0], scnl[1], scnl[2], scnl[3], t1, t2, this.compress);
            this.winstonClient.setReadListener(null);
            this.fireHelicorderProgress(station, 1.0);
            if (hd != null && hd.rows() != 0) {
                HelicorderData noLatest = hd.subset(hd.getStartTime(), CurrentTime.getInstance().nowJ2K() - 30.0);
                if (noLatest != null && noLatest.rows() > 0) {
                    cache.putHelicorder(station, noLatest);
                }
            } else {
                hd = null;
            }
        }
        return hd;
    }

    @Override
    public synchronized List<String> getChannels() {
        SwarmConfig swarmConfig = SwarmConfig.getInstance();
        if (this.protocolVersion == 1) {
            Menu menu = this.winstonClient.getMenuSCNL();
            List<String> channels = this.getMenuList(menu.getSortedItems());
            swarmConfig.assignMetadataSource(channels, this);
            return channels;
        }
        if (this.protocolVersion == 2) {
            List<Channel> channels = this.winstonClient.getChannels();
            ArrayList<String> result = new ArrayList<String>(channels.size());
            for (Channel ch : channels) {
                String code = ch.getCode().replace('$', ' ');
                Metadata md = swarmConfig.getMetadata(code, true);
                Instrument ins = ch.getInstrument();
                md.updateLongitude(ins.getLongitude());
                md.updateLatitude(ins.getLatitude());
                md.source = this;
                result.add(code);
            }
            return result;
        }
        if (this.protocolVersion == 3) {
            List<Channel> channels = this.winstonClient.getChannels(true);
            ArrayList<String> result = new ArrayList<String>(channels.size());
            for (Channel ch : channels) {
                String code = ch.getCode().replace('$', ' ');
                Metadata md = swarmConfig.getMetadata(code, true);
                Instrument ins = ch.getInstrument();
                md.updateLongitude(ins.getLongitude());
                md.updateLatitude(ins.getLatitude());
                List<String> groups = ch.getGroups();
                if (groups != null) {
                    for (String g : groups) {
                        md.addGroup(g);
                    }
                }
                md.updateLinearCoefficients(ch.getLinearA(), ch.getLinearB());
                md.updateAlias(ch.getAlias());
                md.updateUnits(ch.getUnit());
                md.updateTimeZone(ch.getInstrument().getTimeZone());
                md.source = this;
                result.add(code);
            }
            return result;
        }
        return null;
    }

    @Override
    public synchronized boolean isActiveSource() {
        return true;
    }
}

