/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.fdsnWs;

import gov.usgs.swarm.StationInfo;
import gov.usgs.swarm.data.fdsnWs.AbstractWebServiceStationClient;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;

public class WebServiceStationTextClient
extends AbstractWebServiceStationClient {
    public static WebServiceStationTextClient createClient(String[] args) {
        String baseUrlText = WebServiceStationTextClient.getArg(args, 0, "http://service.iris.edu/fdsnws/station/1/query");
        String net = WebServiceStationTextClient.getArg(args, 1);
        String sta = WebServiceStationTextClient.getArg(args, 2);
        String loc = WebServiceStationTextClient.getArg(args, 3);
        String chan = WebServiceStationTextClient.getArg(args, 4);
        Date date = WebServiceUtils.parseDate(WebServiceStationTextClient.getArg(args, 5));
        return new WebServiceStationTextClient(baseUrlText, net, sta, loc, chan, date);
    }

    public static void main(String[] args) {
        String error = null;
        WebServiceStationTextClient client = WebServiceStationTextClient.createClient(args);
        try {
            client.setStationList(WebServiceStationTextClient.createStationList());
            error = client.fetchStations();
            if (error == null) {
                List<StationInfo> stationList = client.getStationList();
                System.out.println("station count: " + stationList.size());
                for (StationInfo station : stationList) {
                    System.out.println("station: " + station);
                    client.setCurrentStation(station);
                    error = client.fetchChannels();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (error != null) {
            System.out.println(error);
        } else {
            System.out.println("done");
        }
    }

    public WebServiceStationTextClient(String baseUrlText, String net, String sta, String loc, String chan, Date date) {
        super(baseUrlText, net, sta, loc, chan, date);
    }

    @Override
    protected void fetch(URL url) throws Exception {
        String line;
        while ((line = this.getReader().readLine()) != null) {
            this.processLine(line);
        }
    }

    @Override
    protected String getBaseUrlText() {
        String urlText = super.getBaseUrlText();
        urlText = this.append(urlText, "output", "text");
        return urlText;
    }

    protected String getColumnText(String[] columns, int index) {
        String s = null;
        if (index >= 0 && index < columns.length) {
            s = columns[index];
        }
        return s;
    }

    protected String getLineSplitText() {
        return "\\s*\\|\\s*";
    }

    protected void processLine(String line) {
        if (line.startsWith("#")) {
            return;
        }
        if (line.matches("^" + this.getLineSplitText() + ".*")) {
            WebServiceUtils.fine("skipping line (" + line + ")");
            return;
        }
        String[] columns = this.split(line);
        switch (this.getLevel()) {
            case STATION: {
                int minNumColumns = 6;
                if (columns.length < minNumColumns) {
                    this.error.append("invalid line (" + line + ")\n");
                    break;
                }
                String network = this.getColumnText(columns, 0);
                String station = this.getColumnText(columns, 1);
                double latitude = StationInfo.parseDouble(this.getColumnText(columns, 2));
                double longitude = StationInfo.parseDouble(this.getColumnText(columns, 3));
                String siteName = this.getColumnText(columns, 5);
                this.processStation(this.createStationInfo(station, network, latitude, longitude, siteName));
                break;
            }
            case CHANNEL: {
                int minNumColumns = 6;
                if (columns.length < minNumColumns) {
                    this.error.append("invalid line (" + line + ")\n");
                    break;
                }
                String network = this.getColumnText(columns, 0);
                String station = this.getColumnText(columns, 1);
                String location = this.getColumnText(columns, 2);
                String channel = this.getColumnText(columns, 3);
                String siteName = null;
                double latitude = StationInfo.parseDouble(this.getColumnText(columns, 4));
                double longitude = StationInfo.parseDouble(this.getColumnText(columns, 5));
                this.processChannel(this.createChannelInfo(station, channel, network, location, latitude, longitude, siteName, this.groupsType));
                break;
            }
        }
    }

    protected String[] split(String line) {
        return line.split(this.getLineSplitText());
    }
}

