/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.fdsnWs;

import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.swarm.ChannelGroupInfo;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.GulperList;
import gov.usgs.swarm.data.GulperListener;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import gov.usgs.swarm.data.fdsnWs.WebServicesClient;
import gov.usgs.util.CurrentTime;
import java.util.Collections;
import java.util.List;

public class WebServicesSource
extends SeismicDataSource {
    public static final String TAB_TITLE = "IRIS WS";
    public static final String DESCRIPTION = "an IRIS Web Services server";
    public static final String typeString;
    public static final String PARAM_SPLIT_TEXT = "\\|";
    public static final String PARAM_FMT_TEXT = "%s|%s|%s|%s|%d|%d|%s|%s";
    private static int counter;
    private String chan;
    private WebServicesClient client;
    private final int count = ++counter;
    private int gulpDelay;
    private int gulpSize;
    private String loc;
    private String net;
    private String params;
    private String sta;
    private String wsDataSelectUrl;
    private String wsStationUrl;

    public WebServicesSource() {
    }

    @Override
    public void parse(String params) {
        this.params = params;
        String[] ss = params.split(PARAM_SPLIT_TEXT);
        int ssIndex = 0;
        this.net = ss[ssIndex++];
        this.sta = ss[ssIndex++];
        this.loc = ss[ssIndex++];
        this.chan = ss[ssIndex++];
        this.gulpSize = Integer.parseInt(ss[ssIndex++]);
        this.gulpDelay = Integer.parseInt(ss[ssIndex++]);
        this.wsDataSelectUrl = ss[ssIndex++];
        this.wsStationUrl = ss[ssIndex++];
        this.client = new WebServicesClient(this, this.net, this.sta, this.loc, this.chan, this.wsDataSelectUrl, this.wsStationUrl);
        if (WebServiceUtils.isDebug()) {
            WebServiceUtils.debug("web service started " + this.count);
        }
    }

    public WebServicesSource(WebServicesSource sls) {
        this.name = sls.name;
        this.parse(sls.params);
    }

    @Override
    public synchronized void close() {
        if (WebServiceUtils.isDebug()) {
            WebServiceUtils.debug("web service closed " + this.count);
        }
    }

    @Override
    public synchronized List<String> getChannels() {
        List<String> channels = this.client.getChannels();
        return Collections.unmodifiableList(channels);
    }

    @Override
    public SeismicDataSource getCopy() {
        return new WebServicesSource(this);
    }

    private String getGulperKey(String station) {
        return typeString + ":" + station;
    }

    @Override
    public synchronized HelicorderData getHelicorder(String station, double t1, double t2, GulperListener gl) {
        double now = CurrentTime.getInstance().nowJ2K();
        CachedDataSource cache = CachedDataSource.getInstance();
        HelicorderData hd = cache.getHelicorder(station, t1, t2, (GulperListener)null);
        if (hd == null || hd.rows() == 0 || hd.getStartTime() - t1 > 10.0) {
            GulperList.INSTANCE.requestGulper(this.getGulperKey(station), gl, this, station, t1, t2, this.gulpSize, this.gulpDelay);
        }
        if (hd != null && hd.getEndTime() < now) {
            this.getWave(station, hd.getEndTime(), now);
        }
        return hd;
    }

    @Override
    public synchronized Wave getWave(String station, double t1, double t2) {
        CachedDataSource cache = CachedDataSource.getInstance();
        Wave sw = null;
        if (this.useCache) {
            sw = cache.getWave(station, t1, t2);
        }
        if (sw == null) {
            ChannelGroupInfo channelInfo = new ChannelGroupInfo(station);
            sw = this.client.getRawData(channelInfo, t1, t2);
            if (sw == null) {
                return null;
            }
            if (this.useCache) {
                cache.cacheWaveAsHelicorder(station, sw);
                cache.putWave(station, sw);
            }
        }
        return sw;
    }

    @Override
    public synchronized boolean isActiveSource() {
        return true;
    }

    @Override
    public synchronized void notifyDataNotNeeded(String station, double t1, double t2, GulperListener gl) {
        GulperList.INSTANCE.killGulper(this.getGulperKey(station), gl);
    }

    @Override
    public String toConfigString() {
        return String.format("%s;%s:%s|%s|%s|%s|%d|%d|%s|%s", this.name, typeString, this.net, this.sta, this.loc, this.chan, this.gulpSize, this.gulpDelay, this.wsDataSelectUrl, this.wsStationUrl);
    }

    static {
        counter = 0;
        typeString = DataSourceType.getShortName(WebServicesSource.class);
    }
}

