/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.seedLink;

import gov.usgs.swarm.data.seedLink.orfeus.BaseSLLog;
import gov.usgs.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SeedLinkLog
extends BaseSLLog {
    private static final String LOG_PREFIX;
    public static final Logger logger;

    public SeedLinkLog() {
        this.setErrPrefix(LOG_PREFIX);
        this.setLogPrefix(LOG_PREFIX);
    }

    public void log(boolean isError, int verbosity, String message) {
        Level level;
        if (isError) {
            message = this.errPrefix + message;
            level = Level.INFO;
        } else {
            message = this.logPrefix + message;
            switch (verbosity) {
                case 0: {
                    level = Level.INFO;
                    break;
                }
                case 1: {
                    level = Level.FINE;
                    break;
                }
                case 2: {
                    level = Level.FINER;
                    break;
                }
                default: {
                    level = Level.FINEST;
                }
            }
        }
        logger.log(level, message);
    }

    public void setLevel(Level newLevel) {
        logger.setLevel(newLevel);
    }

    static {
        logger = Log.getLogger("gov.usgs.swarm.data.SeedLinkLog");
        logger.setLevel(Level.FINE);
        LOG_PREFIX = "SeedLink: ";
    }
}

