/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.heli;

import gov.usgs.plot.Plot;
import gov.usgs.plot.PlotException;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.decorate.SmartTick;
import gov.usgs.plot.render.AxisRenderer;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.HelicorderRenderer;
import gov.usgs.plot.render.TextRenderer;
import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.heli.HelicorderViewPanelListener;
import gov.usgs.swarm.heli.HelicorderViewerFrame;
import gov.usgs.swarm.heli.HelicorderViewerSettings;
import gov.usgs.swarm.options.SwarmOptions;
import gov.usgs.swarm.options.SwarmOptionsListener;
import gov.usgs.swarm.time.UiTime;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.swarm.wave.WaveViewPanel;
import gov.usgs.swarm.wave.WaveViewPanelAdapter;
import gov.usgs.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class HelicorderViewPanel
extends JComponent
implements SwarmOptionsListener {
    private static final Color BACKGROUND_COLOR = new Color(247, 247, 247);
    public static final long serialVersionUID = -1L;
    public static final int X_OFFSET = 70;
    public static final int Y_OFFSET = 10;
    public static final int RIGHT_WIDTH = 70;
    public static final int BOTTOM_HEIGHT = 35;
    private int insetHeight = 200;
    private Plot plot;
    private HelicorderRenderer heliRenderer;
    private HelicorderViewerSettings settings;
    private HelicorderData heliData;
    private double startTime;
    private double endTime;
    private double mean;
    private double bias;
    private HelicorderViewerFrame parent;
    private double[] translation;
    private WaveViewPanel insetWavePanel;
    private BufferedImage bufferImage;
    private BufferedImage displayImage;
    private DateFormat dateFormat;
    private boolean working;
    private boolean resized;
    private int insetY;
    private boolean fullScreen;
    private boolean minimal;
    private double startMark = Double.NaN;
    private double endMark = Double.NaN;
    private double lastMark = Double.NaN;
    private EventListenerList listeners = new EventListenerList();
    private static SwarmConfig swarmConfig;
    private static final Color DARK_GREEN;

    public HelicorderViewPanel(HelicorderViewerFrame hvf) {
        swarmConfig = SwarmConfig.getInstance();
        this.parent = hvf;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.plot = new Plot();
        this.plot.setBackgroundColor(BACKGROUND_COLOR);
        this.settings = hvf.getHelicorderViewerSettings();
        this.heliRenderer = new HelicorderRenderer();
        if (HelicorderViewPanel.swarmConfig.heliColors != null) {
            this.heliRenderer.setDefaultColors(HelicorderViewPanel.swarmConfig.heliColors);
        }
        this.heliRenderer.setExtents(0.0, 1.0, Double.MAX_VALUE, -1.7976931348623157E308);
        this.plot.addRenderer(this.heliRenderer);
        this.setRequestFocusEnabled(true);
        this.addMouseListener(new HelicorderMouseListener());
        this.addMouseMotionListener(new HelicorderMouseMotionListener());
        this.addMouseWheelListener(new HelicorderMouseWheelListener());
        this.cursorChanged();
        SwarmOptions.addOptionsListener(this);
    }

    public void addListener(HelicorderViewPanelListener listener) {
        this.listeners.add(HelicorderViewPanelListener.class, listener);
    }

    public void removeListener(HelicorderViewPanelListener listener) {
        this.listeners.remove(HelicorderViewPanelListener.class, listener);
    }

    public void fireInsetCreated(double st, double et) {
        Object[] ls = this.listeners.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != HelicorderViewPanelListener.class) continue;
            ((HelicorderViewPanelListener)ls[i + 1]).insetCreated(st, et);
        }
    }

    public void cursorChanged() {
        Cursor crosshair = new Cursor(1);
        if (HelicorderViewPanel.swarmConfig.useLargeCursor) {
            Image cursorImg = Icons.crosshair.getImage();
            crosshair = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(16, 16), "Large crosshair");
        }
        this.setCursor(crosshair);
    }

    public void settingsChanged() {
        if (this.insetWavePanel != null) {
            double zoomOffset = this.parent.getHelicorderViewerSettings().waveZoomOffset;
            double j2k = this.insetWavePanel.getStartTime() + (this.insetWavePanel.getEndTime() - this.insetWavePanel.getStartTime()) / 2.0;
            this.loadInsetWave(j2k - zoomOffset, j2k + zoomOffset);
        }
        this.repaint();
    }

    public void setStartMark(double t) {
        this.startMark = t;
    }

    public void setEndMark(double t) {
        this.endMark = t;
    }

    public void clearMarks() {
        this.endMark = Double.NaN;
        this.startMark = Double.NaN;
    }

    public void setCursorMark(double t) {
        if (this.insetWavePanel != null) {
            this.insetWavePanel.setCursorMark(t);
        }
    }

    public void markTime(double t) {
        if (Double.isNaN(this.startMark) && Double.isNaN(this.endMark)) {
            this.startMark = t;
        } else if (!Double.isNaN(this.startMark) && Double.isNaN(this.endMark)) {
            this.endMark = t;
            if (this.endMark < this.startMark) {
                double tm = this.startMark;
                this.startMark = this.endMark;
                this.endMark = tm;
            }
        } else {
            this.startMark = Math.min(this.lastMark, t);
            this.endMark = Math.max(this.lastMark, t);
        }
        this.lastMark = t;
        if (this.insetWavePanel != null) {
            this.insetWavePanel.setMarks(this.startMark, this.endMark);
        }
        this.repaint();
    }

    public boolean hasInset() {
        return this.insetWavePanel != null;
    }

    public HelicorderData getData() {
        return this.heliData;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void insetToClipboard() {
        if (this.insetWavePanel != null) {
            WaveViewPanel p = new WaveViewPanel(this.insetWavePanel);
            p.setDataSource(this.insetWavePanel.getDataSource().getCopy());
            WaveClipboardFrame cb = WaveClipboardFrame.getInstance();
            cb.setVisible(true);
            cb.addWave(p);
            this.requestFocus();
        }
    }

    private void processMousePosition(int x, int y) {
        if (this.heliData == null) {
            return;
        }
        String status = null;
        boolean wp = false;
        if (this.insetWavePanel != null) {
            Point loc = this.insetWavePanel.getLocation();
            wp = this.insetWavePanel.processMousePosition(x - loc.x, y - loc.y);
        }
        if (!wp) {
            if (status == null && x >= this.heliRenderer.getGraphX() && y >= this.heliRenderer.getGraphY() && x <= this.heliRenderer.getGraphX() + this.heliRenderer.getGraphWidth() - 1 && y <= this.heliRenderer.getGraphY() + this.heliRenderer.getGraphHeight() - 1) {
                double j2k = this.getMouseJ2K(x, y);
                status = this.dateFormat.format(Util.j2KToDate(j2k));
                TimeZone tz = swarmConfig.getTimeZone(this.settings.channel);
                double tzo = tz.getOffset((long)(Util.j2KToEW(j2k) * 1000.0)) / 1000;
                if (tzo != 0.0) {
                    String tza = tz.getDisplayName(tz.inDaylightTime(Util.j2KToDate(j2k)), 0);
                    status = this.dateFormat.format(Util.j2KToDate(j2k + tzo)) + " (" + tza + "), " + status + " (UTC)";
                }
            }
            if (status == null) {
                status = " ";
            }
            if (!Double.isNaN(this.startMark) && !Double.isNaN(this.endMark)) {
                double dur = Math.abs(this.startMark - this.endMark);
                String pre = String.format("Duration: %.2fs (Md: %.2f)", dur, swarmConfig.getDurationMagnitude(dur));
                status = status.length() > 2 ? pre + ", " + status : pre;
            }
            if (status != null) {
                this.parent.setStatus(status);
            }
        }
    }

    public double getMouseJ2K(int mx, int my) {
        double j2k = 0.0;
        if (this.translation != null) {
            j2k = this.translation[4];
            j2k += ((double)mx - this.translation[0]) * this.translation[7];
            j2k += (double)this.getHelicorderRow(my) * this.translation[6];
        }
        return j2k;
    }

    public int getHelicorderRow(int my) {
        return (int)Math.floor(((double)my - this.translation[3]) / this.translation[2]);
    }

    public void removeWaveInset() {
        if (this.insetWavePanel != null) {
            this.parent.setInsetButtonsEnabled(false);
            this.remove(this.insetWavePanel);
            this.insetWavePanel = null;
            this.repaint();
        }
    }

    public void moveInset(int offset) {
        if (this.insetWavePanel != null) {
            double st = this.insetWavePanel.getStartTime();
            double et = this.insetWavePanel.getEndTime();
            double dt = et - st;
            double nst = st + dt * (double)offset;
            double net = et + dt * (double)offset;
            int row = this.heliRenderer.getRow(st + dt * (double)offset + dt / 2.0);
            if (row < 0 || row >= this.heliRenderer.getNumRows()) {
                return;
            }
            this.loadInsetWave(nst, net);
            int height = this.insetHeight;
            if ((double)row * this.translation[2] + this.translation[3] > (double)height + this.translation[3]) {
                int y = (int)Math.ceil((double)(row - 1) * this.translation[2] + this.translation[3]);
                this.insetWavePanel.setLocation(0, y - height);
            } else {
                int y = (int)Math.ceil((double)(row + 2) * this.translation[2] + this.translation[3]);
                this.insetWavePanel.setLocation(0, y);
            }
        }
    }

    public void createWaveInset(double j2k, int mx, int my) {
        int y;
        if (this.working) {
            return;
        }
        this.insetY = my;
        if (this.insetWavePanel == null) {
            this.insetWavePanel = new WaveViewPanel(this.parent.getWaveViewSettings());
            this.insetWavePanel.addListener(new WaveViewPanelAdapter(){

                @Override
                public void waveClosed(WaveViewPanel src) {
                    HelicorderViewPanel.this.removeWaveInset();
                }

                @Override
                public void waveTimePressed(WaveViewPanel src, MouseEvent e, double j2k) {
                    if (swarmConfig.durationEnabled && SwingUtilities.isLeftMouseButton(e)) {
                        HelicorderViewPanel.this.markTime(j2k);
                    }
                    HelicorderViewPanel.this.insetWavePanel.processMousePosition(e.getX(), e.getY());
                }
            });
        }
        this.insetWavePanel.setMarks(this.startMark, this.endMark);
        this.insetWavePanel.setChannel(this.settings.channel);
        this.insetWavePanel.setDataSource(this.parent.getDataSource());
        this.insetWavePanel.setStatusLabel(this.parent.getStatusLabel());
        Dimension d = this.getSize();
        int height = this.insetHeight = this.getHeight() / 4;
        int row = this.heliRenderer.getRow(j2k);
        this.insetWavePanel.setSize(d.width + 2, height);
        if ((double)this.insetY - this.heliRenderer.getRowHeight() > (double)height + this.translation[3]) {
            y = (int)Math.ceil((double)(row - 1) * this.translation[2] + this.translation[3]);
            this.insetWavePanel.setLocation(-1, y - height);
        } else {
            y = (int)Math.ceil((double)(row + 2) * this.translation[2] + this.translation[3]);
            this.insetWavePanel.setLocation(-1, y);
        }
        this.insetWavePanel.setAllowClose(true);
        this.insetWavePanel.setWorking(true);
        double zoomOffset = this.parent.getHelicorderViewerSettings().waveZoomOffset;
        this.loadInsetWave(j2k - zoomOffset, j2k + zoomOffset);
        this.parent.setInsetButtonsEnabled(true);
        this.add(this.insetWavePanel);
        this.repaint();
    }

    private void loadInsetWave(final double st, final double et) {
        this.fireInsetCreated(st, et);
        SwingWorker worker = new SwingWorker(){
            private Wave sw;

            @Override
            public Object construct() {
                HelicorderViewPanel.this.parent.getThrobber().increment();
                HelicorderViewPanel.this.working = true;
                this.sw = HelicorderViewPanel.this.parent.getWave(st, et);
                return null;
            }

            @Override
            public void finished() {
                HelicorderViewPanel.this.parent.getThrobber().decrement();
                HelicorderViewPanel.this.working = false;
                if (HelicorderViewPanel.this.insetWavePanel != null) {
                    HelicorderViewPanel.this.insetWavePanel.setWave(this.sw, st, et);
                    HelicorderViewPanel.this.insetWavePanel.setWorking(false);
                }
                HelicorderViewPanel.this.repaint();
            }
        };
        worker.start();
    }

    public void setHelicorder(HelicorderData d, double time1, double time2) {
        this.heliData = d;
        if (this.heliData != null) {
            this.startTime = time1;
            this.endTime = time2;
            this.heliRenderer.setData(this.heliData);
            this.heliRenderer.setTimeChunk(this.settings.timeChunk);
            this.heliRenderer.setTimeZone(swarmConfig.getTimeZone(this.settings.channel));
            this.heliRenderer.setForceCenter(this.settings.forceCenter);
            this.heliRenderer.setClipBars(this.settings.clipBars);
            this.heliRenderer.setShowClip(this.settings.showClip);
            this.heliRenderer.setAlertClip(this.settings.alertClip);
            this.heliRenderer.setClipWav("clip.wav");
            this.heliRenderer.setClipAlertTimeout(this.settings.alertClipTimeout);
            this.mean = this.heliData.getMeanMax();
            this.bias = this.heliData.getBias();
            if (this.bias != this.mean) {
                this.mean = Math.abs(this.bias - this.mean);
            }
            this.heliRenderer.setClipValue(this.settings.clipValue);
        }
    }

    public void invalidateImage() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                HelicorderViewPanel.this.createImage();
                return null;
            }

            @Override
            public void finished() {
                HelicorderViewPanel.this.displayImage = HelicorderViewPanel.this.bufferImage;
                HelicorderViewPanel.this.repaint();
            }
        };
        worker.start();
    }

    public void setResized(boolean b) {
        this.resized = b;
    }

    private void createImage() {
        if (this.heliData == null) {
            return;
        }
        Dimension d = this.getSize();
        if (d.width <= 0 || d.height <= 0) {
            return;
        }
        this.bufferImage = new BufferedImage(d.width, d.height, 6);
        Graphics2D ig = (Graphics2D)this.bufferImage.getGraphics();
        this.plot.setSize(d);
        double offset = 0.0;
        double multiplier = 1.0;
        Metadata md = swarmConfig.getMetadata(this.settings.channel);
        if (md != null) {
            offset = md.getOffset();
            multiplier = md.getMultiplier();
        }
        if (this.minimal) {
            this.heliRenderer.setLocation(35, 10, d.width - 70 - 5, d.height - 10 - 17);
        } else {
            this.heliRenderer.setLocation(70, 10, d.width - 70 - 70, d.height - 10 - 35);
        }
        if (this.settings.autoScale) {
            this.settings.barRange = (int)(this.mean * this.settings.barMult);
            this.settings.clipValue = (int)(this.mean * (double)this.settings.clipBars);
            this.heliRenderer.setHelicorderExtents(this.startTime, this.endTime, -1 * Math.abs(this.settings.barRange), Math.abs(this.settings.barRange));
        } else {
            this.heliRenderer.setHelicorderExtents(this.startTime, this.endTime, -1.0 * Math.abs(((double)this.settings.barRange - offset) / multiplier), Math.abs(((double)this.settings.barRange - offset) / multiplier));
        }
        this.heliRenderer.setTimeZone(swarmConfig.getTimeZone(this.settings.channel));
        this.heliRenderer.setClipValue(this.settings.clipValue);
        if (this.minimal) {
            this.heliRenderer.setFrameDecorator(new SmallDecorator());
        } else {
            this.heliRenderer.createDefaultAxis();
        }
        if (md == null || md.getAlias() == null) {
            this.heliRenderer.setChannel(this.settings.channel);
        } else {
            this.heliRenderer.setChannel(md.getAlias());
        }
        this.translation = this.heliRenderer.getTranslationInfo(false);
        this.heliRenderer.setLargeChannelDisplay(this.fullScreen);
        try {
            this.plot.render(ig);
        }
        catch (PlotException e) {
            e.printStackTrace();
        }
    }

    public void setFullScreen(boolean b) {
        this.fullScreen = b;
    }

    public void setMinimal(boolean b) {
        this.minimal = b;
    }

    private void drawMark(Graphics2D g2, double t, Color color) {
        if (Double.isNaN(t)) {
            return;
        }
        int x = (int)this.heliRenderer.helicorderGetXPixel(t);
        int row = this.heliRenderer.getRow(t);
        int y = (int)Math.ceil((double)row * this.translation[2] + this.translation[3]);
        g2.setColor(color);
        g2.draw(new Line2D.Double(x, y, x, (double)y + this.translation[2]));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x, y);
        gp.lineTo((float)x - 4.0f, (float)y - 6.0f);
        gp.lineTo((float)x + 4.0f, (float)y - 6.0f);
        gp.closePath();
        g2.setColor(Color.GREEN);
        g2.fill(gp);
        g2.setColor(DARK_GREEN);
        g2.draw(gp);
        gp.reset();
        gp.moveTo(x, (float)((double)y + this.translation[2]));
        gp.lineTo((float)x - 4.0f, (float)((double)(y + 6) + this.translation[2]));
        gp.lineTo((float)x + 4.0f, (float)((double)(y + 6) + this.translation[2]));
        gp.closePath();
        gp.closePath();
        g2.setColor(Color.GREEN);
        g2.fill(gp);
        g2.setColor(DARK_GREEN);
        g2.draw(gp);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        if (this.heliData == null) {
            if (!this.parent.isWorking()) {
                this.parent.setStatus("The server returned no helicorder data.");
            }
        } else if (this.displayImage != null) {
            g2.drawImage((Image)this.displayImage, 0, 0, null);
        }
        this.drawMark(g2, this.startMark, DARK_GREEN);
        this.drawMark(g2, this.endMark, DARK_GREEN);
        if (this.insetWavePanel != null) {
            int width2;
            double t1 = this.insetWavePanel.getStartTime();
            double t2 = this.insetWavePanel.getEndTime();
            double t = (t2 - t1) / 2.0 + t1;
            int row = this.heliRenderer.getRow(t);
            if (this.resized) {
                int y;
                this.insetWavePanel.setSize(d.width, this.insetHeight);
                this.insetWavePanel.createImage();
                if ((double)row * this.translation[2] > (double)this.insetHeight + this.translation[3]) {
                    y = (int)Math.ceil((double)(row - 1) * this.translation[2] + this.translation[3]);
                    this.insetWavePanel.setLocation(0, y - this.insetHeight);
                } else {
                    y = (int)Math.ceil((double)(row + 2) * this.translation[2] + this.translation[3]);
                    this.insetWavePanel.setLocation(0, y);
                }
            }
            Point p = this.insetWavePanel.getLocation();
            g2.translate(p.x, p.y);
            this.insetWavePanel.paint(g2);
            Dimension wvd = this.insetWavePanel.getSize();
            g.setColor(Color.gray);
            g.drawRect(0, 0, wvd.width - 1, wvd.height);
            g2.translate(-p.x, -p.y);
            if (row < 0) {
                return;
            }
            Paint pnt = g2.getPaint();
            g2.setPaint(new Color(255, 255, 0, 128));
            Rectangle2D.Double rect = new Rectangle2D.Double();
            int zoomOffset = this.parent.getHelicorderViewerSettings().waveZoomOffset;
            double xo = 1.0 / this.translation[7] * (double)zoomOffset;
            int bx = (int)(this.heliRenderer.helicorderGetXPixel(t) - xo);
            int width = (int)(xo * 2.0);
            int right = this.heliRenderer.getGraphX() + this.heliRenderer.getGraphWidth();
            if (bx < this.heliRenderer.getGraphX()) {
                width2 = this.heliRenderer.getGraphX() - bx;
                rect.setRect(right - width2, (int)Math.ceil((double)(row - 1) * this.translation[2] + this.translation[3]), width2, (int)Math.ceil(this.translation[2]));
                if (row - 1 >= 0) {
                    g2.fill(rect);
                }
                bx = this.heliRenderer.getGraphX();
                width -= width2;
            }
            if (bx + width > right) {
                width2 = bx + width - right;
                rect.setRect(this.heliRenderer.getGraphX() + 1, (int)Math.ceil((double)(row + 1) * this.translation[2] + this.translation[3]), width2, (int)Math.ceil(this.translation[2]));
                if (row + 1 < this.heliRenderer.getNumRows()) {
                    g2.fill(rect);
                }
                width -= width2;
            }
            rect.setRect(bx, (int)Math.ceil((double)row * this.translation[2] + this.translation[3]), width, (int)Math.floor(this.translation[2]));
            g2.fill(rect);
            g2.setPaint(pnt);
        }
        this.resized = false;
    }

    @Override
    public void optionsChanged() {
        this.cursorChanged();
        this.invalidateImage();
        if (!SwarmConfig.getInstance().durationEnabled) {
            this.clearMarks();
        }
    }

    static {
        DARK_GREEN = new Color(0, 168, 0);
    }

    class SmallDecorator
    extends FrameDecorator {
        SmallDecorator() {
        }

        @Override
        public void decorate(FrameRenderer fr) {
            int minutes;
            HelicorderRenderer hr = (HelicorderRenderer)fr;
            AxisRenderer axis = new AxisRenderer(fr);
            axis.createDefault();
            fr.setAxis(axis);
            int majorTicks = minutes = (int)Math.round((double)((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk / 60.0);
            if (minutes > 30 && minutes < 180) {
                majorTicks = minutes / 5;
            } else if (minutes >= 180 && minutes < 360) {
                majorTicks = minutes / 10;
            } else if (minutes >= 360) {
                majorTicks = minutes / 20;
            }
            double[] mjt = SmartTick.intervalTick(0.0, ((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk, majorTicks);
            axis.createBottomTicks(null, mjt);
            axis.createTopTicks(null, mjt);
            axis.createVerticalGridLines(mjt);
            int bc = Math.round(((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk / 5) + 2;
            String[] btl = new String[bc];
            double[] btlv = new double[bc];
            btl[0] = "+";
            btlv[0] = 30.0;
            int j = 1;
            for (int i = 0; i < mjt.length; ++i) {
                long m = Math.round(mjt[i] / 60.0);
                if (m % 5L != 0L) continue;
                btl[j] = Long.toString(m);
                btlv[j++] = mjt[i];
            }
            axis.createBottomTickLabels(btlv, btl);
            int numRows = hr.getNumRows();
            double[] labelPosLR = new double[numRows];
            String[] leftLabelText = new String[numRows];
            String[] rightLabelText = new String[numRows];
            TimeZone timeZone = swarmConfig.getTimeZone(((HelicorderViewPanel)HelicorderViewPanel.this).settings.channel);
            SimpleDateFormat localTimeFormat = new SimpleDateFormat("HH:mm");
            localTimeFormat.setTimeZone(timeZone);
            SimpleDateFormat localDayFormat = new SimpleDateFormat("MM-dd");
            localDayFormat.setTimeZone(timeZone);
            double pixelsPast = 0.0;
            double pixelsPerRow = fr.getGraphHeight() / numRows;
            String lastLocalDay = "";
            for (int i = numRows - 1; i >= 0; --i) {
                Date dtz;
                String localDay;
                pixelsPast += pixelsPerRow;
                labelPosLR[i] = (double)i + 0.5;
                String localTime = localTimeFormat.format(Util.j2KToDate(hr.getHelicorderMaxX() - (double)((i + 1) * ((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk)));
                leftLabelText[i] = null;
                if (pixelsPast > 20.0) {
                    leftLabelText[i] = localTime;
                    pixelsPast = 0.0;
                }
                if ((localDay = localDayFormat.format(new Date((dtz = Util.j2KToDate(hr.getHelicorderMaxX() - (double)((i + 1) * ((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk))).getTime() + (long)(((HelicorderViewPanel)HelicorderViewPanel.this).settings.timeChunk * 1000)))).equals(lastLocalDay)) continue;
                rightLabelText[i] = localDay;
                lastLocalDay = localDay;
            }
            axis.createLeftTickLabels(labelPosLR, leftLabelText);
            axis.createRightTickLabels(labelPosLR, rightLabelText);
            boolean dst = timeZone.inDaylightTime(Util.j2KToDate(hr.getViewEndTime()));
            String timeZoneName = timeZone.getDisplayName(dst, 0);
            TextRenderer tr = new TextRenderer(3.0, fr.getGraphY() + fr.getGraphHeight() + 14, timeZoneName);
            tr.font = Font.decode("dialog-PLAIN-9");
            tr.antiAlias = false;
            axis.addPostRenderer(tr);
            double[] hg = new double[numRows - 1];
            for (int i = 0; i < numRows - 1; ++i) {
                hg[i] = (double)i + 1.0;
            }
            axis.createHorizontalGridLines(hg);
            axis.setBackgroundColor(Color.white);
        }
    }

    class HelicorderMouseListener
    implements MouseListener {
        HelicorderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            UiTime.touchTime();
            HelicorderViewPanel.this.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            UiTime.touchTime();
            if (e.getButton() == 1) {
                int mx = e.getX();
                int my = e.getY();
                if (mx < HelicorderViewPanel.this.heliRenderer.getGraphX() || my < HelicorderViewPanel.this.heliRenderer.getGraphY() || mx > HelicorderViewPanel.this.heliRenderer.getGraphX() + HelicorderViewPanel.this.heliRenderer.getGraphWidth() - 1 || my > HelicorderViewPanel.this.heliRenderer.getGraphY() + HelicorderViewPanel.this.heliRenderer.getGraphHeight() - 1) {
                    return;
                }
                double j2k = HelicorderViewPanel.this.getMouseJ2K(mx, my);
                if (j2k != -1.0E300) {
                    if (HelicorderViewPanel.this.insetWavePanel != null) {
                        HelicorderViewPanel.this.insetWavePanel.setWave(null, 0.0, 1.0);
                    }
                    HelicorderViewPanel.this.createWaveInset(j2k, mx, my);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class HelicorderMouseWheelListener
    implements MouseWheelListener {
        int totalScroll = 0;
        Delay delay;

        HelicorderMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            UiTime.touchTime();
            this.totalScroll += e.getWheelRotation();
            if (this.delay == null) {
                this.delay = new Delay(250L);
            } else {
                this.delay.restart();
            }
        }

        public void delayOver() {
            HelicorderViewPanel.this.removeWaveInset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HelicorderViewPanel.this.parent.scroll(HelicorderMouseWheelListener.this.totalScroll);
                    HelicorderMouseWheelListener.this.delay = null;
                    HelicorderMouseWheelListener.this.totalScroll = 0;
                }
            });
        }

        class Delay
        extends Thread {
            long delayLeft;

            public Delay(long ms) {
                this.delayLeft = ms;
                this.start();
            }

            public void restart() {
                this.interrupt();
            }

            @Override
            public void run() {
                boolean done = false;
                while (!done) {
                    try {
                        Thread.sleep(this.delayLeft);
                        done = true;
                    }
                    catch (Exception exception) {}
                }
                HelicorderMouseWheelListener.this.delayOver();
            }
        }
    }

    class HelicorderMouseMotionListener
    implements MouseMotionListener {
        HelicorderMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            UiTime.touchTime();
            HelicorderViewPanel.this.requestFocus();
            int mx = e.getX();
            int my = e.getY();
            if (mx >= HelicorderViewPanel.this.heliRenderer.getGraphX() && my >= HelicorderViewPanel.this.heliRenderer.getGraphY() && mx <= HelicorderViewPanel.this.heliRenderer.getGraphX() + HelicorderViewPanel.this.heliRenderer.getGraphWidth() - 1 && my <= HelicorderViewPanel.this.heliRenderer.getGraphY() + HelicorderViewPanel.this.heliRenderer.getGraphHeight() - 1) {
                double j2k = HelicorderViewPanel.this.getMouseJ2K(mx, my);
                HelicorderViewPanel.this.processMousePosition(mx, my);
                if (SwingUtilities.isLeftMouseButton(e)) {
                    HelicorderViewPanel.this.createWaveInset(j2k, mx, my);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            UiTime.touchTime();
            HelicorderViewPanel.this.processMousePosition(e.getX(), e.getY());
        }
    }
}

