/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import gov.usgs.swarm.Icons;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.wave.WaveViewSettings;
import gov.usgs.swarm.wave.WaveViewSettingsDialog;
import gov.usgs.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class WaveViewSettingsToolbar {
    private JButton waveSet;
    private JToggleButton waveToggle;
    private JToggleButton spectraToggle;
    private JToggleButton spectrogramToggle;
    private ButtonGroup waveTypes;
    private Set<WaveViewSettings> settingsSet = new HashSet<WaveViewSettings>();

    public WaveViewSettingsToolbar(WaveViewSettings s, JToolBar dest, JComponent keyComp) {
        this.createUI(dest, keyComp);
        this.setSettings(s);
    }

    public void createUI(JToolBar dest, JComponent keyComp) {
        this.waveSet = SwarmUtil.createToolBarButton(Icons.wavesettings, "Wave view settings (?)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaveViewSettingsToolbar.this.settingsSet.size() == 0) {
                    return;
                }
                WaveViewSettings s = (WaveViewSettings)WaveViewSettingsToolbar.this.settingsSet.iterator().next();
                WaveViewSettingsDialog wvsd = WaveViewSettingsDialog.getInstance(s, WaveViewSettingsToolbar.this.settingsSet.size());
                wvsd.setVisible(true);
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.copy(s);
                    settings.notifyView();
                }
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "shift SLASH", "settings", this.waveSet);
        dest.add(this.waveSet);
        this.waveToggle = SwarmUtil.createToolBarToggleButton(Icons.wave, "Wave view (W or ,)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.setType(WaveViewSettings.ViewType.WAVE);
                }
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "COMMA", "wave1", this.waveToggle);
        Util.mapKeyStrokeToButton(keyComp, "W", "wave2", this.waveToggle);
        dest.add(this.waveToggle);
        this.spectraToggle = SwarmUtil.createToolBarToggleButton(Icons.spectra, "Spectra view (S or .)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.setType(WaveViewSettings.ViewType.SPECTRA);
                }
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "PERIOD", "spectra1", this.spectraToggle);
        Util.mapKeyStrokeToButton(keyComp, "S", "spectra2", this.spectraToggle);
        dest.add(this.spectraToggle);
        this.spectrogramToggle = SwarmUtil.createToolBarToggleButton(Icons.spectrogram, "Spectrogram view (G or /)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.setType(WaveViewSettings.ViewType.SPECTROGRAM);
                }
            }
        });
        Util.mapKeyStrokeToButton(keyComp, "SLASH", "spectrogram1", this.spectrogramToggle);
        Util.mapKeyStrokeToButton(keyComp, "G", "spectrogram2", this.spectrogramToggle);
        dest.add(this.spectrogramToggle);
        keyComp.getInputMap(1).put(KeyStroke.getKeyStroke("L"), "cycleLogSettings");
        keyComp.getActionMap().put("cycleLogSettings", new AbstractAction(){
            public static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    if (settings.viewType == WaveViewSettings.ViewType.SPECTRA) {
                        settings.cycleLogSettings();
                    }
                    if (settings.viewType != WaveViewSettings.ViewType.SPECTROGRAM) continue;
                    settings.toggleLogPower();
                }
            }
        });
        keyComp.getInputMap(1).put(KeyStroke.getKeyStroke("F"), "toggleFilter");
        keyComp.getActionMap().put("toggleFilter", new AbstractAction(){
            public static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.toggleFilter();
                }
            }
        });
        keyComp.getInputMap(1).put(KeyStroke.getKeyStroke("R"), "resetAutoScale");
        keyComp.getActionMap().put("resetAutoScale", new AbstractAction(){
            public static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.resetAutoScaleMemory();
                }
            }
        });
        keyComp.getInputMap(1).put(KeyStroke.getKeyStroke("OPEN_BRACKET"), "yScaleIn");
        keyComp.getActionMap().put("yScaleIn", new AbstractAction(){
            public static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.adjustScale(0.8);
                }
            }
        });
        keyComp.getInputMap(1).put(KeyStroke.getKeyStroke("CLOSE_BRACKET"), "yScaleOut");
        keyComp.getActionMap().put("yScaleOut", new AbstractAction(){
            public static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WaveViewSettings settings : WaveViewSettingsToolbar.this.settingsSet) {
                    settings.adjustScale(1.25);
                }
            }
        });
        this.waveTypes = new ButtonGroup();
        this.waveTypes.add(this.waveToggle);
        this.waveTypes.add(this.spectraToggle);
        this.waveTypes.add(this.spectrogramToggle);
    }

    public void clearSettingsSet() {
        this.settingsSet.clear();
    }

    public void addSettings(WaveViewSettings s) {
        if (s != null) {
            this.settingsSet.add(s);
            s.toolbar = this;
            this.settingsChanged();
        }
    }

    public void removeSettings(WaveViewSettings s) {
        this.settingsSet.remove(s);
        if (s != null) {
            s.toolbar = null;
            this.settingsChanged();
        }
    }

    public void setSettings(WaveViewSettings s) {
        this.clearSettingsSet();
        this.addSettings(s);
    }

    public void settingsChanged() {
        boolean w = false;
        boolean s = false;
        boolean sg = false;
        for (WaveViewSettings set : this.settingsSet) {
            if (set.viewType == WaveViewSettings.ViewType.WAVE) {
                w = true;
            }
            if (set.viewType == WaveViewSettings.ViewType.SPECTRA) {
                s = true;
            }
            if (set.viewType != WaveViewSettings.ViewType.SPECTROGRAM) continue;
            sg = true;
        }
        try {
            this.waveTypes.setSelected(this.waveTypes.getSelection(), false);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.waveToggle.setSelected(w && !s && !sg);
        this.spectraToggle.setSelected(!w && s && !sg);
        this.spectrogramToggle.setSelected(!w && !s && sg);
    }
}

