/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ProgressInputStream
extends InputStream {
    protected InputStream source;
    protected int length;
    protected int read;
    protected int lastProgress = -1;
    protected List<ProgressListener> listeners = new ArrayList<ProgressListener>(2);

    public ProgressInputStream(InputStream src, int len) {
        this.source = src;
        this.length = len;
        this.read = 0;
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    protected void addRead(int cnt) {
        if (cnt <= 0) {
            return;
        }
        this.read += cnt;
        float pct = (float)this.read / (float)this.length;
        int p = (int)(pct * 100.0f);
        if (this.lastProgress != p) {
            this.lastProgress = p;
            for (ProgressListener pl : this.listeners) {
                pl.progressDone(pct);
            }
        }
    }

    @Override
    public int read() throws IOException {
        int r = this.source.read();
        this.addRead(1);
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.source.read(b);
        this.addRead(r);
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.source.read(b, off, len);
        this.addRead(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        this.listeners.clear();
        this.listeners = null;
        this.source.close();
    }
}

