/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class Util {
    public static final char DEGREE_SYMBOL = '\u00b0';
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static final long ONE_PB = 0x4000000000000L;
    private static SimpleDateFormat dateOut;
    private static DecimalFormat diffFormat;
    private static Calendar cal;

    public static String formatDate(Date d) {
        return dateOut.format(d);
    }

    public static String escapeString(String src, char c) {
        if (src == null) {
            return "";
        }
        StringBuffer b = new StringBuffer(src);
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != c) continue;
            b.insert(i, c);
            ++i;
        }
        return b.toString();
    }

    public static Date j2KToDate(double in) {
        return new Date((long)(1000.0 * (in + 9.46728E8)));
    }

    public static double dateToJ2K(Date in) {
        return (double)in.getTime() / 1000.0 - 9.46728E8;
    }

    public static double nowJ2K() {
        return Util.dateToJ2K(new Date());
    }

    public static int getYear(Date d) {
        cal.setTime(d);
        return cal.get(1);
    }

    public static int getMonth(Date d) {
        cal.setTime(d);
        return cal.get(2);
    }

    public static int getMonthsBetween(Date ds, Date de) {
        int months = 0;
        cal.setTime(ds);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(de);
        while (cal.get(2) != cal2.get(2) || cal.get(1) != cal2.get(1)) {
            ++months;
            cal.add(2, 1);
        }
        return months;
    }

    public static String timeDifferenceToString(double diff) {
        String diffString = "";
        if (diff < 60.0) {
            diffString = diffFormat.format(diff) + "s";
        } else if (diff < 3600.0) {
            diffString = (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        } else if (diff < 86400.0) {
            diffString = (int)(diff / 3600.0) + "h ";
            diff -= (double)(3600 * (int)(diff / 3600.0));
            diffString = diffString + (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        } else {
            diffString = (int)(diff / 86400.0) + "d ";
            diff -= (double)(86400 * (int)(diff / 86400.0));
            diffString = diffString + (int)(diff / 3600.0) + "h ";
            diff -= (double)(3600 * (int)(diff / 3600.0));
            diffString = diffString + (int)(diff / 60.0) + "m " + diffFormat.format(diff % 60.0) + "s";
        }
        return diffString;
    }

    public static String numBytesToString(long bytes) {
        if (bytes <= 4096L) {
            return String.format("%d B", bytes);
        }
        if (bytes <= 0x400000L) {
            return String.format("%.3f KB", (double)bytes / 1024.0);
        }
        if (bytes <= 0x100000000L) {
            return String.format("%.3f MB", (double)bytes / 1048576.0);
        }
        if (bytes <= 0x40000000000L) {
            return String.format("%.3f GB", (double)bytes / 1.073741824E9);
        }
        if (bytes <= 0x10000000000000L) {
            return String.format("%.3f TB", (double)bytes / 1.099511627776E12);
        }
        return String.format("%.3f PB", (double)bytes / 1.125899906842624E15);
    }

    public static String resultSetToHTML(ResultSet rs) {
        try {
            int i;
            ResultSetMetaData meta = rs.getMetaData();
            int numCols = meta.getColumnCount();
            StringBuffer sb = new StringBuffer();
            sb.append("<table>\n<tr>");
            for (i = 1; i <= numCols; ++i) {
                sb.append("<td>" + meta.getColumnLabel(i) + "</td>");
            }
            sb.append("</tr>\n");
            while (rs.next()) {
                sb.append("<tr>");
                for (i = 1; i <= numCols; ++i) {
                    sb.append("<td>" + rs.getObject(i) + "</td>");
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void mapKeyStrokeToAction(JComponent comp, String ks, String name, AbstractAction action) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(ks), name);
        comp.getActionMap().put(name, action);
    }

    public static void mapKeyStrokeToButton(JComponent comp, String ks, String name, final AbstractButton button) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(ks), name);
        comp.getActionMap().put(name, new AbstractAction(){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                button.doClick();
            }
        });
    }

    public static String j2KToDateString(double j) {
        return Util.j2KToDateString(j, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String j2KToDateString(double j, TimeZone tz) {
        return Util.j2KToDateString(j, "yyyy-MM-dd HH:mm:ss.SSS", tz);
    }

    public static String j2KToDateString(double j, String format) {
        return Util.j2KToDateString(j, format, TimeZone.getTimeZone("GMT"));
    }

    public static String j2KToDateString(double j, String format, TimeZone tz) {
        SimpleDateFormat df1 = new SimpleDateFormat(format);
        df1.setTimeZone(tz);
        return df1.format(Util.j2KToDate(j));
    }

    public static double j2KToEW(double j) {
        return j + 9.46728E8;
    }

    public static double ewToJ2K(double e) {
        return e - 9.46728E8;
    }

    public static byte intToByte(int i) {
        return (byte)(i & 0xFF);
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static String bytesToString(byte[] b) {
        return Util.bytesToString(b, 0, b.length);
    }

    public static String bytesToString(byte[] b, int o, int l) {
        int trunc = -1;
        for (int i = o; i < o + l; ++i) {
            if (b[i] != 0) continue;
            trunc = i;
            break;
        }
        if (trunc != -1) {
            return Util.quickBytesToString(b, o, trunc - o);
        }
        return Util.quickBytesToString(b, o, l);
    }

    public static String quickBytesToString(byte[] b, int ofs, int len) {
        char[] chars = new char[len];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)b[i + ofs];
        }
        return new String(chars);
    }

    public static double register(double n, double m) {
        double dif = n % m;
        if (dif >= m / 2.0) {
            return n + (m - dif);
        }
        return n - dif;
    }

    public static int swap(int i) {
        return (i & 0xFF000000) >> 24 & 0xFF | (i & 0xFF0000) >> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
    }

    public static short swap(short s) {
        return (short)((s & 0xFF00) >> 8 | (s & 0xFF) << 8);
    }

    public static double swap(double d) {
        long l = Double.doubleToRawLongBits(d);
        long sl = (l & 0xFF00000000000000L) >> 56 & 0xFFL | (l & 0xFF000000000000L) >> 40 | (l & 0xFF0000000000L) >> 24 | (l & 0xFF00000000L) >> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
        return Double.longBitsToDouble(sl);
    }

    public static void outputData(String fn, String hdr, double[][] data) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fn));
            out.println(hdr);
            for (int i = 0; i < data.length; ++i) {
                out.print(data[i][0] + ",");
                out.print(dateOut.format(Util.j2KToDate(data[i][0])) + ",");
                for (int j = 1; j < data[i].length - 1; ++j) {
                    out.print(data[i][j] + ",");
                }
                out.println(data[i][data[i].length - 1]);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void outputData(String fn, double[][] data) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fn));
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data[i].length; ++j) {
                    out.printf("%d %d %f\n", i, j, data[i][j]);
                }
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void outputData(String fn, String hdr, ResultSet rs) {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int nc = meta.getColumnCount();
            PrintWriter out = new PrintWriter(new FileWriter(fn, true));
            out.println(hdr);
            while (rs.next()) {
                double j2ksec = rs.getDouble(1);
                out.print(j2ksec + ",");
                out.print(dateOut.format(Util.j2KToDate(j2ksec)) + ",");
                for (int i = 2; i < nc - 1; ++i) {
                    out.print(rs.getString(i) + ",");
                }
                out.println(rs.getString(nc));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String md5(String plaintext) {
        MessageDigest md = Util.getMD5();
        if (md == null) {
            return null;
        }
        md.update(plaintext.getBytes());
        byte[] raw = md.digest();
        return Util.getHexString(raw);
    }

    public static MessageDigest getMD5() {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    public static String getHexString(byte[] raw) {
        ByteBuffer bb = ByteBuffer.wrap(raw);
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < 4; ++i) {
            String h = Integer.toHexString(bb.getInt());
            for (int j = h.length(); j < 8; ++j) {
                sb.append('0');
            }
            sb.append(h);
        }
        return sb.toString();
    }

    public static String md5Resource(String resource) {
        MessageDigest md = Util.getMD5();
        if (md == null) {
            return null;
        }
        try {
            InputStream in = null;
            if (resource.indexOf("://") != -1) {
                URL url = new URL(resource);
                in = url.openStream();
            } else {
                in = new FileInputStream(new File(resource));
            }
            int nr = 0;
            byte[] buf = new byte[65536];
            while (nr != -1) {
                nr = in.read(buf);
                if (nr == -1) continue;
                md.update(buf, 0, nr);
            }
            in.close();
            return Util.getHexString(md.digest());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] compress(byte[] bytes) {
        return Util.compress(bytes, 1);
    }

    public static byte[] compress(byte[] bytes, int level) {
        return Util.compress(bytes, level, 0, bytes.length);
    }

    public static byte[] compress(byte[] bytes, int level, int ofs, int len) {
        Deflater deflater = new Deflater(level);
        deflater.setInput(bytes, ofs, len);
        deflater.finish();
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        boolean done = false;
        int compSize = 0;
        while (!done) {
            byte[] compBuf = new byte[bytes.length];
            compSize = deflater.deflate(compBuf);
            if (deflater.finished()) {
                done = true;
            }
            list.add(compBuf);
        }
        int total = (list.size() - 1) * bytes.length + compSize;
        byte[] finalBuf = new byte[total];
        int j = 0;
        for (int i = 0; i < list.size() - 1; ++i) {
            System.arraycopy((byte[])list.get(i), 0, finalBuf, j, bytes.length);
            j += bytes.length;
        }
        System.arraycopy((byte[])list.get(list.size() - 1), 0, finalBuf, j, compSize);
        return finalBuf;
    }

    public static byte[] decompress(byte[] bytes) {
        return Util.decompress(bytes, 65536);
    }

    public static byte[] decompress(byte[] bytes, int bufferSize) {
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(bytes);
            boolean done = false;
            ArrayList<byte[]> list = new ArrayList<byte[]>(10);
            int numBytes = 0;
            while (!done) {
                byte[] buffer = new byte[bufferSize];
                numBytes = inflater.inflate(buffer);
                if (inflater.finished()) {
                    done = true;
                }
                list.add(buffer);
            }
            inflater.end();
            int total = (list.size() - 1) * bufferSize + numBytes;
            byte[] finalBuf = new byte[total];
            int j = 0;
            for (int i = 0; i < list.size() - 1; ++i) {
                System.arraycopy((byte[])list.get(i), 0, finalBuf, j, bufferSize);
                j += bufferSize;
            }
            System.arraycopy((byte[])list.get(list.size() - 1), 0, finalBuf, j, numBytes);
            return finalBuf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] resize(byte[] b, int i) {
        if (b.length == i) {
            return b;
        }
        byte[] bb = new byte[i];
        System.arraycopy(b, 0, bb, 0, Math.min(i, b.length));
        return bb;
    }

    public static String getLineNumber(Object obj, Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            if (!obj.getClass().getName().equals(stack[i].getClassName())) continue;
            return t.getClass().getName() + "/" + stack[i].getFileName() + ":" + stack[i].getLineNumber();
        }
        return "";
    }

    public static String[] getVersion(String pkg) {
        try {
            String version = (String)Class.forName(pkg + ".Version").getField("VERSION").get(null);
            String build = (String)Class.forName(pkg + ".Version").getField("BUILD_DATE").get(null);
            return new String[]{version, build};
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean stringToBoolean(String val) {
        if (val == null) {
            return false;
        }
        return val.toLowerCase().equals("true") || val.equals("1") || val.toLowerCase().equals("t");
    }

    public static boolean stringToBoolean(String val, boolean def) {
        if (val == null) {
            return def;
        }
        return val.toLowerCase().equals("true") || val.equals("1") || val.toLowerCase().equals("t");
    }

    public static int stringToInt(String val) {
        return Util.stringToInt(val, Integer.MIN_VALUE);
    }

    public static int stringToInt(String val, int def) {
        int i = def;
        try {
            i = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static Integer stringToInteger(String val) {
        return Util.stringToInt(val, Integer.MIN_VALUE);
    }

    public static Integer stringToInteger(String val, Integer def) {
        Integer i = def;
        try {
            i = Integer.valueOf(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static double stringToDouble(String val) {
        return Util.stringToDouble(val, Double.NaN);
    }

    public static double stringToDouble(String val, double def) {
        double d = def;
        try {
            d = Double.parseDouble(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        return d;
    }

    public static String stringToString(String val, String def) {
        return val == null ? def : val;
    }

    public static String readTextFile(String fn) {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(fn));
            StringBuffer sb = new StringBuffer();
            while ((s = in.readLine()) != null) {
                sb.append(s);
            }
            in.close();
            return sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Set<Object> toSet(Object[] objs) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object o : objs) {
            set.add(o);
        }
        return set;
    }

    public static String mapToString(Map<String, String> map) {
        String result = "";
        for (String key : map.keySet()) {
            result = result + key + "=" + map.get(key) + "; ";
        }
        return result;
    }

    public static Map<String, String> stringToMap(String src) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] params = src.split(";");
        for (int i = 0; i < params.length; ++i) {
            int ei = params[i].indexOf("=");
            if (ei == -1) continue;
            String k = params[i].substring(0, ei).trim();
            String v = params[i].substring(ei + 1);
            result.put(k, v);
        }
        return result;
    }

    public static String byteToHex(byte b) {
        String h = Integer.toHexString(b & 0xFF);
        if (h.length() == 1) {
            h = "0" + h;
        }
        return h;
    }

    public static String bytesToHex(byte[] buf) {
        StringBuilder sb = new StringBuilder(buf.length * 2 + 1);
        for (int i = 0; i < buf.length; ++i) {
            sb.append(Util.byteToHex(buf[i]));
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String s) {
        int n = s.length() / 2;
        byte[] buf = new byte[n];
        for (int i = 0; i < n; ++i) {
            String ss = s.substring(i * 2, i * 2 + 2);
            int j = Integer.parseInt(ss, 16);
            buf[i] = (byte)j;
        }
        return buf;
    }

    public static String latitudeToString(double lat) {
        char ns = 'N';
        if (lat < 0.0) {
            ns = 'S';
        }
        lat = Math.abs(lat);
        return String.format("%.4f", lat) + '\u00b0' + ns;
    }

    public static String longitudeToString(double lon) {
        while (lon < -180.0) {
            lon += 360.0;
        }
        while (lon > 180.0) {
            lon -= 360.0;
        }
        char ew = 'E';
        if (lon < 0.0) {
            ew = 'W';
        }
        lon = Math.abs(lon);
        return String.format("%.4f", lon) + '\u00b0' + ew;
    }

    public static String lonLatToString(Point2D.Double pt) {
        return String.format("%s, %s", Util.longitudeToString(pt.x), Util.latitudeToString(pt.y));
    }

    public static Comparator<String> getIgnoreCaseStringComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    public static boolean sleep(long ms) {
        try {
            Thread.sleep(ms);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("-j2d [j2k]\t\t\t\tj2k to date");
            System.out.println("-j2e [j2k]              j2k to earthworm");
            System.out.println("-d2j [yyyymmddhhmmss]\tdate to j2k");
            System.out.println("-e2d [ewtime]           earthworm to date");
            System.out.println("-md5 [string]\t\t\tmd5 of string");
            System.out.println("-md5r [resource]        md5 of a resource (filename, url)");
            System.exit(1);
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
        df1.setTimeZone(TimeZone.getTimeZone("GMT"));
        df2.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (args[0].equals("-j2d")) {
            System.out.println(df1.format(Util.j2KToDate(Double.parseDouble(args[1]))));
        } else if (args[0].equals("-j2e")) {
            System.out.println(Util.j2KToEW(Double.parseDouble(args[1])));
        } else if (args[0].equals("-d2j")) {
            System.out.println(Util.dateToJ2K(df2.parse(args[1])));
        } else if (args[0].equals("-e2d")) {
            System.out.println(df1.format(Util.j2KToDate(Util.ewToJ2K(Double.parseDouble(args[1])))));
        } else if (args[0].equals("-md5")) {
            System.out.println(Util.md5(args[1]));
        } else if (args[0].equals("-md5r")) {
            System.out.println(Util.md5Resource(args[1]));
        }
    }

    static {
        cal = Calendar.getInstance();
        dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        diffFormat = new DecimalFormat("#.##");
    }
}

