/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.in.ew;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.earthworm.Menu;
import gov.usgs.earthworm.MenuItem;
import gov.usgs.earthworm.WaveServer;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.in.ew.ImportWSJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportWS {
    private static final String DEFAULT_CONFIG_FILENAME = "ImportWS.config";
    private static final double DEFAULT_CHUNK_SIZE = 600.0;
    private static final int DEFAULT_CHUNK_DELAY = 500;
    private static final boolean DEFAULT_RSAM_ENABLE = true;
    private static final int DEFAULT_RSAM_DELTA = 10;
    private static final int DEFAULT_RSAM_DURATION = 60;
    private WaveServer waveServer;
    private WinstonDatabase winston;
    private Channels channels;
    private Data data;
    private Menu menu;
    private ConfigFile config;
    private boolean createChannels;
    private boolean createDatabase;
    private List<ImportWSJob> jobs;
    private ImportWSJob currentJob;
    private List<String> sourceChannels;
    private Logger logger;
    private double startTime;
    private double endTime;
    private double chunkSize;
    private int chunkDelay;
    private boolean rsamEnable;
    private int rsamDelta;
    private int rsamDuration;
    private int totalInserted = 0;
    private double totalDownloadTime = 0.0;
    private double totalInsertTime = 0.0;
    private boolean requestSCNL = false;
    private boolean quit = false;
    private CodeTimer appTimer = new CodeTimer("application");
    public static String JSAP_PROGRAM_NAME = "java gov.usgs.winston.in.ew.ImportWS";
    public static String JSAP_EXPLANATION_PREFACE = "Winston ImportWS\n\nThis program gets data from a Winston wave server and imports\nit into a Winston database. See 'ImportWS.config' for more options.\n\n";
    private static final String DEFAULT_JSAP_EXPLANATION = "All output goes to standard error.\nThe command line takes precedence over the config file.\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new FlaggedOption("timeRange", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "timerange", "The time range. Relative times are assumed to be in the past.\n"), new FlaggedOption("waveServer", JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'w', "waveserver", "The Winston wave server to poll.\n").setUsageName("host:port"), new Switch("noInput", 'i', "noinput", "Do not poll keyboard for input."), new Switch("SCNL", 'l', "SCNL", "Always request SCNL"), new UnflaggedOption("configFilename", JSAP.STRING_PARSER, "ImportWS.config", true, false, "The config file name.")};

    public ImportWS() {
        this.logger = Log.getLogger("gov.usgs.winston");
        this.logger.setLevel(Level.FINE);
    }

    public ImportWS(String fileName) {
        this();
        this.config = new ConfigFile(fileName);
        this.processConfig();
    }

    public void setConfig(ConfigFile config) {
        this.config = config;
    }

    public void setRequestSCNL(boolean requestSCNL) {
        this.requestSCNL = requestSCNL;
    }

    public boolean getRequestSCNL() {
        return this.requestSCNL;
    }

    public void processConfig() {
        String s;
        this.createDatabase = Util.stringToBoolean(this.config.getString("createDatabase"));
        this.logger.fine("createDatabase: " + this.createDatabase);
        this.winston = WinstonDatabase.processWinstonConfigFile(this.config);
        this.logger.fine("winston.driver: " + this.winston.dbDriver);
        this.logger.fine("winston.url: " + this.winston.dbURL);
        this.logger.fine("winston.prefix: " + this.winston.databasePrefix);
        this.logger.fine("winston.statementCacheCap: " + this.winston.cacheCap);
        if (this.createDatabase) {
            this.winston.checkDatabase();
        }
        if ((s = this.config.getString("waveServer")) == null) {
            throw new RuntimeException("no waveServer string");
        }
        this.waveServer = new WaveServer(this.config.getString("waveServer"));
        this.logger.fine("waveServer: " + this.waveServer.host + ":" + this.waveServer.port);
        this.createChannels = Util.stringToBoolean(this.config.getString("createChannels"));
        this.logger.fine("createChannels: " + this.createChannels);
        this.sourceChannels = this.config.getList("channel");
        this.logger.fine("sourceChannels: " + this.sourceChannels);
        String timeRange = this.config.getString("timeRange");
        this.logger.fine("timeRange: " + timeRange);
        this.parseTimeRange(timeRange);
        this.chunkSize = Util.stringToDouble(this.config.getString("chunkSize"), 600.0);
        this.logger.fine("chunkSize: " + this.chunkSize);
        this.chunkDelay = Util.stringToInt(this.config.getString("chunkDelay"), 500);
        this.logger.fine("chunkDelay: " + this.chunkDelay);
        this.rsamEnable = Util.stringToBoolean(this.config.getString("rsam.enable"), true);
        this.logger.fine("rsamEnable: " + this.rsamEnable);
        this.rsamDelta = Util.stringToInt(this.config.getString("rsam.delta"), 10);
        this.logger.fine("rsamDelta: " + this.rsamDelta);
        this.rsamDuration = Util.stringToInt(this.config.getString("rsam.duration"), 60);
        this.logger.fine("rsamDuration: " + this.rsamDuration);
    }

    public void addStats(int t, double td, double ti) {
        this.totalInserted += t;
        this.totalDownloadTime += td;
        this.totalInsertTime += ti;
    }

    private void parseTimeRange(String timeRange) {
        try {
            double[] tr = Time.parseTimeRange(timeRange);
            this.startTime = tr[0];
            this.endTime = tr[1];
        }
        catch (Exception e) {
            this.logger.severe("Error parsing time range: " + e.getMessage());
            System.exit(-1);
        }
        this.logger.fine(String.format("Requested time range: [%s -> %s, %s]", Time.toDateString(this.startTime), Time.toDateString(this.endTime), Util.timeDifferenceToString(this.endTime - this.startTime)));
    }

    public void setWinston(WinstonDatabase w) {
        this.winston = w;
    }

    public void setWaveServer(WaveServer ws) {
        this.waveServer = ws;
    }

    private void getChannels() {
        this.channels = new Channels(this.winston);
        this.data = new Data(this.winston);
        this.waveServer.connect();
        this.menu = this.waveServer.getMenuSCNL();
        this.waveServer.close();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void createJobs() {
        this.getChannels();
        this.jobs = new ArrayList<ImportWSJob>();
        List<MenuItem> items = this.menu.getItems();
        for (MenuItem item : items) {
            for (String channel : this.sourceChannels) {
                String[] ss = channel.split("[\\$\\_ ]");
                String loc = null;
                if (ss.length == 4) {
                    loc = ss[3];
                }
                if (!item.match(ss[0], ss[1], ss[2], loc)) continue;
                String wc = item.getSCNSCNL("$");
                if (!this.createChannels && !this.channels.channelExists(wc)) continue;
                this.logger.fine("Remote channel matched: " + wc);
                ImportWSJob job = new ImportWSJob(this.winston, this.waveServer, this);
                job.setChannel(wc);
                job.setChunkDelay(this.chunkDelay);
                job.setChunkSize(this.chunkSize);
                job.setRSAMParameters(this.rsamEnable, this.rsamDelta, this.rsamDuration);
                this.jobs.add(job);
            }
        }
    }

    public void startImport() {
        Iterator<ImportWSJob> i$ = this.jobs.iterator();
        while (i$.hasNext()) {
            ImportWSJob job;
            this.currentJob = job = i$.next();
            this.logger.info(job.getChannel() + ": finding gaps");
            List<double[]> gaps = this.data.findGaps(job.getChannel(), this.startTime, this.endTime);
            for (double[] gap : gaps) {
                job.addSpan(gap[0], gap[1]);
            }
            job.go();
            if (!this.quit) continue;
            break;
        }
        this.appTimer.stop();
        this.logger.info(String.format("%d tbs inserted, total download time: %s, total insert time: %s (%.3fms/tb)", this.totalInserted, Util.timeDifferenceToString(this.totalDownloadTime / 1000.0), Util.timeDifferenceToString(this.totalInsertTime / 1000.0), this.totalInsertTime / (double)this.totalInserted));
        this.logger.info("Total run time: " + Util.timeDifferenceToString(this.appTimer.getRunTimeMillis() / 1000.0));
        this.quit = true;
    }

    public void go() {
        Thread launchThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ImportWS.this.startImport();
            }
        });
        launchThread.start();
    }

    public void quit() {
        if (this.currentJob != null) {
            this.currentJob.quit();
        } else {
            this.logger.info("Null job");
        }
        this.quit = true;
        this.logger.info("Quitting cleanly.");
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION_PREFACE + DEFAULT_JSAP_EXPLANATION, DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static void main(String[] args) throws IOException {
        JSAPResult config = ImportWS.getArguments(args);
        ImportWS w = new ImportWS(config.getString("configFilename"));
        if (config.getString("timeRange") != null) {
            w.parseTimeRange(config.getString("timeRange"));
        }
        if (config.getString("waveServer") != null) {
            w.waveServer = new WaveServer(config.getString("waveServer"));
        }
        boolean acceptCommands = !config.getBoolean("noInput");
        w.setRequestSCNL(config.getBoolean("SCNL"));
        w.createJobs();
        w.go();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (acceptCommands && !w.quit) {
            String s = in.readLine();
            if (s == null || !(s = s.toLowerCase().trim()).equals("q")) continue;
            w.quit();
        }
    }

    public void setQuit(boolean b) {
        this.quit = b;
    }
}

