/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor.collector;

import gov.usgs.net.HttpRequest;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.monitor.Collector;
import gov.usgs.winston.monitor.McVcoCalPulse;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

public class CalPulseCollector
extends Collector {
    private static final int DEFAULT_INSPECTION_WINDOW = 90;
    private static final int DEFAULT_INSPECTION_INTERVAL = 60;
    private static final String DEFAULT_SPAN = "-1d";
    private int inspectionWindow;
    private Map<String, Double> lastCalPulse;

    @Override
    public void configure(String n, ConfigFile cc, ConfigFile wc) {
        this.setName(n);
        this.quit = false;
        this.lastCalPulse = new HashMap<String, Double>();
        this.rrdBase = "rrds";
        this.winstonConfig(wc);
        this.inspectionWindow = Util.stringToInt(cc.getString("inspectionWindow"), 90);
        this.logger.info("config: inspectionWindow=" + this.inspectionWindow);
        this.inspectionInterval = Util.stringToInt(cc.getString("instpectionInterval"), 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void poll() {
        String sql = "SELECT code, value from channels, channelmetadata WHERE channels.sid=channelmetadata.sid";
        Statement s = null;
        if (!this.winston.useRootDatabase()) {
            this.fatalError("Can't use root database");
        }
        try {
            s = this.winston.getNewStatement();
            ResultSet rs = s.executeQuery(sql);
            while (rs.next()) {
                String code = rs.getString("code");
                double j2kTime = rs.getDouble("value");
                if (this.lastCalPulse.containsKey(code) && !(j2kTime > this.lastCalPulse.get(code))) continue;
                this.lastCalPulse.put(code, j2kTime);
                Data d = new Data(this.winston);
                Wave w = null;
                try {
                    w = d.getWave(code, j2kTime, j2kTime + (double)this.inspectionWindow, Integer.MAX_VALUE);
                    w = w.subset(j2kTime, j2kTime + (double)this.inspectionWindow);
                }
                catch (UtilException e) {
                    e.printStackTrace();
                }
                McVcoCalPulse cp = new McVcoCalPulse(w);
                this.insertCalPulse(code, cp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                s.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void createRrd(String rrdPath, long startTime) {
        int step = 21600;
        int heartbeat = step * 4;
        RrdDef rrdDef = new RrdDef(rrdPath, startTime - (long)step, (long)step);
        rrdDef.addDatasource("batteryVoltage", DsType.GAUGE, (long)heartbeat, 0.0, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 168);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 2, 504);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 4, 365);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 8, 730);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, 168);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 2, 504);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 4, 365);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 8, 730);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 1, 42);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 2, 504);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 4, 365);
        rrdDef.addArchive(ConsolFun.MIN, 0.5, 8, 7);
        try {
            RrdDb rrdDb = new RrdDb(rrdDef);
            System.out.println("== RRD file created.");
            if (!rrdDb.getRrdDef().equals((Object)rrdDef)) {
                System.out.println("Invalid RRD file created. This is a serious bug, bailing out");
                return;
            }
            System.out.println("Checking RRD file structure... OK");
            rrdDb.close();
            System.out.println("== RRD file closed.");
        }
        catch (IOException e) {
            System.out.println("Can't create RRD " + rrdPath + ": " + e.getMessage());
        }
    }

    private void updateRrd(String rrdPath, McVcoCalPulse cp) {
        try {
            RrdDb rrdDb = new RrdDb(rrdPath);
            Sample sample = rrdDb.createSample();
            sample.setTime((long)Util.j2KToEW(cp.getStartTime()));
            sample.setValue("batteryVoltage", cp.getVoltage());
            System.out.println(sample.dump());
            try {
                sample.update();
            }
            catch (IllegalArgumentException e) {
                this.logger.finest("Duplicate rrd update: " + e.getMessage());
            }
            rrdDb.close();
        }
        catch (IOException e) {
            System.out.println("Can't update RRD " + rrdPath + ": " + e.getMessage());
        }
    }

    private void insertCalPulse(String code, McVcoCalPulse cp) {
        if (!cp.dataFound()) {
            System.out.println(String.format("Fake cal pulse found: %s at %s", code, Util.j2KToDateString(cp.getStartTime())));
            return;
        }
        System.out.println(String.format("Cal pulse found at %s for %s: gain=%d id=%d voltage=%f", Util.j2KToDateString(cp.getStartTime()), code, cp.getGain(), cp.getUnitId(), cp.getVoltage()));
        String rrdPath = this.rrdBase + File.separator + this.getName() + "_" + code + ".rrd";
        if (!new File(rrdPath).exists()) {
            this.createRrd(rrdPath, (long)Util.j2KToEW(cp.getStartTime()));
        }
        this.updateRrd(rrdPath, cp);
    }

    @Override
    public byte[] createPlot(HttpRequest req) throws IOException {
        String code = req.getArguments().get(this.getName() + "_code");
        String rrd = this.rrdBase + File.separator + this.getName() + "_" + code.replace('+', '$') + ".rrd";
        long start = System.currentTimeMillis() / 1000L - (long)Time.getRelativeTime(Util.stringToString(req.getArguments().get(this.getName() + "_timeSpan"), DEFAULT_SPAN));
        RrdGraphDef gDef = this.getGDef();
        gDef.setStartTime(start);
        gDef.setTitle(code.replace('+', ' ') + " Battery Voltage");
        gDef.setVerticalLabel("Volts");
        gDef.datasource("batteryVoltageAvg", rrd, "batteryVoltage", ConsolFun.AVERAGE);
        gDef.datasource("batteryVoltageMax", rrd, "batteryVoltage", ConsolFun.MAX);
        gDef.datasource("batteryVoltageMin", rrd, "batteryVoltage", ConsolFun.MIN);
        gDef.setMaxValue(20.0);
        gDef.setMinValue(10.0);
        gDef.setAltAutoscale(false);
        gDef.area("batteryVoltageMax", (Paint)this.maxColor, "");
        gDef.area("batteryVoltageMin", (Paint)this.minColor, "");
        gDef.line("batteryVoltageAvg", (Paint)this.avgColor, "", 2.0f);
        gDef.gprint("batteryVoltageMax", ConsolFun.MAX, "Max = %.3f%s");
        gDef.gprint("batteryVoltageMin", ConsolFun.MIN, "Min = %.3f%s");
        gDef.gprint("batteryVoltageAvg", ConsolFun.AVERAGE, "Average = %.3f%S\\r");
        RrdGraph graph = new RrdGraph(gDef);
        return graph.getRrdGraphInfo().getBytes();
    }

    @Override
    public String getMenu() {
        StringBuilder output = new StringBuilder();
        output.append("Station: <SELECT NAME=\"" + this.getName() + "_code\">");
        for (String s : this.getStations()) {
            output.append(String.format("<OPTION NAME=\"%s\">%s</OPTION>", s, s));
        }
        output.append("</SELECT>");
        return output.toString();
    }

    @Override
    public String createPlotPane(HttpRequest req) throws IOException {
        String c = req.getArguments().get("collector");
        String code = req.getArguments().get(c + "_code");
        StringBuilder output = new StringBuilder();
        output.append(String.format("<IMAGE SRC=\"/img?collector=%s&%s_code=%s&%s_timeSpan=-1w&%s_height=134\">", c, c, code, c, c));
        output.append("<P>");
        output.append(String.format("<IMAGE SRC=\"/img?collector=%s&%s_code=%s&%s_timeSpan=-4w&%s_height=134\">", c, c, code, c, c));
        output.append("<P>");
        output.append(String.format("<IMAGE SRC=\"/img?collector=%s&%s_code=%s&%s_timeSpan=-1y&%s_height=134\">", c, c, code, c, c));
        return output.toString();
    }
}

