/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNLHeliRawCommand
extends BaseCommand {
    public GetSCNLHeliRawCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    public void doCommand(Object info, SocketChannel channel) {
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNLTT(9)) {
            return;
        }
        double et = cmd.getT2(true);
        et = this.timeOrMaxDays(et);
        double st = cmd.getT1(true);
        st = this.timeOrMaxDays(st);
        et = Math.min(et, CurrentTime.getInstance().nowJ2K() - (double)this.wws.getEmbargo());
        GenericDataMatrix heli = null;
        if (st < et) {
            try {
                heli = this.data.getHelicorderData(cmd.getWinstonSCNL(), st, et, 0);
            }
            catch (UtilException e) {
                // empty catch block
            }
        }
        ByteBuffer bb = null;
        if (heli != null && heli.rows() > 0) {
            bb = (ByteBuffer)heli.toBinary().flip();
        }
        boolean compress = cmd.getInt(8) == 1;
        int bytes = this.writeByteBuffer(cmd.getID(), bb, compress, channel);
        String time = Util.j2KToDateString(st) + " - " + Util.j2KToDateString(et);
        this.wws.log(Level.FINER, "GETSCNLHELIRAW " + cmd.getWinstonSCNL() + " : " + time + ", " + bytes + " bytes.", channel);
    }
}

