/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.tools.pannel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.winston.in.metadata.AbstractMetadataImporter;
import gov.usgs.winston.in.metadata.ImportDataless;
import gov.usgs.winston.in.metadata.ImportHypoinverse;
import gov.usgs.winston.tools.FilePanel;
import gov.usgs.winston.tools.WinstonToolsRunnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class ImportInstrumentLocations
extends WinstonToolsRunnablePanel {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_FILE = "Winston.config";
    private FilePanel fileP;
    private JButton importB;
    private JComboBox fileType;

    public ImportInstrumentLocations() {
        super("Instrument Locations");
    }

    @Override
    protected void createUI() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Update Instrument Locations"));
        FormLayout layout = new FormLayout("right:max(40dlu;p), 4dlu, left:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("Source file", (Component)this.fileP);
        builder.nextLine();
        builder.append("File type", (Component)this.fileType);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append("", (Component)this.importB);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    protected void createFields() {
        this.fileP = new FilePanel(FilePanel.Type.OPEN);
        this.fileType = new JComboBox<FileType>(FileType.values());
        this.fileType.setSelectedItem((Object)FileType.HYPOINVERSE);
        this.importB = new JButton("import metadata");
        this.importB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportInstrumentLocations.this.start();
            }
        });
    }

    @Override
    protected void go() {
        AbstractMetadataImporter importer = ((FileType)((Object)this.fileType.getSelectedItem())).getImporter();
        importer.updateInstruments(this.fileP.getFileName());
    }

    @Override
    public boolean needsWinston() {
        return true;
    }

    private static enum FileType {
        DATALESS_SEED("Dataless SEED", new ImportDataless("Winston.config")),
        HYPOINVERSE("Hypoinverse", new ImportHypoinverse("Winston.config"));

        public final String text;
        public final AbstractMetadataImporter importer;

        private FileType(String text, AbstractMetadataImporter importer) {
            this.text = text;
            this.importer = importer;
        }

        public String toString() {
            return this.text;
        }

        public AbstractMetadataImporter getImporter() {
            return this.importer;
        }
    }
}

