/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.plot.Plot;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.render.HelicorderRenderer;
import java.awt.Color;
import java.util.TimeZone;

public class HelicorderSettings {
    public String channel;
    public String channelCode;
    public double endTime;
    public double startTime;
    public double timeChunk = 1200.0;
    public int width = 1000;
    public int height = 1000;
    public int left = 70;
    public int top = 20;
    public int clipValue = -1;
    public int barRange = -1;
    public float barMult = 3.0f;
    public boolean showClip = false;
    public boolean forceCenter = false;
    public String timeZoneAbbr = "GMT";
    public double timeZoneOffset = 0.0;
    public TimeZone timeZone = TimeZone.getTimeZone(this.timeZoneAbbr);
    public boolean minimumAxis = false;
    public boolean largeChannelDisplay = false;
    public boolean showDecorator = true;
    public boolean showLegend = false;

    public void applySettings(HelicorderRenderer hr, HelicorderData hd) {
        hr.setChannel(this.channel);
        hr.setData(hd);
        hr.setTimeChunk(this.timeChunk);
        hr.setLocation(this.left, this.top, this.width, this.height);
        hr.setForceCenter(this.forceCenter);
        double mean = hd.getMeanMax();
        double bias = hd.getBias();
        mean = Math.abs(bias - mean);
        if (this.minimumAxis) {
            this.barMult = 6.0f;
        }
        if (this.clipValue == -1) {
            this.clipValue = (int)(21.0 * mean);
        }
        if (this.barRange == -1) {
            this.barRange = (int)((double)this.barMult * mean);
        }
        hr.setHelicorderExtents(this.startTime, this.endTime, -1 * Math.abs(this.barRange), Math.abs(this.barRange));
        hr.setClipValue(this.clipValue);
        hr.setShowClip(this.showClip);
        hr.setTimeZone(this.timeZone);
        hr.setShowDecorator(this.showDecorator);
        hr.setLargeChannelDisplay(this.largeChannelDisplay);
        if (this.minimumAxis) {
            hr.createMinimumAxis();
        } else {
            hr.createDefaultAxis();
        }
        if (this.showLegend) {
            hr.createDefaultLegendRenderer(new String[]{this.channelCode});
        }
    }

    public void setSizeFromPlotSize(int w, int h) {
        this.width = w - this.left * 2;
        this.height = h - (this.top + 50);
    }

    public void setMinimumSizes() {
        this.left = 31;
        this.top = 16;
    }

    public Plot createPlot(HelicorderData hd) {
        Plot plot = new Plot();
        plot.setSize(this.width + 140, this.height + 70);
        plot.setBackgroundColor(new Color(0.97f, 0.97f, 0.97f));
        HelicorderRenderer hr = new HelicorderRenderer();
        hr.setChannel(this.channel);
        this.applySettings(hr, hd);
        plot.addRenderer(hr);
        return plot;
    }
}

