/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data.file;

import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.Steim2;
import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class SeedDataFile
extends SeismicDataFile {
    protected SeedDataFile(String fileName) {
        super(fileName, "SEED^");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        HashMap tempStationMap = new HashMap();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            boolean isDone = false;
            while (!isDone) {
                ArrayList<Wave> parts;
                SeedRecord sr = null;
                try {
                    sr = SeedRecord.read((DataInput)dis, (int)4096);
                }
                catch (EOFException e) {
                    isDone = true;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                }
                if (!(sr instanceof DataRecord)) continue;
                DataRecord dr = (DataRecord)sr;
                DataHeader dh = dr.getHeader();
                if (this.network == null) {
                    this.network = dh.getNetworkCode().trim();
                }
                if (this.station == null) {
                    this.station = dh.getStationIdentifier().trim();
                }
                if (this.channel == null) {
                    this.channel = dh.getChannelIdentifier().trim();
                }
                if (this.location == null) {
                    this.location = dh.getLocationIdentifier();
                }
                String code = this.station + "$" + this.channel + "$" + this.network;
                if (this.location != null && !"  ".equals(this.location)) {
                    code = code + "$" + this.location;
                }
                if ((parts = (ArrayList<Wave>)tempStationMap.get(code)) == null) {
                    parts = new ArrayList<Wave>();
                    tempStationMap.put(code, parts);
                }
                if (dr.getDataSize() <= 0) continue;
                Wave sw = new Wave();
                sw.setSamplingRate(dh.getSampleRate());
                sw.setStartTime(Util.dateToJ2K(this.btimeToDate(dh.getStartBtime())));
                sw.buffer = this.extract(dr);
                sw.register();
                parts.add(sw);
            }
            for (String code : tempStationMap.keySet()) {
                List parts = (List)tempStationMap.get(code);
                ArrayList<Wave> subParts = new ArrayList<Wave>();
                int ns = 0;
                for (int i = 0; i < parts.size(); ++i) {
                    subParts.add((Wave)parts.get(i));
                    if ((ns += ((Wave)parts.get(i)).numSamples()) <= 360000 && i != parts.size() - 1) continue;
                    Wave w = (Wave)this.waves.get(code);
                    if (w != null) {
                        subParts.add(w);
                    }
                    Wave wave = Wave.join(subParts);
                    this.waves.put(code, wave);
                    ns = 0;
                    subParts.clear();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int[] extract(DataRecord dr) throws UnsupportedCompressionType, CodecException, SeedFormatException {
        int numPts = dr.getHeader().getNumSamples();
        int[] data = new int[numPts];
        int numSoFar = 0;
        DecompressedData decompData = dr.decompress();
        int[] temp = decompData.getAsInt();
        System.arraycopy(temp, 0, data, numSoFar, temp.length);
        numSoFar += temp.length;
        return data;
    }

    private Date btimeToDate(Btime btime) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, btime.getYear());
        cal.set(6, btime.getDayOfYear());
        cal.set(11, btime.getHour());
        cal.set(12, btime.getMin());
        cal.set(13, btime.getSec());
        cal.set(14, btime.getTenthMilli() / 10);
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write() throws IOException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        int seq = 1;
        for (String channel : this.waves.keySet()) {
            List<Wave> wavesSegments = ((Wave)this.waves.get(channel)).split(512);
            for (Wave wave : wavesSegments) {
                DataHeader header = new DataHeader(seq++, 'D', false);
                String[] channelCmp = channel.split("_");
                String s = channelCmp.length > 0 ? channelCmp[0] : "";
                String c = channelCmp.length > 1 ? channelCmp[1] : "";
                String n = channelCmp.length > 2 ? channelCmp[2] : "";
                String l = channelCmp.length > 3 ? channelCmp[3] : "";
                header.setStationIdentifier(s);
                header.setChannelIdentifier(c);
                header.setNetworkCode(n);
                header.setLocationIdentifier(l);
                header.setNumSamples((short)wave.numSamples());
                header.setSampleRate(wave.getSamplingRate());
                Btime btime = new Btime(Util.j2KToDate(wave.getStartTime()));
                header.setStartBtime(btime);
                DataRecord record = new DataRecord(header);
                try {
                    Blockette1000 blockette1000 = new Blockette1000();
                    blockette1000.setEncodingFormat((byte)11);
                    blockette1000.setWordOrder((byte)1);
                    blockette1000.setDataRecordLength((byte)12);
                    record.addBlockette((Blockette)blockette1000);
                    SteimFrameBlock data = null;
                    try {
                        data = Steim2.encode((int[])wave.buffer, (int)63);
                        record.setData(data.getEncodedData());
                        record.write(dos);
                    }
                    catch (SteimException e) {
                        e.printStackTrace();
                    }
                }
                catch (SeedFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        dos.close();
    }
}

