/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class GeographicFilter {
    private static ArrayList<double[]> Filters = new ArrayList();

    private static boolean inBox(double minLon, double maxLon, double minLat, double maxLat, double longitude, double latitude) {
        return longitude >= minLon & longitude <= maxLon & latitude >= minLat & latitude <= maxLat;
    }

    private static boolean inCircle(double radius, double lambda, double phi, double longitude, double latitude) {
        return radius * 1000.0 > Projection.distanceBetween(new Point2D.Double(lambda, phi), new Point2D.Double(longitude, latitude));
    }

    public void addBox(double minLon, double maxLon, double minLat, double maxLat) {
        double[] Box2 = new double[]{1.0, minLon, maxLon, minLat, maxLat};
        Filters.add(Box2);
    }

    public void addCircle(double radius, double lambda, double phi) {
        double[] Circle = new double[]{0.0, radius, lambda, phi};
        Filters.add(Circle);
    }

    public boolean test(double longitude, double latitude) {
        boolean result = true;
        if (Filters.size() != 0) {
            for (int k = 0; k < Filters.size(); ++k) {
                double[] parameters = Filters.get(k);
                switch ((int)parameters[0]) {
                    case 0: {
                        result = GeographicFilter.inCircle(parameters[1], parameters[2], parameters[3], longitude, latitude);
                        break;
                    }
                    case 1: {
                        result = GeographicFilter.inBox(parameters[1], parameters[2], parameters[3], parameters[4], longitude, latitude);
                    }
                }
                if (!result) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

