/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmLayout;
import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Logger;

public class SwarmConfig {
    private static Logger logger = Log.getLogger("gov.usgs.swarm");
    private static String[] DEFAULT_SERVERS = new String[]{"AVO Winston;wws:pubavo1.wr.usgs.gov:16022:10000:1"};
    private static String DEFAULT_CONFIG_FILE = "Swarm.config";
    private static String DEFAULT_DATA_SOURCES_FILE = "DataSources.config";
    public String configFilename;
    public int windowX;
    public int windowY;
    public int windowWidth;
    public int windowHeight;
    public boolean windowMaximized;
    public TimeZone specificTimeZone;
    public boolean useInstrumentTimeZone;
    public boolean useLocalTimeZone;
    public String lastPath;
    public boolean useLargeCursor;
    public boolean durationEnabled;
    public double durationA;
    public double durationB;
    public int span;
    public int timeChunk;
    public boolean showClip;
    public boolean alertClip;
    public int alertClipTimeout;
    public String kiosk;
    public boolean saveConfig;
    public int chooserDividerLocation;
    public boolean chooserVisible;
    public int nearestDividerLocation;
    public boolean clipboardVisible;
    public int clipboardX;
    public int clipboardY;
    public int clipboardWidth;
    public int clipboardHeight;
    public boolean clipboardMaximized;
    public boolean mapVisible;
    public int mapX;
    public int mapY;
    public int mapWidth;
    public int mapHeight;
    public boolean mapMaximized;
    public double mapScale;
    public double mapLongitude;
    public double mapLatitude;
    public String mapPath;
    public int mapLineWidth;
    public int mapLineColor;
    public String[] userTimes;
    public Color[] heliColors;
    public String heliColorsString;
    public Map<String, SeismicDataSource> sources;
    private Map<String, Metadata> metadata;
    private Map<String, Metadata> defaultMetadata;
    public SortedMap<String, SwarmLayout> layouts;
    public boolean useWMS;
    public String wmsServer;
    public String wmsLayer;
    public String wmsStyles;
    public String labelSource;

    private SwarmConfig() {
    }

    public static SwarmConfig getInstance() {
        return SwarmConfigHolder.swarmConfig;
    }

    public void createConfig(String[] args) {
        String configFile;
        logger.fine("current directory: " + System.getProperty("user.dir"));
        logger.fine("user.home: " + System.getProperty("user.home"));
        int n = args.length - 1;
        if (n >= 0 && !args[n].startsWith("-")) {
            configFile = args[n];
        } else {
            LinkedList<String> candidateNames = new LinkedList<String>();
            candidateNames.add(DEFAULT_CONFIG_FILE);
            candidateNames.add(System.getProperty("user.home") + File.separatorChar + DEFAULT_CONFIG_FILE);
            candidateNames.add("gov.usgs.swarm.Swam");
            configFile = ConfigFile.findConfig(candidateNames);
        }
        if (configFile == null) {
            configFile = DEFAULT_CONFIG_FILE;
        }
        logger.fine("Using configuration file: " + configFile);
        ConfigFile cf = new ConfigFile(configFile);
        cf.put("configFile", configFile, false);
        for (int i = 0; i <= n; ++i) {
            if (!args[i].startsWith("--")) continue;
            String key = args[i].substring(2, args[i].indexOf(61));
            String val = args[i].substring(args[i].indexOf(61) + 1);
            logger.fine("command line: " + key + " = " + val);
            cf.put(key, val, false);
        }
        this.parseConfig(cf);
        LinkedList<String> candidateNames = new LinkedList<String>();
        candidateNames.add("SwarmMetadata.config");
        candidateNames.add(System.getProperty("user.home") + File.separatorChar + "SwarmMetadata.config");
        String metadataConfigFile = ConfigFile.findConfig(candidateNames);
        if (metadataConfigFile == null) {
            metadataConfigFile = "SwarmMetadata.config";
        } else {
            logger.fine("Using metadata configuration file: " + metadataConfigFile);
        }
        this.defaultMetadata = Metadata.loadMetadata(metadataConfigFile);
        this.metadata = Collections.synchronizedMap(new HashMap());
        this.loadDataSources();
        this.loadLayouts();
    }

    private void loadDataSources() {
        LinkedList<String> candidateNames = new LinkedList<String>();
        candidateNames.add(DEFAULT_DATA_SOURCES_FILE);
        candidateNames.add(System.getProperty("user.home") + File.separatorChar + DEFAULT_DATA_SOURCES_FILE);
        String configName = Util.stringToString(ConfigFile.findConfig(candidateNames), DEFAULT_DATA_SOURCES_FILE);
        ConfigFile cf = new ConfigFile(configName);
        List<String> servers = cf.getList("server");
        if (servers != null) {
            for (String server : servers) {
                SeismicDataSource sds = DataSourceType.parseConfig(server);
                if (sds == null) {
                    logger.info("Skipping unknown data soruce " + server);
                    continue;
                }
                sds.setStoreInUserConfig(false);
                this.sources.put(sds.getName(), sds);
            }
        }
    }

    private void loadLayouts() {
        this.layouts = new TreeMap<String, SwarmLayout>();
        File[] files = new File("layouts").listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            SwarmLayout sl;
            if (f.isDirectory() || (sl = SwarmLayout.createSwarmLayout(f.getPath())) == null) continue;
            this.layouts.put(sl.getName(), sl);
        }
    }

    public void addLayout(SwarmLayout sl) {
        this.layouts.put(sl.getName(), sl);
    }

    public void removeLayout(SwarmLayout layout) {
        this.layouts.remove(layout.getName());
        layout.delete();
    }

    public void removeMetadata(String ch) {
        this.metadata.remove(ch);
    }

    public Map<String, Metadata> getMetadata() {
        return this.metadata;
    }

    public Metadata getMetadata(String channel) {
        return this.getMetadata(channel, false);
    }

    public Metadata getMetadata(String channel, boolean create) {
        Metadata md = this.metadata.get(channel);
        if (md == null) {
            md = this.defaultMetadata.get(channel);
        }
        if (md == null && create) {
            md = new Metadata(channel);
        }
        if (md != null) {
            this.metadata.put(channel, md);
        }
        return md;
    }

    public void assignMetadataSource(Collection<String> channels, SeismicDataSource source) {
        for (String ch : channels) {
            Metadata md = this.getMetadata(ch, true);
            md.source = source;
        }
    }

    public void parseConfig(ConfigFile config) {
        this.configFilename = config.getString("configFile");
        this.windowX = Util.stringToInt(config.getString("windowX"), 10);
        this.windowY = Util.stringToInt(config.getString("windowY"), 10);
        this.windowWidth = Util.stringToInt(config.getString("windowSizeX"), 1000);
        this.windowHeight = Util.stringToInt(config.getString("windowSizeY"), 700);
        this.windowMaximized = Util.stringToBoolean(config.getString("windowMaximized"), false);
        this.chooserDividerLocation = Util.stringToInt(config.getString("chooserDividerLocation"), 200);
        this.chooserVisible = Util.stringToBoolean(config.getString("chooserVisible"), true);
        this.nearestDividerLocation = Util.stringToInt(config.getString("nearestDividerLocation"), 600);
        this.specificTimeZone = TimeZone.getTimeZone(Util.stringToString(config.getString("specificTimeZone"), "UTC"));
        this.useInstrumentTimeZone = Util.stringToBoolean(config.getString("useInstrumentTimeZone"), true);
        this.useLocalTimeZone = Util.stringToBoolean(config.getString("useLocalTimeZone"), true);
        this.useLargeCursor = Util.stringToBoolean(config.getString("useLargeCursor"), false);
        this.span = Util.stringToInt(config.getString("span"), 24);
        this.timeChunk = Util.stringToInt(config.getString("timeChunk"), 30);
        this.lastPath = Util.stringToString(config.getString("lastPath"), "default");
        this.kiosk = Util.stringToString(config.getString("kiosk"), "false");
        this.saveConfig = Util.stringToBoolean(config.getString("saveConfig"), true);
        this.durationEnabled = Util.stringToBoolean(config.getString("durationEnabled"), false);
        this.durationA = Util.stringToDouble(config.getString("durationA"), 1.86);
        this.durationB = Util.stringToDouble(config.getString("durationB"), -0.85);
        this.showClip = Util.stringToBoolean(config.getString("showClip"), true);
        this.alertClip = Util.stringToBoolean(config.getString("alertClip"), false);
        this.alertClipTimeout = Util.stringToInt(config.getString("alertClipTimeout"), 5);
        this.clipboardVisible = Util.stringToBoolean(config.getString("clipboardVisible"), true);
        this.clipboardX = Util.stringToInt(config.getString("clipboardX"), 25);
        this.clipboardY = Util.stringToInt(config.getString("clipboardY"), 25);
        this.clipboardWidth = Util.stringToInt(config.getString("clipboardSizeX"), 600);
        this.clipboardHeight = Util.stringToInt(config.getString("clipboardSizeY"), 600);
        this.clipboardMaximized = Util.stringToBoolean(config.getString("clipboardMaximized"), false);
        this.mapPath = Util.stringToString(config.getString("mapPath"), "mapdata");
        this.mapVisible = Util.stringToBoolean(config.getString("mapVisible"), true);
        this.mapX = Util.stringToInt(config.getString("mapX"), 5);
        this.mapY = Util.stringToInt(config.getString("mapY"), 5);
        this.mapWidth = Util.stringToInt(config.getString("mapWidth"), 600);
        this.mapWidth = Math.max(this.mapWidth, 100);
        this.mapHeight = Util.stringToInt(config.getString("mapHeight"), 510);
        this.mapHeight = Math.max(this.mapHeight, 100);
        this.mapMaximized = Util.stringToBoolean(config.getString("mapMaximized"), false);
        this.mapScale = Util.stringToDouble(config.getString("mapScale"), 80000.0);
        this.mapLongitude = Util.stringToDouble(config.getString("mapLongitude"), -180.0);
        this.mapLatitude = Util.stringToDouble(config.getString("mapLatitude"), 0.0);
        this.mapLineWidth = Util.stringToInt(config.getString("mapLineWidth"), 2);
        this.mapLineColor = Util.stringToInt(config.getString("mapLineColor"), 0);
        this.useWMS = Util.stringToBoolean(config.getString("useWMS"));
        this.wmsServer = Util.stringToString(config.getString("wmsServer"), "http://wms.jpl.nasa.gov/wms.cgi");
        this.wmsLayer = Util.stringToString(config.getString("wmsLayer"), "global_mosaic");
        this.wmsStyles = Util.stringToString(config.getString("wmsStyles"), "visual");
        this.labelSource = Util.stringToString(config.getString("labelSource"), "");
        this.sources = new HashMap<String, SeismicDataSource>();
        List<String> servers = config.getList("server");
        if (servers != null && servers.size() > 0) {
            for (String server : servers) {
                SeismicDataSource sds = DataSourceType.parseConfig(server);
                if (sds == null) {
                    logger.info("Skipping unknown data soruce " + server);
                    continue;
                }
                this.sources.put(sds.getName(), sds);
            }
        } else {
            for (String s : DEFAULT_SERVERS) {
                SeismicDataSource sds = DataSourceType.parseConfig(s);
                this.sources.put(sds.getName(), sds);
            }
        }
        this.userTimes = Util.stringToString(config.getString("userTimes"), "").split(",");
        this.heliColorsString = Util.stringToString(config.getString("heliColors"), "");
        if (this.heliColorsString != null && this.heliColorsString.length() > 3) {
            String[] color = this.heliColorsString.split(":");
            this.heliColors = new Color[color.length];
            for (int i = 0; i < color.length; ++i) {
                String[] parts = color[i].split(",");
                if (parts.length == 3) {
                    float red = Float.parseFloat(parts[0].trim());
                    float green = Float.parseFloat(parts[1].trim());
                    float blue = Float.parseFloat(parts[2].trim());
                    try {
                        this.heliColors[i] = new Color(red / 256.0f, green / 256.0f, blue / 256.0f);
                    }
                    catch (RuntimeException e) {
                        this.heliColors[i] = Color.magenta;
                    }
                    continue;
                }
                this.heliColors[i] = Color.magenta;
            }
        }
    }

    public SeismicDataSource getSource(String key) {
        return this.sources.get(key);
    }

    public boolean sourceExists(String key) {
        return this.sources.containsKey(key);
    }

    public void addSource(SeismicDataSource source) {
        this.sources.put(source.getName(), source);
    }

    public void removeSource(String key) {
        this.sources.remove(key);
    }

    public double getDurationMagnitude(double t) {
        return this.durationA * (Math.log(t) / Math.log(10.0)) + this.durationB;
    }

    public TimeZone getTimeZone(String channel) {
        Metadata md;
        if (this.useInstrumentTimeZone && channel != null && (md = this.getMetadata(channel, false)) != null && md.getTimeZone() != null) {
            return md.getTimeZone();
        }
        if (this.useLocalTimeZone) {
            return TimeZone.getDefault();
        }
        return this.specificTimeZone;
    }

    public boolean isKiosk() {
        return !this.kiosk.toLowerCase().equals("false");
    }

    public ConfigFile toConfigFile() {
        ConfigFile config = new ConfigFile();
        config.put("configFile", this.configFilename);
        config.put("windowX", Integer.toString(this.windowX));
        config.put("windowY", Integer.toString(this.windowY));
        config.put("windowSizeX", Integer.toString(this.windowWidth));
        config.put("windowSizeY", Integer.toString(this.windowHeight));
        config.put("chooserDividerLocation", Integer.toString(this.chooserDividerLocation));
        config.put("chooserVisible", Boolean.toString(this.chooserVisible));
        config.put("nearestDividerLocation", Integer.toString(this.nearestDividerLocation));
        config.put("specificTimeZone", this.specificTimeZone.getID());
        config.put("useInstrumentTimeZone", Boolean.toString(this.useInstrumentTimeZone));
        config.put("useLocalTimeZone", Boolean.toString(this.useLocalTimeZone));
        config.put("windowMaximized", Boolean.toString(this.windowMaximized));
        config.put("useLargeCursor", Boolean.toString(this.useLargeCursor));
        config.put("span", Integer.toString(this.span));
        config.put("timeChunk", Integer.toString(this.timeChunk));
        config.put("lastPath", this.lastPath);
        config.put("kiosk", this.kiosk);
        config.put("saveConfig", Boolean.toString(this.saveConfig));
        config.put("durationEnabled", Boolean.toString(this.durationEnabled));
        config.put("durationA", Double.toString(this.durationA));
        config.put("durationB", Double.toString(this.durationB));
        config.put("showClip", Boolean.toString(this.showClip));
        config.put("alertClip", Boolean.toString(this.alertClip));
        config.put("alertClipTimeout", Integer.toString(this.alertClipTimeout));
        config.put("clipboardVisible", Boolean.toString(this.clipboardVisible));
        config.put("clipboardX", Integer.toString(this.clipboardX));
        config.put("clipboardY", Integer.toString(this.clipboardY));
        config.put("clipboardSizeX", Integer.toString(this.clipboardWidth));
        config.put("clipboardSizeY", Integer.toString(this.clipboardHeight));
        config.put("clipboardMaximized", Boolean.toString(this.clipboardMaximized));
        config.put("mapPath", this.mapPath);
        config.put("mapVisible", Boolean.toString(this.mapVisible));
        config.put("mapX", Integer.toString(this.mapX));
        config.put("mapY", Integer.toString(this.mapY));
        config.put("mapWidth", Integer.toString(this.mapWidth));
        config.put("mapHeight", Integer.toString(this.mapHeight));
        config.put("mapMaximized", Boolean.toString(this.mapMaximized));
        config.put("mapScale", Double.toString(this.mapScale));
        config.put("mapLongitude", Double.toString(this.mapLongitude));
        config.put("mapLatitude", Double.toString(this.mapLatitude));
        config.put("mapLineWidth", Integer.toString(this.mapLineWidth));
        config.put("mapLineColor", Integer.toString(this.mapLineColor));
        config.put("useWMS", Boolean.toString(this.useWMS));
        config.put("wmsServer", this.wmsServer);
        config.put("wmsLayer", this.wmsLayer);
        config.put("wmsStyles", this.wmsStyles);
        config.put("labelSource", this.labelSource);
        ArrayList<String> servers = new ArrayList<String>();
        for (SeismicDataSource sds : this.sources.values()) {
            if (!sds.isStoreInUserConfig()) continue;
            servers.add(sds.toConfigString());
        }
        config.putList("server", servers);
        StringBuilder utsb = new StringBuilder();
        for (int i = 0; i < this.userTimes.length - 1; ++i) {
            utsb.append(this.userTimes[i]);
            utsb.append(",");
        }
        if (this.userTimes.length > 0) {
            utsb.append(this.userTimes[this.userTimes.length - 1]);
        }
        config.put("userTimes", utsb.toString());
        if (this.heliColorsString != null && this.heliColorsString.length() > 3) {
            config.put("heliColors", this.heliColorsString);
        }
        return config;
    }

    public String toString() {
        return this.toConfigFile().toString();
    }

    private static class SwarmConfigHolder {
        public static SwarmConfig swarmConfig = new SwarmConfig();

        private SwarmConfigHolder() {
        }
    }
}

