/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.seedLink.orfeus;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.BlocketteDecoratorFactory;
import edu.iris.Fissures.seed.container.Waveform;
import gov.usgs.swarm.data.seedLink.orfeus.BaseSLConnection;
import gov.usgs.swarm.data.seedLink.orfeus.BaseSLLog;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nl.knmi.orfeus.SLClient;
import nl.knmi.orfeus.seedlink.SLLog;
import nl.knmi.orfeus.seedlink.SLPacket;
import nl.knmi.orfeus.seedlink.SeedLinkException;

public class BaseSLClient
implements Runnable {
    public static final String PACKAGE = "gov.usgs.swarm.data.orfeus";
    public static final String CLASS_NAME = "BaseSLClient";
    public final BaseSLConnection slconn;
    public int verbose = 0;
    public boolean ppackets = false;
    public String streamfile = null;
    public String selectors = null;
    public String multiselect = null;
    public String statefile = null;
    protected String begin_time = null;
    protected String end_time = null;
    public String infolevel = null;
    public final SLLog sllog;

    public BaseSLClient() {
        this(new BaseSLLog());
    }

    public BaseSLClient(SLLog sllog) {
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < SLClient.BANNER.length; ++n) {
            if (sb.length() != 0) {
                sb.append('\n');
            }
            sb.append(SLClient.BANNER[n]);
        }
        sllog.log(false, 1, sb.toString());
        this.sllog = sllog;
        this.slconn = new BaseSLConnection(sllog);
    }

    public int parseCmdLineArgs(String[] args) {
        if (args.length < 1) {
            this.printUsage(false);
            return 1;
        }
        for (int optind = 0; optind < args.length; ++optind) {
            if (args[optind].equals("-V")) {
                System.err.println("SLClient v1.2.1X00 (29Jan2013)");
                return 1;
            }
            if (args[optind].equals("-h")) {
                this.printUsage(false);
                return 1;
            }
            if (args[optind].startsWith("-v")) {
                this.verbose += args[optind].length() - 1;
                if (!(this.sllog instanceof BaseSLLog)) continue;
                ((BaseSLLog)this.sllog).setVerbosity(this.verbose);
                continue;
            }
            if (args[optind].equals("-p")) {
                this.ppackets = true;
                continue;
            }
            if (args[optind].equals("-nt")) {
                this.slconn.setNetTimout(Integer.parseInt(args[++optind]));
                continue;
            }
            if (args[optind].equals("-nd")) {
                this.slconn.setNetDelay(Integer.parseInt(args[++optind]));
                continue;
            }
            if (args[optind].equals("-k")) {
                this.slconn.setKeepAlive(Integer.parseInt(args[++optind]));
                continue;
            }
            if (args[optind].equals("-l")) {
                this.streamfile = args[++optind];
                continue;
            }
            if (args[optind].equals("-s")) {
                this.selectors = args[++optind];
                continue;
            }
            if (args[optind].equals("-S")) {
                this.multiselect = args[++optind];
                continue;
            }
            if (args[optind].equals("-x")) {
                this.statefile = args[++optind];
                continue;
            }
            if (args[optind].equals("-t")) {
                this.begin_time = args[++optind];
                continue;
            }
            if (args[optind].equals("-e")) {
                this.end_time = args[++optind];
                continue;
            }
            if (args[optind].equals("-i")) {
                this.infolevel = args[++optind];
                continue;
            }
            if (args[optind].startsWith("-")) {
                System.err.println("Unknown option: " + args[optind]);
                return -1;
            }
            if (this.slconn.getSLAddress() == null) {
                this.slconn.setSLAddress(args[optind]);
                continue;
            }
            System.err.println("Unknown option: " + args[optind]);
            return -1;
        }
        return 0;
    }

    public void init() throws UnknownHostException, SeedLinkException {
        if (this.slconn.getSLAddress() == null) {
            String message = "no SeedLink server specified";
            throw new SeedLinkException(message);
        }
        if (this.verbose >= 2) {
            this.ppackets = true;
        }
        if (this.slconn.getSLAddress().startsWith(":")) {
            this.slconn.setSLAddress(InetAddress.getLocalHost().toString() + this.slconn.getSLAddress());
        }
        if (this.streamfile != null) {
            this.slconn.readStreamList(this.streamfile, this.selectors);
        }
        if (this.multiselect != null) {
            this.slconn.parseStreamlist(this.multiselect, this.selectors);
        } else if (this.streamfile == null) {
            this.slconn.setUniParams(this.selectors, -1, null);
        }
        if (this.statefile != null) {
            this.slconn.setStateFile(this.statefile);
        } else {
            if (this.begin_time != null) {
                this.slconn.setBeginTime(this.begin_time);
            }
            if (this.end_time != null) {
                this.slconn.setEndTime(this.end_time);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.oldrun();
        }
        catch (Exception ex) {
            this.sllog.log(true, 0, ex.getMessage());
        }
        this.slconn.close();
    }

    protected void oldrun() throws Exception {
        if (this.infolevel != null) {
            this.slconn.requestInfo(this.infolevel);
        }
        SLPacket slpack = null;
        int count = 1;
        while ((slpack = this.slconn.collect()) != null && slpack != SLPacket.SLTERMINATE) {
            slpack.getType();
            BlocketteDecoratorFactory.reset();
            try {
                boolean terminate = this.packetHandler(count, slpack);
                if (terminate) {
                    break;
                }
            }
            catch (SeedLinkException sle) {
                this.sllog.log(true, 0, "BaseSLClient: " + (Object)((Object)sle));
            }
            if (count >= Integer.MAX_VALUE) {
                count = 1;
                this.sllog.log(false, 1, "BaseSLClient: Packet count reset to 1");
                continue;
            }
            ++count;
        }
    }

    public boolean packetHandler(int count, SLPacket slpack) throws Exception {
        if (slpack == null || slpack == SLPacket.SLNOPACKET || slpack == SLPacket.SLERROR) {
            return false;
        }
        int seqnum = slpack.getSequenceNumber();
        int type = slpack.getType();
        if (type == -102) {
            return false;
        }
        if (type == -101) {
            this.sllog.log(false, 0, "Complete INFO:\n" + this.slconn.getInfoString());
            return this.infolevel != null;
        }
        if (count % 100 == 0) {
            String infostr = "ID";
            this.slconn.requestInfo(infostr);
        }
        this.sllog.log(false, 0, "BaseSLClient: packet seqnum: " + seqnum + ": packet type: " + type);
        if (!this.ppackets) {
            return false;
        }
        Blockette blockette = slpack.getBlockette();
        this.sllog.log(false, 0, "BaseSLClient: blockette type: " + blockette.getType() + ": blockette: " + blockette);
        Waveform waveform = blockette.getWaveform();
        if (waveform != null) {
            this.sllog.log(false, 0, "BaseSLClient: blockette contains a waveform of length: " + waveform.getNumSamples());
        } else {
            this.sllog.log(false, 0, "BaseSLClient: blockette contains no waveform");
        }
        return false;
    }

    public void printUsage(boolean concise) {
        System.err.println("\nUsage: java [-cp classpath] gov.usgs.swarm.data.orfeus.BaseSLClient [options] <[host]:port>\n");
        if (concise) {
            System.err.println("Use '-h' for detailed help");
            return;
        }
        System.err.println(" ## General program options ##\n -V             report program version\n -h             show this usage message\n -v             be more verbose, multiple flags can be used\n -p             print details of data packets\n\n -nd delay      network re-connect delay (seconds), default 30\n -nt timeout    network timeout (seconds), re-establish connection if no\n                  data/keepalives are received in this time, default 600\n -k interval    send keepalive (heartbeat) packets this often (seconds)\n -x statefile   save/restore stream state information to this file\n -t begintime   sets a beginning time for the initiation of data transmission (year,month,day,hour,minute,second)\n -e endtime     sets an end time for windowed data transmission  (year,month,day,hour,minute,second)\n -i infolevel   request this INFO level, write response to std out, and exit \n                  infolevel is one of: ID, STATIONS, STREAMS, GAPS, CONNECTIONS, ALL \n\n ## Data stream selection ##\n -l listfile    read a stream list from this file for multi-station mode\n -s selectors   selectors for uni-station or default for multi-station\n -S streams     select streams for multi-station (requires SeedLink >= 2.5)\n   'streams' = 'stream1[:selectors1],stream2[:selectors2],...'\n        'stream' is in NET_STA format, for example:\n        -S \"IU_KONO:BHE BHN,GE_WLF,MN_AQU:HH?.D\"\n\n <[host]:port>  Address of the SeedLink server in host:port format\n                  if host is omitted (i.e. ':18000'), localhost is assumed\n\n");
    }

    public static void main(String[] args) {
        BaseSLClient slClient = null;
        try {
            slClient = new BaseSLClient();
            int rval = slClient.parseCmdLineArgs(args);
            if (rval != 0) {
                System.exit(rval);
            }
            slClient.init();
            slClient.run();
        }
        catch (SeedLinkException sle) {
            slClient.sllog.log(true, 0, sle.getMessage());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

