/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.volcanoes.pensive;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.volcanoes.pensive.PlotScheduler;
import gov.usgs.volcanoes.pensive.page.Page;
import gov.usgs.volcanoes.pensive.plot.SubnetPlotter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pensive {
    public static final boolean DEFAULT_WRITE_HTML = true;
    public static final String DEFAULT_CONFIG_FILENAME = "pensive.config";
    private static final Logger LOGGER = LoggerFactory.getLogger(Pensive.class);
    private ConfigFile configFile;
    private Page page;
    private Map<String, PlotScheduler> plotScheduler;
    public static final String JSAP_PROGRAM_NAME = "java -jar net.stash.pensive.Pensive";
    public static final String JSAP_EXPLANATION_PREFACE = "I am the Pensive server";
    private static final String DEFAULT_JSAP_EXPLANATION = "\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new Switch("create-config", 'c', "create-config", "Create an example config file in the curent working directory."), new Switch("verbose", 'v', "verbose", "Verbose logging."), new UnflaggedOption("configFilename", JSAP.STRING_PARSER, "pensive.config", false, false, "The config file name.")};

    public Pensive(ConfigFile configFile) {
        this.configFile = configFile;
        long now = System.currentTimeMillis();
        configFile.put("applicationLaunch", "" + now);
        LOGGER.info("Launching Pensive ({})", (Object)Pensive.getVersion());
        this.page = new Page(configFile);
        this.createPlotSchedulers();
        this.assignSubnets();
        this.pruneSchedulers();
        boolean writeHtml = configFile.getBoolean("writeHtml", true);
        if (writeHtml) {
            this.page.writeHTML();
        }
    }

    private void createPlotSchedulers() {
        this.plotScheduler = new HashMap<String, PlotScheduler>();
        for (String server : this.configFile.getList("waveSource")) {
            ConfigFile c = this.configFile.getSubConfig(server, true);
            LOGGER.info("Creating plot scheduler for " + server);
            this.plotScheduler.put(server, new PlotScheduler(server, c));
        }
    }

    private void assignSubnets() {
        List<String> networks = this.configFile.getList("network");
        if (networks == null) {
            throw new RuntimeException("No network directives found.");
        }
        Iterator<String> networkIt = networks.iterator();
        while (networkIt.hasNext()) {
            String network = networkIt.next();
            ConfigFile netConfig = this.configFile.getSubConfig(network, true);
            List<String> subnets = netConfig.getList("subnet");
            if (subnets == null) {
                LOGGER.info("No subnet directives for network " + network + " found. Skipping.");
                networkIt.remove();
                continue;
            }
            Iterator<String> subnetIt = subnets.iterator();
            while (subnetIt.hasNext()) {
                String subnet = subnetIt.next();
                ConfigFile subnetConfig = netConfig.getSubConfig(subnet, true);
                if (subnetConfig.getList("channel") == null) {
                    LOGGER.warn("No channel directives for subnet " + subnet + " found. Skipping.");
                    subnetIt.remove();
                    continue;
                }
                this.page.addSubnet(network, subnet);
                String dataSource = subnetConfig.getString("dataSource");
                PlotScheduler scheduler = this.plotScheduler.get(dataSource);
                LOGGER.info("Assigning subnet " + subnet + " to " + dataSource);
                scheduler.add(new SubnetPlotter(network, subnet, subnetConfig));
            }
            netConfig.putList("subnet", subnets);
        }
        this.configFile.putList("network", networks);
        Iterator<String> schedulerIt = this.plotScheduler.keySet().iterator();
        while (schedulerIt.hasNext()) {
            String server = schedulerIt.next();
            PlotScheduler ps = this.plotScheduler.get(server);
            if (ps.subnetCount() >= 1) continue;
            LOGGER.warn("No subnets feeding from " + ps.name + ". I'll prune it.");
            schedulerIt.remove();
        }
    }

    private void pruneSchedulers() {
        Iterator<String> schedulerIt = this.plotScheduler.keySet().iterator();
        while (schedulerIt.hasNext()) {
            String server = schedulerIt.next();
            PlotScheduler ps = this.plotScheduler.get(server);
            if (ps.subnetCount() >= 1) continue;
            LOGGER.warn("No subnets feeding from " + ps.name + ". I'll prune it.");
            schedulerIt.remove();
        }
    }

    private void schedulePlots() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        for (PlotScheduler ps : this.plotScheduler.values()) {
            new Thread(ps).start();
            int delay = 600;
            delay = (int)((long)delay - System.currentTimeMillis() / 1000L % 600L);
            LOGGER.debug("Scheduled plots start in " + delay + "ms");
            scheduler.scheduleAtFixedRate(ps, delay, 600L, TimeUnit.SECONDS);
        }
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, "I am the Pensive server\n", DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createConfig() throws IOException {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("pensive-example.config");
        FileOutputStream os = new FileOutputStream(DEFAULT_CONFIG_FILENAME);
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            is.close();
            os.close();
        }
    }

    public static String getVersion() {
        String[] v = Util.getVersion(Pensive.class.getPackage().getName());
        String version = v != null ? "Version: " + v[0] + " Built: " + v[1] : "No version information available.";
        return version;
    }

    public static void main(String[] args) {
        String fn;
        ConfigFile cf;
        JSAPResult config = Pensive.getArguments(args);
        if (config.getBoolean("create-config")) {
            try {
                LOGGER.warn("Creating example config pensive.config");
                Pensive.createConfig();
            }
            catch (IOException e) {
                LOGGER.warn("Cannot write example config. " + e.getLocalizedMessage());
            }
            System.exit(0);
        }
        if (!(cf = new ConfigFile(fn = config.getString("configFilename"))).wasSuccessfullyRead()) {
            LOGGER.warn("Can't parse config file " + fn + ". Try using the --help flag.");
            System.exit(1);
        }
        Pensive pensive = new Pensive(cf);
        pensive.schedulePlots();
    }
}

