/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.winston.monitor.Collector;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CalPulseCollector
extends Collector {
    public static final int DEFAULT_INSPECTION_WINDOW = 20;
    public static final int DEFAULT_INSPECTION_INTERVAL = 60;
    private int inspectionWindow;
    private int inspectionInterval;

    @Override
    protected void configure(String n, ConfigFile cc, ConfigFile wc) {
        this.winstonConfig(wc);
        Thread.currentThread().setName(n);
        this.inspectionWindow = Util.stringToInt(this.config.getString("inspectionWindow"), 20);
        this.logger.info("config: inspectionWindow=" + this.inspectionWindow);
        this.inspectionInterval = Util.stringToInt(this.config.getString("instpectionInterval"), 60);
    }

    @Override
    public void run() {
        if (!this.winston.useRootDatabase()) {
            this.fatalError("Can't use root database");
        }
        String sql = "SELECT code, value from channels, channelmetadata WHERE channels.sid=channelmetadata.sid";
        try {
            ResultSet rs = this.winston.getStatement().executeQuery(sql);
            while (rs.next()) {
                String code = rs.getString("code");
                double j2kTime = rs.getDouble("value");
                System.out.println(String.format("Cal pulse found: %s at %s", code, Util.j2KToDateString(j2kTime)));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        try {
            Thread.sleep(this.inspectionInterval * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

