/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.HttpResponse;
import gov.usgs.net.NetTools;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Util;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WaveServerEmulator;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractHttpCommand {
    protected static final String INPUT_DATE_FORMAT = "yyyyMMddHHmm";
    protected static final String DISPLAY_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    protected static final int ONE_MINUTE = 60;
    protected static final int ONE_HOUR = 3600;
    protected static final int ONE_DAY = 86400;
    protected static final String DEFAULT_TZ = "UTC";
    protected SocketChannel socketChannel;
    protected NetTools netTools;
    protected WinstonDatabase winston;
    protected WWS wws;
    protected Data data;
    protected WaveServerEmulator emulator;
    protected int maxDays;
    protected HttpRequest request;
    protected String cmd;
    protected Map<String, String> arguments;
    protected DecimalFormat decimalFormat;

    public abstract String getCommand();

    protected abstract void sendResponse();

    protected AbstractHttpCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        this.netTools = nt;
        this.winston = db;
        this.wws = wws;
        this.maxDays = wws.getMaxDays();
        this.emulator = new WaveServerEmulator(db);
        this.data = new Data(db);
        this.decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        this.decimalFormat.setMaximumFractionDigits(3);
        this.decimalFormat.setGroupingUsed(false);
    }

    public void respond(String cmd, SocketChannel c, HttpRequest request) {
        this.socketChannel = c;
        this.request = request;
        this.cmd = cmd;
        this.arguments = request.getArguments();
        this.sendResponse();
    }

    public void writeSimpleHTML(String msg) {
        String html = "<html><body>" + msg + "</body></html>";
        HttpResponse response = new HttpResponse("text/html");
        response.setLength(html.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(html, this.socketChannel);
    }

    public void writeSimpleText(String msg) {
        HttpResponse response = new HttpResponse("text/plain");
        response.setLength(msg.length());
        this.netTools.writeString(response.getHeaderString(), this.socketChannel);
        this.netTools.writeString(msg, this.socketChannel);
    }

    protected Double getStartTime(String t1, Double endTime, long mult) {
        Double startTime = Double.NaN;
        if (t1 == null || t1.substring(0, 1).equals("-")) {
            double hrs = Util.stringToDouble(t1, -12.0);
            startTime = endTime + hrs * (double)mult;
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(INPUT_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date bt = dateFormat.parse(t1);
                startTime = Util.dateToJ2K(bt);
            }
            catch (ParseException e) {
                startTime = Double.NaN;
            }
        }
        return this.timeOrMaxDays(startTime);
    }

    protected Double getStartTime(String t1, Double endTime, long mult, TimeZone tz) {
        double startTime = this.getStartTime(t1, endTime, mult);
        return this.timeOrMaxDays(startTime - (double)(tz.getOffset((long)Util.j2KToEW(endTime) * 1000L) / 1000));
    }

    protected Double getEndTime(String t2) {
        Double endTime = Double.NaN;
        if (t2 == null || t2.equalsIgnoreCase("now")) {
            endTime = CurrentTime.getInstance().nowJ2K();
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(INPUT_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date bt = dateFormat.parse(t2);
                endTime = Util.dateToJ2K(bt) - 1.0;
            }
            catch (ParseException e) {
                endTime = Double.NaN;
            }
        }
        return this.timeOrMaxDays(endTime);
    }

    protected Double getEndTime(String t2, TimeZone tz) {
        Double endTime = this.getEndTime(t2);
        return this.timeOrMaxDays(endTime - (double)(tz.getOffset((long)Util.j2KToEW(endTime) * 1000L) / 1000));
    }

    protected double timeOrMaxDays(double t) {
        if (this.maxDays == 0) {
            return t;
        }
        return Math.max(t, Util.nowJ2K() - (double)(this.maxDays * 86400));
    }

    protected int boolToInt(boolean in) {
        return in ? 1 : 0;
    }
}

