/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.command;

import gov.usgs.net.HttpRequest;
import gov.usgs.net.NetTools;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.command.FdsnCommand;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnChannelConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnGeographicCircleConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnGeographicSquareConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeSimpleConstraint;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeWindowConstraint;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;

public abstract class FdsnQueryCommand
extends FdsnCommand {
    protected static final Channel[] DUMMY_CHANNEL_ARRAY = new Channel[0];
    protected Deque<FdsnChannelConstraint> channelConstraints;
    protected FdsnConstraint geographicConstraint;
    protected FdsnConstraint timeConstraint;
    protected Channel[] chanList;
    protected Channels channels;
    protected Channel[] prunedChanList;

    protected FdsnQueryCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    public void respond(String cmd, SocketChannel c, HttpRequest request) {
        this.socketChannel = c;
        this.request = request;
        this.cmd = cmd;
        this.arguments = request.getArguments();
        try {
            this.parseArguments();
            List<Channel> chans = this.channels.getChannels();
            if (chans == null) {
                this.sendError(404, "Channels to found.");
                return;
            }
            this.chanList = this.channels.getChannels().toArray(DUMMY_CHANNEL_ARRAY);
            this.prunedChanList = this.pruneChanList();
            Arrays.sort(this.prunedChanList);
            this.sendResponse();
        }
        catch (FdsnException e) {
            this.sendError(e.code, e.message);
        }
    }

    protected void parseArguments() throws FdsnException {
        this.channelConstraints = new ArrayDeque<FdsnChannelConstraint>();
        if ("POST".equals(this.request.getMethod())) {
            this.parsePost();
        } else {
            this.parseGet();
        }
    }

    protected void parseGet() throws FdsnException {
        this.getChannelConstraints();
        this.getTimeConstraint();
        this.getGeographicConstraint();
    }

    private void getChannelConstraints() {
        String[] nets = this.getArgs((String)this.arguments.get("net") + "," + (String)this.arguments.get("network"));
        String[] stas = this.getArgs((String)this.arguments.get("sta") + "," + (String)this.arguments.get("station"));
        String[] locs = this.getArgs((String)this.arguments.get("loc") + "," + (String)this.arguments.get("location"));
        String[] chas = this.getArgs((String)this.arguments.get("cha") + "," + (String)this.arguments.get("channel"));
        for (String net : nets) {
            for (String sta : stas) {
                for (String loc : locs) {
                    for (String cha : chas) {
                        if (loc.equals("  ")) {
                            loc = "--";
                        }
                        FdsnChannelConstraint con = new FdsnChannelConstraint(sta, cha, net, loc);
                        this.channelConstraints.add(con);
                        System.out.println(con);
                    }
                }
            }
        }
    }

    private void getGeographicConstraint() throws FdsnException {
        String latitude = this.getArg("latitude", "lat");
        String longitude = this.getArg("longitude", "lon");
        String minRadius = (String)this.arguments.get("minradius");
        String maxRadius = (String)this.arguments.get("maxradius");
        if (latitude != null || longitude != null || minRadius != null || maxRadius != null) {
            this.geographicConstraint = new FdsnGeographicCircleConstraint(latitude, longitude, minRadius, maxRadius);
        } else {
            String minLatitude = this.getArg("minlatitude", "minLat");
            String maxLatitude = this.getArg("maxlatitude", "maxLat");
            String minLongitude = this.getArg("minlongitude", "minLon");
            String maxLongitude = this.getArg("maxlongitude", "maxLon");
            this.geographicConstraint = new FdsnGeographicSquareConstraint(minLatitude, maxLatitude, minLongitude, maxLongitude);
        }
        System.out.println(this.geographicConstraint);
    }

    private void getTimeConstraint() throws FdsnException {
        String startBefore = (String)this.arguments.get("startbefore");
        String startAfter = (String)this.arguments.get("startafter");
        String endBefore = (String)this.arguments.get("endbefore");
        String endAfter = (String)this.arguments.get("andafter");
        if (startBefore != null || startAfter != null || endBefore != null || endAfter != null) {
            this.timeConstraint = new FdsnTimeWindowConstraint(startBefore, startAfter, endBefore, endAfter);
        } else {
            String startTime = this.getArg("startTime", "start");
            String endTime = this.getArg("endTime", "end");
            this.timeConstraint = new FdsnTimeSimpleConstraint(startTime, endTime);
        }
        System.out.println(this.timeConstraint);
    }

    private String getArg(String s1, String s2) {
        String arg = (String)this.arguments.get(s1);
        if (arg == null) {
            arg = (String)this.arguments.get(s2);
        }
        return arg;
    }

    protected String[] getArgs(String arg) {
        if (arg == null || arg.equals("") || arg.equals("null")) {
            return new String[0];
        }
        arg = arg.replace(",null", ",");
        arg = arg.replace("null,", ",");
        arg = arg.replaceFirst("^,", "");
        arg = arg.replaceFirst(",$", "");
        arg = arg.replace(",,", ",");
        arg = arg.replace("*", ".*");
        arg = arg.replace("?", ".?");
        return arg.split(",");
    }

    protected void parsePost() throws FdsnException {
        String[] lines = this.request.fullRequest.split("\r\n");
        int index = 0;
        for (String line : lines) {
            ++index;
            if ("".equals(line)) break;
        }
        while (index < lines.length) {
            String[] s = lines[index].split("=");
            if (s.length == 2) {
                this.arguments.put(s[0], s[1]);
                continue;
            }
            s = lines[index].split(" ");
            if (lines.length != 6) {
                throw new FdsnException(400, "Can't parse SCNL request " + lines[index]);
            }
            if (s[2].equals("  ")) {
                s[2] = "--";
            }
            FdsnChannelConstraint c = new FdsnChannelConstraint(s[1], s[3], s[0], s[2]);
            this.channelConstraints.add(c);
            c.setTimeConstraint(new FdsnTimeSimpleConstraint(s[4], s[5]));
        }
    }

    protected Channel[] pruneChanList() {
        ArrayDeque<Channel> prunnedChans = new ArrayDeque<Channel>();
        for (Channel c : this.chanList) {
            if (!this.checkChannel(c)) continue;
            prunnedChans.offer(c);
        }
        return prunnedChans.toArray(DUMMY_CHANNEL_ARRAY);
    }

    private boolean checkChannel(Channel c) {
        boolean matches = false;
        for (FdsnConstraint fdsnConstraint : this.channelConstraints) {
            if (!fdsnConstraint.matches(c)) continue;
            matches = true;
            break;
        }
        if (matches && this.timeConstraint != null && !this.timeConstraint.matches(c)) {
            matches = false;
        }
        if (matches && this.geographicConstraint != null && !this.geographicConstraint.matches(c)) {
            matches = false;
        }
        return matches;
    }
}

