/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

public class Filter {
    public static void filter(double[] data, int size, double[] coeffX, double[] coeffY, double gain, double fillCount, double fill) {
        double[] yn = new double[size + 1];
        double[] xn = new double[size + 1];
        for (int i = 0; i < data.length; ++i) {
            int j;
            for (int j2 = 1; j2 < size + 1; ++j2) {
                yn[j2 - 1] = yn[j2];
                xn[j2 - 1] = xn[j2];
            }
            xn[size] = data[i] / gain;
            double y = 0.0;
            for (j = 0; j < size + 1; ++j) {
                y += xn[j] * coeffX[j];
            }
            for (j = 0; j < size; ++j) {
                y += yn[j] * coeffY[j];
            }
            yn[size] = y;
            data[i] = (double)i > fillCount ? y : fill;
        }
    }

    public static double[] filterWithCopy(double[] data, int size, double[] coeffX, double[] coeffY, double gain, double fillCount, double fill) {
        double[] nd = new double[data.length];
        System.arraycopy(data, 0, nd, 0, data.length);
        Filter.filter(nd, size, coeffX, coeffY, gain, fillCount, fill);
        return nd;
    }
}

