/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive;

import gov.usgs.pensive.PlotJob;
import gov.usgs.pensive.plot.SubnetPlotter;
import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaveSource
implements Runnable {
    private static final Logger LOGGER = Log.getLogger("gov.usgs");
    public static final String DEFAULT_TYPE = "wws";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_TIMEOUT_S = 15;
    private final SeismicDataSource dataSource;
    private BlockingQueue<PlotJob> plotJobs;
    public final String name;

    public WaveSource(String name, BlockingQueue<PlotJob> plotJobs, ConfigFile config) {
        this.plotJobs = plotJobs;
        this.name = name;
        String type = Util.stringToString(config.getString("type"), DEFAULT_TYPE);
        String host = Util.stringToString(config.getString("host"), DEFAULT_HOST);
        int port = Util.stringToInt(config.getString("port"), 16022);
        int timeout = Util.stringToInt(config.getString("timeout"), 15);
        int compress = 1;
        String dsString = name + ";" + type + ":" + host + ":" + port + ":" + timeout * 1000 + ":" + compress;
        this.dataSource = DataSourceType.parseConfig(dsString);
        this.dataSource.establish();
        this.dataSource.setUseCache(false);
    }

    @Override
    public void run() {
        while (true) {
            PlotJob pj = null;
            try {
                pj = this.plotJobs.take();
                if (System.currentTimeMillis() < pj.plotTimeMs) {
                    Thread.sleep(1000L);
                    this.plotJobs.put(pj);
                    continue;
                }
                SubnetPlotter subnet = pj.subnet;
                LOGGER.log(Level.FINE, "Ploting " + subnet.subnetName + " from " + this.name + " at " + Time.toDateString(System.currentTimeMillis()));
                subnet.plot(pj.plotEndMs, this.dataSource);
            }
            catch (InterruptedException noAction) {
            }
        }
    }
}

