/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.pensive.page;

import freemarker.cache.ClassTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class Page {
    private static final Logger LOGGER = Log.getLogger("gov.usgs");
    public static final String DEFAULT_PATH_ROOT = "html/";
    public static final String FILENAME = "index.html";
    private Map<String, Object> root;
    private Configuration cfg;
    private Map<String, List<String>> subnets;
    private final String pathRoot;

    public Page(ConfigFile config) {
        this.pathRoot = Util.stringToString(config.getString("pathRoot"), DEFAULT_PATH_ROOT);
        this.root = new HashMap<String, Object>();
        this.subnets = new HashMap<String, List<String>>();
        this.root.put("subnets", this.subnets);
        this.root.put("refreshPeriod", 600);
        this.root.put("filePathFormat", Util.stringToString(config.getString("filePathFormat"), "yyyy/DDD"));
        this.root.put("fileSuffixFormat", Util.stringToString(config.getString("fileSuffixFormat"), "_yyyyMMdd-HHmm"));
        this.root.put("selectedNetwork", config.getString("selectedNetwork"));
        try {
            this.initializeTemplateEngine();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "cannot write HTML");
        }
    }

    protected void initializeTemplateEngine() throws IOException {
        this.cfg = new Configuration();
        this.cfg.setTemplateLoader(new ClassTemplateLoader(this.getClass(), "/gov/usgs/pensive/page"));
        DefaultObjectWrapper obj = new DefaultObjectWrapper();
        obj.setExposeFields(true);
        this.cfg.setObjectWrapper(obj);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        this.cfg.setIncompatibleImprovements(new Version(2, 3, 20));
    }

    public void writeHTML() {
        try {
            File pRoot = new File(this.pathRoot);
            if (!pRoot.exists()) {
                pRoot.mkdirs();
            }
            Template template = this.cfg.getTemplate("pensive.html");
            String file = this.pathRoot + '/' + FILENAME;
            file.replace("/+", "/");
            file.replace("/", Matcher.quoteReplacement(File.separator));
            FileWriter fw = new FileWriter(file);
            template.process(this.root, fw);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void addSubnet(String network, String subnet) {
        List<String> s = this.subnets.get(network);
        if (s == null) {
            s = new ArrayList<String>();
            this.subnets.put(network, s);
        }
        s.add(subnet);
    }
}

