/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.data;

import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;

public class SliceWave {
    private Wave source;
    private int position;
    private int limit;
    private int readPosition;
    private transient double mean = Double.NaN;
    private transient double rsam = Double.NaN;
    private transient double max = -1.0E300;
    private transient double min = 1.0E300;
    private transient double b = Double.NaN;
    private transient double m = Double.NaN;
    private transient double[] dataRange = null;

    public SliceWave(Wave sw) {
        this.source = sw;
        this.position = 0;
        this.limit = this.source.buffer.length;
    }

    public Wave getWave() {
        return this.source;
    }

    public double[] getDataRange() {
        if (this.dataRange == null) {
            this.deriveStatistics();
        }
        return this.dataRange;
    }

    public int samples() {
        return this.limit - this.position;
    }

    public double getNyquist() {
        return this.source.getNyquist();
    }

    public double getSamplingRate() {
        return this.source.getSamplingRate();
    }

    public double getStartTime() {
        return this.source.getStartTime() + (double)this.position * (1.0 / this.getSamplingRate());
    }

    public double getEndTime() {
        return this.source.getStartTime() + (double)this.limit * (1.0 / this.getSamplingRate());
    }

    private double getTrueEndTime() {
        return this.getStartTime() + (double)this.source.buffer.length * (1.0 / this.getSamplingRate());
    }

    public void setSlice(double t1, double t2) {
        if (t1 < this.source.getStartTime() || t2 > this.getTrueEndTime() || t1 >= t2) {
            return;
        }
        this.invalidateStatistics();
        this.position = (int)Math.round((t1 - this.source.getStartTime()) * this.getSamplingRate());
        this.limit = this.position + (int)Math.round((t2 - t1) * this.getSamplingRate());
        if (this.limit > this.source.buffer.length) {
            this.limit = this.source.buffer.length;
        }
    }

    public void invalidateStatistics() {
        this.mean = Double.NaN;
        this.rsam = Double.NaN;
        this.max = -1.0E300;
        this.min = 1.0E300;
    }

    private void deriveStatistics() {
        if (this.source.buffer == null || this.source.buffer.length == 0) {
            this.mean = 0.0;
            this.rsam = 0.0;
            this.max = 0.0;
            this.min = 0.0;
            return;
        }
        int noDatas = 0;
        long sum = 0L;
        long rs = 0L;
        for (int i = this.position; i < this.limit; ++i) {
            int d = this.source.buffer[i];
            if (d != Wave.NO_DATA) {
                sum += (long)d;
                rs += (long)Math.abs(d);
                this.min = Math.min(this.min, (double)d);
                this.max = Math.max(this.max, (double)d);
                continue;
            }
            ++noDatas;
        }
        this.mean = (double)sum / (double)(this.samples() - noDatas);
        this.rsam = (double)rs / (double)(this.samples() - noDatas);
        this.dataRange = new double[]{this.min, this.max};
        double xm = (this.limit - this.position + 1) / 2;
        double ssxx = 0.0;
        double ssxy = 0.0;
        for (int i = this.position; i < this.limit; ++i) {
            if (this.source.buffer[i] == Wave.NO_DATA) continue;
            ssxy += ((double)i - xm) * ((double)this.source.buffer[i] - this.mean);
            ssxx += ((double)i - xm) * ((double)i - xm);
        }
        this.m = ssxy / ssxx;
        this.b = this.mean - this.m * xm;
    }

    public double mean() {
        if (Double.isNaN(this.mean)) {
            this.deriveStatistics();
        }
        return this.mean;
    }

    public double max() {
        if (this.max == -1.0E300) {
            this.deriveStatistics();
        }
        return this.max;
    }

    public double min() {
        if (this.min == 1.0E300) {
            this.deriveStatistics();
        }
        return this.min;
    }

    public double rsam() {
        if (Double.isNaN(this.rsam)) {
            this.deriveStatistics();
        }
        return this.rsam;
    }

    public boolean isData() {
        for (int i = 0; i < this.source.buffer.length; ++i) {
            if (this.source.buffer[i] == Wave.NO_DATA) continue;
            return true;
        }
        return false;
    }

    public double[] getSignal() {
        double mu = this.mean();
        int nSamples = this.samples();
        double[] signal = new double[nSamples];
        this.reset();
        for (int i = 0; i < nSamples; ++i) {
            signal[i] = this.next();
            if (signal[i] == (double)Wave.NO_DATA) {
                signal[i] = 0.0;
                continue;
            }
            int n = i;
            signal[n] = signal[n] - ((double)(i + 1) * this.m + this.b);
        }
        return signal;
    }

    public void reset() {
        this.readPosition = this.position;
    }

    public boolean hasNext() {
        return this.readPosition < this.limit;
    }

    public double next() {
        return this.source.buffer[this.readPosition++];
    }

    public String toCSV() {
        if (this.source.buffer == null || this.source.buffer.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        double time = this.getStartTime();
        for (int i = this.position; i < this.limit; ++i) {
            sb.append(Util.j2KToDateString(time) + ',' + this.source.buffer[i] + '\n');
            time += 1.0 / this.getSamplingRate();
        }
        return sb.toString();
    }
}

