/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render.wave;

import gov.usgs.plot.data.SliceWave;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.decorate.DefaultFrameDecorator;
import gov.usgs.plot.decorate.FrameDecorator;
import gov.usgs.plot.render.FrameRenderer;
import gov.usgs.plot.render.LegendRenderer;
import gov.usgs.plot.render.ShapeRenderer;
import gov.usgs.util.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class SliceWaveRenderer
extends FrameRenderer {
    protected SliceWave wave;
    protected boolean removeBias = false;
    protected boolean drawSamples = false;
    protected double highlightX1;
    protected double highlightX2;
    protected double viewStartTime;
    protected double viewEndTime;
    protected String timeZone;
    protected String dateFormatString = "yyyy-MM-dd HH:mm:ss";
    protected Color color = Color.BLUE;
    protected String yLabelText = null;
    protected String yUnitText = null;
    protected String title;
    protected FrameDecorator decorator;
    public boolean xTickMarks = true;
    public boolean xTickValues = true;
    public boolean xUnits = true;
    public boolean xLabel = false;
    public boolean yTickMarks = true;
    public boolean yTickValues = true;

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setHighlight(double x1, double x2) {
        this.highlightX1 = x1;
        this.highlightX2 = x2;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public void setMinY(double minY) {
        this.minY = minY;
    }

    public boolean isRemoveBias() {
        return this.removeBias;
    }

    public void setYLimits(double min, double max) {
        this.minY = min;
        this.maxY = max;
    }

    public void setRemoveBias(boolean b) {
        this.removeBias = b;
    }

    public void setDrawSamples(boolean b) {
        this.drawSamples = b;
    }

    public void setWave(SliceWave w) {
        this.wave = w;
    }

    public void setViewTimes(double t1, double t2, String timeZone) {
        this.viewStartTime = t1;
        this.viewEndTime = t2;
        this.timeZone = timeZone;
    }

    public void setViewTimes(String timeZone) {
        this.setViewTimes(this.wave.getStartTime(), this.wave.getEndTime(), timeZone);
    }

    public void setColor(Color c) {
        if (c != null) {
            this.color = c;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setYLabelText(String s) {
        this.yLabelText = s;
    }

    public void setYUnitText(String s) {
        this.yUnitText = s;
    }

    public void setTitle(String s) {
        this.title = s.split("\\.")[0];
    }

    public void createDefaultFrameDecorator() {
        this.decorator = new DefaultWaveFrameDecorator();
    }

    @Override
    public void createDefaultLegendRenderer(String[] s) {
        this.setLegendRenderer(new LegendRenderer());
        this.getLegendRenderer().x = this.graphX + 6;
        this.getLegendRenderer().y = this.graphY + 6;
        ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, 1));
        sr.antiAlias = true;
        sr.color = this.color;
        sr.stroke = new BasicStroke();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            this.getLegendRenderer().addLine(sr, null, s[i]);
        }
    }

    public void update() {
        if (this.decorator == null) {
            this.createDefaultFrameDecorator();
        }
        if (this.decorator instanceof DefaultFrameDecorator) {
            ((DefaultFrameDecorator)this.decorator).yAxisLabel = this.yLabelText;
        }
        this.setExtents(this.viewStartTime, this.viewEndTime, this.minY, this.maxY);
        this.decorator.decorate(this);
    }

    @Override
    public void render(Graphics2D g) {
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        double st = this.wave.getStartTime();
        double step = 1.0 / this.wave.getSamplingRate();
        this.wave.reset();
        double bias = this.removeBias ? this.wave.mean() : 0.0;
        g.setColor(this.color);
        double ns = (double)this.wave.samples() * (this.viewEndTime - this.viewStartTime) / (this.wave.getEndTime() - this.wave.getStartTime());
        double spp = ns / (double)this.graphWidth;
        Rectangle2D.Double box = new Rectangle2D.Double();
        if (spp < 50.0) {
            GeneralPath gp = new GeneralPath();
            double y = this.wave.next();
            gp.moveTo((float)this.getXPixel(st), (float)this.getYPixel(y - bias));
            float lastY = (float)this.getYPixel(y - bias);
            while (this.wave.hasNext()) {
                st += step;
                y = this.wave.next();
                if (y == (double)Wave.NO_DATA) {
                    gp.moveTo((float)this.getXPixel(st), lastY);
                    continue;
                }
                lastY = (float)this.getYPixel(y - bias);
                gp.lineTo((float)this.getXPixel(st), lastY);
                if (!this.drawSamples || !(1.0 / spp > 2.0)) continue;
                box.setRect((double)((float)this.getXPixel(st)) - 1.5, (double)lastY - 1.5, 3.0, 3.0);
                g.draw(box);
            }
            g.draw(gp);
        } else {
            int i;
            double[][] spans = new double[this.graphWidth + 1][];
            for (int i2 = 0; i2 < spans.length; ++i2) {
                spans[i2] = new double[]{1.0E300, -1.0E300};
            }
            double span = this.viewEndTime - this.viewStartTime;
            this.wave.reset();
            while (this.wave.hasNext()) {
                double y = this.wave.next();
                i = (int)((st - this.viewStartTime) / span * (double)this.graphWidth + 0.5);
                if (i >= 0 && i < spans.length && y != (double)Wave.NO_DATA) {
                    spans[i][0] = Math.min(y, spans[i][0]);
                    spans[i][1] = Math.max(y, spans[i][1]);
                }
                st += step;
            }
            Line2D.Double line = new Line2D.Double();
            double lastMinY = -1.0E300;
            double lastMaxY = 1.0E300;
            for (i = 0; i < spans.length; ++i) {
                double minY = this.getYPixel(spans[i][0] - bias);
                double maxY = this.getYPixel(spans[i][1] - bias);
                if (maxY < lastMinY) {
                    line.setLine(this.graphX + i - 1, lastMinY, this.graphX + i, maxY);
                    g.draw(line);
                } else if (minY > lastMaxY) {
                    line.setLine(this.graphX + i - 1, lastMaxY, this.graphX + i, minY);
                    g.draw(line);
                }
                line.setLine(this.graphX + i, minY, this.graphX + i, maxY);
                g.draw(line);
                lastMinY = minY;
                lastMaxY = maxY;
            }
        }
        if (this.getLegendRenderer() != null) {
            g.setColor(Color.BLACK);
            this.getLegendRenderer().render(g);
        }
        g.setClip(origClip);
        if (this.axis != null) {
            this.axis.postRender(g);
        }
        g.setStroke(origStroke);
        g.setColor(origColor);
    }

    protected class DefaultWaveFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultWaveFrameDecorator() {
            if (SliceWaveRenderer.this.yUnitText != null) {
                this.yUnit = SliceWaveRenderer.this.yUnitText;
            }
            if (SliceWaveRenderer.this.xUnits) {
                this.xUnit = SliceWaveRenderer.this.timeZone + " Time (" + Util.j2KToDateString(SliceWaveRenderer.this.viewStartTime, SliceWaveRenderer.this.dateFormatString) + " to " + Util.j2KToDateString(SliceWaveRenderer.this.viewEndTime, SliceWaveRenderer.this.dateFormatString) + ")";
            }
            if (SliceWaveRenderer.this.yLabelText != null) {
                this.yAxisLabel = SliceWaveRenderer.this.yLabelText;
            }
            this.xAxisLabels = SliceWaveRenderer.this.xTickValues;
            this.yAxisLabels = SliceWaveRenderer.this.yTickValues;
            if (!SliceWaveRenderer.this.xTickMarks) {
                this.hTicks = 0;
                this.xAxisGrid = DefaultFrameDecorator.Grid.NONE;
            }
            if (!SliceWaveRenderer.this.yTickMarks) {
                this.vTicks = 0;
                this.yAxisGrid = DefaultFrameDecorator.Grid.NONE;
            }
            this.title = SliceWaveRenderer.this.title;
            this.titleBackground = Color.WHITE;
        }
    }
}

