/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.transform;

import java.awt.geom.Point2D;

public class ArbDepthCalculator {
    double width = 10.0;
    double x1 = 0.0;
    double y1 = 0.0;
    double x2 = 0.0;
    double y2 = 0.0;
    double theta = 0.0;
    private double maxDistance;
    private double progDistance;
    private double scale;

    public ArbDepthCalculator(double lat1, double lon1, double lat2, double lon2) {
        this.x1 = lon1;
        this.x2 = lon2;
        this.y1 = lat1;
        this.y2 = lat2;
        this.setupAngles();
    }

    public ArbDepthCalculator(double lat1, double lon1, double lat2, double lon2, double width) {
        this(lat1, lon1, lat2, lon2);
        this.setWidth(width);
    }

    public boolean isInsideArea(double lat, double lon) {
        double d = this.getScaledProjectedDistance(lat, lon);
        if (d < 0.0) {
            return false;
        }
        if (d > this.getMaxDist()) {
            return false;
        }
        return !(this.width > 0.0) || !(this.getScalePojectedWidth(lat, lon) > this.width);
    }

    private void setupAngles() {
        this.theta = Math.atan2(this.x2 - this.x1, this.y2 - this.y1);
        this.maxDistance = this.getMaxDist();
        this.progDistance = this.getProjectedDistance(this.y2, this.x2);
        this.scale = this.maxDistance / this.progDistance;
    }

    private double getProjectedDistance(double lat, double lon) {
        double dist = 0.0;
        dist = (lat - this.y1) * Math.cos(this.theta) + (lon - this.x1) * Math.sin(this.theta);
        return dist;
    }

    public double getScaledProjectedDistance(double lat, double lon) {
        double dist = this.getProjectedDistance(lat, lon);
        return dist *= this.scale;
    }

    public double getScalePojectedWidth(double lat, double lon) {
        double wid = 0.0;
        wid = this.getPojectedWidth(lat, lon);
        return Math.abs(wid *= this.scale);
    }

    private double getPojectedWidth(double lat, double lon) {
        double wid = 0.0;
        wid = (lon - this.x1) * Math.cos(this.theta) - (lat - this.y1) * Math.sin(this.theta);
        return wid;
    }

    public static double getLatDiff(double kms) {
        double d = 0.0;
        double latInc = 0.001;
        double tlat2 = 0.0;
        double tlat1 = 0.0;
        double tlon2 = 0.0;
        double tlon1 = 0.0;
        while (d < kms) {
            d = ArbDepthCalculator.distFrom(tlat1, tlon1, tlat2 += latInc, tlon2);
        }
        return tlat2;
    }

    public static double getLonDiff(double kms, double tlat1) {
        double d = 0.0;
        double lonInc = 0.001;
        double tlat2 = 0.0;
        double tlon2 = 0.0;
        double tlon1 = 0.0;
        tlat2 = tlat1;
        while (d < kms) {
            d = ArbDepthCalculator.distFrom(tlat1, tlon1, tlat2, tlon2 += lonInc);
        }
        return tlon2;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public Point2D getCorner1() {
        Point2D.Double pt = new Point2D.Double(this.x1, this.y1);
        return pt;
    }

    public Point2D getCorner2() {
        Point2D.Double pt = new Point2D.Double(this.x2, this.y2);
        return pt;
    }

    public double getLat1() {
        return this.x1;
    }

    public double getLon1() {
        return this.y1;
    }

    public double getLat2() {
        return this.x2;
    }

    public double getLon2() {
        return this.y2;
    }

    public double distanceTo(Point2D pt) {
        return this.distanceTo(pt.getY(), pt.getX());
    }

    public boolean insidePlot(double lat, double lon) {
        boolean inside = true;
        return inside;
    }

    public double distanceTo(double lat, double lon) {
        double dist = 0.0;
        dist = ArbDepthCalculator.distFrom(this.y1, this.x1, lat, lon);
        return dist;
    }

    public double getMaxDist() {
        double ret = this.distanceTo(this.y2, this.x2);
        return ret;
    }

    public double getMinDist() {
        return 0.0;
    }

    private static double distFrom(double lat1, double lng1, double lat2, double lng2) {
        double earthRadius = 6371.01;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = earthRadius * c;
        return dist;
    }

    public static void main(String[] args) {
        boolean doRealCities = true;
        if (doRealCities) {
            double lat1 = 40.77;
            double lon1 = -73.0;
            double lat2 = lat1;
            double lon2 = lon1;
            ArbDepthCalculator adc = new ArbDepthCalculator(lat1, lon1, lat2, lon2, 10.0);
            double d = 0.0;
            double latInc = 0.01;
            double latans = 0.0;
            d = 0.0;
            lat1 = 0.0;
            lat2 = 0.0;
            for (int j = 0; j < 30; ++j) {
                latans = ArbDepthCalculator.getLatDiff((double)j * 10.0);
                System.out.println("target lat is " + latans + " , for " + j * 10 + " km south of lat: " + lat1);
            }
            for (int i = 0; i < 90; i += 10) {
                System.out.println("\n\n");
                d = 0.0;
                lat2 = lat1 = 1.0 * (double)i;
                for (int j = 0; j < 30; ++j) {
                    latans = ArbDepthCalculator.getLonDiff((double)j * 10.0, lat1);
                    System.out.println("target lon is " + latans + " , for " + j * 10 + " km East of lat: " + lat1);
                }
            }
            while (d < 10.0) {
                d = ArbDepthCalculator.distFrom(lat1, lon1, lat2 += latInc, lon2);
                System.out.println("dist is " + d + " km, for lat diff of: " + (lat2 - lat1));
            }
            System.out.println("\n\n");
            d = 0.0;
            double lonInc = 0.01;
            lat2 = lat1;
            lon2 = lon1;
            while (d < 10.0) {
                d = ArbDepthCalculator.distFrom(lat1, lon1, lat2, lon2 += lonInc);
            }
            System.out.println("dist is " + d + " km, for lon diff of: " + (lon2 - lon1) + " for a lat of " + lat1);
            System.out.println("\n\n");
            d = 0.0;
            lonInc = 0.01;
            lat1 = 80.0;
            lat2 = 80.0;
            lon2 = lon1;
            while (d < 10.0) {
                d = ArbDepthCalculator.distFrom(lat1, lon1, lat2, lon2 += lonInc);
            }
            System.out.println("dist is " + d + " km, for lon diff of: " + (lon2 - lon1) + " for a lat of " + lat1);
            for (int i = 0; i < 90; i += 10) {
                System.out.println("\n\n");
                d = 0.0;
                lonInc = 0.01;
                lat2 = lat1 = 1.0 * (double)i;
                lon2 = lon1;
                while (d < 10.0) {
                    d = ArbDepthCalculator.distFrom(lat1, lon1, lat2, lon2 += lonInc);
                }
                System.out.println("dist is " + d + " km, for lon diff of: " + (lon2 - lon1) + " for a lat of " + lat1);
            }
            System.out.println("total distance in .0016 degrees: " + adc.getMaxDist());
            lat1 = 40.77;
            lon1 = -73.98;
            lat2 = 37.73;
            lon2 = -122.68;
            adc = new ArbDepthCalculator(lat1, lon1, lat2, lon2, 10.0);
            System.out.println("total distance is from NY to SF: " + adc.getMaxDist());
            double dist = adc.getScaledProjectedDistance(lat2, lon2);
            double wid = adc.getScalePojectedWidth(lat2, lon2);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
            System.out.println("\nchicago");
            double lat3 = 41.9;
            double lon3 = -87.65;
            dist = adc.getScaledProjectedDistance(lat3, lon3);
            wid = adc.getScalePojectedWidth(lat3, lon3);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
            lat3 = 33.65;
            lon3 = -84.42;
            System.out.println("atlanta");
            dist = adc.getScaledProjectedDistance(lat3, lon3);
            wid = adc.getScalePojectedWidth(lat3, lon3);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
            System.out.println("trenton");
            lat3 = 40.28;
            lon3 = -74.82;
            dist = adc.getScaledProjectedDistance(lat3, lon3);
            wid = adc.getScalePojectedWidth(lat3, lon3);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
            System.out.println("oakland");
            lat3 = 37.73;
            lon3 = -122.22;
            dist = adc.getScaledProjectedDistance(lat3, lon3);
            wid = adc.getScalePojectedWidth(lat3, lon3);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
            System.out.println("albany");
            lat3 = 42.75;
            lon3 = -73.8;
            dist = adc.getScaledProjectedDistance(lat3, lon3);
            wid = adc.getScalePojectedWidth(lat3, lon3);
            System.out.println("dist = " + dist);
            System.out.println("wid  = " + wid);
        } else {
            double lt1 = 0.0;
            double ln1 = 0.0;
            double lt2 = 6.0;
            double ln2 = 8.0;
            ArbDepthCalculator adc = new ArbDepthCalculator(lt1, ln1, lt2, ln2, 10.0);
            double c = adc.getMaxDist();
            double w = 0.0;
            System.out.println("dist = " + c);
            double x = 6.0;
            double y = 8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 6.0;
            y = 8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = 4.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 1.0;
            y = 3.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 1.0;
            y = 2.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = 0.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 4.0;
            y = 4.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            lt1 = 0.0;
            ln1 = 8.0;
            lt2 = 6.0;
            ln2 = 0.0;
            adc = new ArbDepthCalculator(lt1, ln1, lt2, ln2, 10.0);
            c = adc.getMaxDist();
            w = 0.0;
            System.out.println("dist = " + c);
            x = 6.0;
            y = 8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 6.0;
            y = 8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = 4.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 7.0;
            y = 3.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 7.0;
            y = 2.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = 0.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 4.0;
            y = 4.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            lt1 = 0.0;
            ln1 = 0.0;
            lt2 = 6.0;
            ln2 = -8.0;
            adc = new ArbDepthCalculator(lt1, ln1, lt2, ln2, 10.0);
            c = adc.getMaxDist();
            w = 0.0;
            System.out.println("dist = " + c);
            x = 6.0;
            y = 0.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 6.0;
            y = 0.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = -4.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 7.0;
            y = -5.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 7.0;
            y = -6.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 3.0;
            y = -8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
            x = 4.0;
            y = -8.0;
            c = adc.getProjectedDistance(x, y);
            w = adc.getPojectedWidth(x, y);
            System.out.println("for (" + x + "," + y + ") .. dist = " + c);
            System.out.println("for (" + x + "," + y + ") .. width = " + w);
        }
    }
}

