/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.proj;

import gov.usgs.proj.Ellipsoid;
import gov.usgs.proj.Projection;
import java.awt.geom.Point2D;

public class Stereographic
extends Projection {
    private Point2D.Double origin;

    @Override
    public void setOrigin(Point2D.Double pt) {
        this.origin = pt;
    }

    @Override
    public Point2D.Double forward(Point2D.Double lonLat) {
        double r = Ellipsoid.ELLIPSOIDS[0].equatorialRadius;
        double k0 = 1.0;
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = lonLat.getY() * (Math.PI / 180);
        double lambda = lonLat.getX() * (Math.PI / 180);
        double k = 2.0 * k0 / (1.0 + Math.sin(phiO) * Math.sin(phi) + Math.cos(phiO) * Math.cos(phi) * Math.cos(lambda - lambdaO));
        double x = r * k * Math.cos(phi) * Math.sin(lambda - lambdaO);
        double y = r * k * (Math.cos(phiO) * Math.sin(phi) - Math.sin(phiO) * Math.cos(phi) * Math.cos(lambda - lambdaO));
        return new Point2D.Double(x, y);
    }

    @Override
    public Point2D.Double inverse(Point2D.Double xy) {
        double r = Ellipsoid.ELLIPSOIDS[0].equatorialRadius;
        double k0 = 1.0;
        double x = xy.x;
        double y = xy.y;
        double rho = Math.sqrt(x * x + y * y);
        if (Math.abs(rho) < 1.0E-5) {
            return this.origin;
        }
        double c = 2.0 * Math.atan2(rho, 2.0 * r * k0);
        double phiO = this.origin.getY() * (Math.PI / 180);
        double lambdaO = this.origin.getX() * (Math.PI / 180);
        double phi = Math.asin(Math.cos(c) * Math.sin(phiO) + y * Math.sin(c) * Math.cos(phiO) / rho);
        double phiOd = this.origin.getY();
        double lambda = 0.0;
        lambda = phiOd == 90.0 ? lambdaO + Math.atan2(x, -y) : (phiOd == -90.0 ? lambdaO + Math.atan2(x, y) : lambdaO + Math.atan2(x * Math.sin(c), rho * Math.cos(phiO) * Math.cos(c) - y * Math.sin(phiO) * Math.sin(c)));
        return new Point2D.Double(lambda * 57.29577951308232, phi * 57.29577951308232);
    }

    @Override
    public double getScale(Point2D.Double lonLat) {
        return 1.0;
    }

    public static void main(String[] args) {
        Point2D.Double o = new Point2D.Double(-100.0, 40.0);
        Point2D.Double p = new Point2D.Double(-75.0, 30.0);
        Stereographic sg = new Stereographic();
        sg.origin = o;
        Point2D.Double p2 = sg.forward(p);
        System.out.println(p2);
        System.out.println(sg.inverse(p2));
    }
}

