/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser;

import gov.usgs.proj.GeoRange;
import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Messages;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwarmUtil;
import gov.usgs.swarm.SwingWorker;
import gov.usgs.swarm.chooser.EditDataSourceDialog;
import gov.usgs.swarm.data.DataSourceType;
import gov.usgs.swarm.data.FileDataSource;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.data.SeismicDataSourceListener;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.wave.SwarmMultiMonitors;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Pair;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataChooser
extends JPanel {
    public static final int NO_CHANNEL_LIST = -2;
    public static final int NO_DATA_SOURCE = -1;
    public static final int OK = 0;
    private static final long serialVersionUID = 1L;
    private static final String OPENING_MESSAGE = Messages.getString("DataChooser.treeOpening");
    private static final String[] TIME_VALUES = new String[]{"Now"};
    private static final int MAX_CHANNELS_AT_ONCE = 500;
    public static final Color LINE_COLOR = new Color(172, 168, 153);
    private static final DataChooser INSTANCE = new DataChooser();
    private static final JFrame applicationFrame = Swarm.getApplicationFrame();
    private JTree dataTree;
    private JScrollPane treeScrollPane;
    private JLabel nearestLabel;
    private JList nearestList;
    private JScrollPane nearestScrollPane;
    private JSplitPane split;
    private JPanel nearestPanel;
    private String lastNearest;
    private DefaultMutableTreeNode rootNode;
    private JToolBar toolBar;
    private JButton editButton;
    private JButton newButton;
    private JButton closeButton;
    private JButton collapseButton;
    private JButton deleteButton;
    private JComboBox timeBox;
    private JButton heliButton;
    private JButton clipboardButton;
    private JButton monitorButton;
    private JButton realtimeButton;
    private JButton mapButton;
    private Map<String, TreePath> nearestPaths;
    private Set<String> openedSources;
    private ServerNode filesNode = new ServerNode(FileDataSource.getInstance());
    private boolean filesNodeInTree = false;
    private DefaultTreeModel model;

    private DataChooser() {
        super(new BorderLayout());
        this.filesNode.getSource().addListener(new FileSourceListener());
        this.nearestPaths = new HashMap<String, TreePath>();
        this.openedSources = new HashSet<String>();
        this.createToolBar();
        this.createTree();
        this.createNearest();
        this.split = SwarmUtil.createStrippedSplitPane(0, this.treeScrollPane, this.nearestPanel);
        this.split.setDividerSize(4);
        this.add((Component)this.split, "Center");
        this.createActionBar();
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.addServers(SwarmConfig.getInstance().sources);
    }

    public static DataChooser getInstance() {
        return INSTANCE;
    }

    public void saveLayout(ConfigFile cf, String prefix) {
        for (String src : this.openedSources) {
            cf.put(prefix + ".source", src);
        }
    }

    public void processLayout(ConfigFile cf, ActionListener listener) {
        List<String> srcs = cf.getList("source");
        for (String src : srcs) {
            if (!this.isSourceOpened(src)) {
                ServerNode node = this.getServerNode(src);
                if (node == null) {
                    listener.actionPerformed(new ActionEvent(this, -1, src));
                    continue;
                }
                this.dataSourceSelected(node, listener);
                continue;
            }
            listener.actionPerformed(new ActionEvent(this, 0, src));
        }
    }

    private void createToolBar() {
        this.toolBar = SwarmUtil.createToolBar();
        this.newButton = SwarmUtil.createToolBarButton(Icons.new_server, Messages.getString("DataChooser.newSourceToolTip"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SeismicDataSource source;
                        EditDataSourceDialog d = new EditDataSourceDialog(null);
                        d.setVisible(true);
                        String nds = d.getResult();
                        if (nds != null && (source = DataSourceType.parseConfig(nds)) != null) {
                            DataChooser.this.insertServer(source);
                        }
                    }
                });
            }
        });
        this.toolBar.add(this.newButton);
        this.editButton = SwarmUtil.createToolBarButton(Icons.edit_server, Messages.getString("DataChooser.editSourceToolTip"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeismicDataSource sds;
                List servers = DataChooser.this.getSelectedServers();
                if (servers != null && servers.size() > 0 && (sds = ((ServerNode)servers.get(0)).getSource()).isStoreInUserConfig()) {
                    String selected = ((ServerNode)servers.get(0)).getSource().toConfigString();
                    EditDataSourceDialog d = new EditDataSourceDialog(selected);
                    d.setVisible(true);
                    String eds = d.getResult();
                    if (eds != null) {
                        SeismicDataSource newSource = DataSourceType.parseConfig(eds);
                        if (newSource == null) {
                            return;
                        }
                        DataChooser.this.removeServer((ServerNode)servers.get(0));
                        String svn = eds.substring(0, eds.indexOf(";"));
                        SwarmConfig.getInstance().removeSource(svn);
                        SwarmConfig.getInstance().addSource(newSource);
                        DataChooser.this.insertServer(newSource);
                    }
                }
            }
        });
        this.toolBar.add(this.editButton);
        this.collapseButton = SwarmUtil.createToolBarButton(Icons.collapse, Messages.getString("DataChooser.collapseToolTip"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataChooser.this.collapseTree(DataChooser.this.dataTree);
            }
        });
        this.toolBar.add(this.collapseButton);
        this.deleteButton = SwarmUtil.createToolBarButton(Icons.new_delete, Messages.getString("DataChooser.removeSourceToolTip"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List servers = DataChooser.this.getSelectedServers();
                if (servers != null) {
                    for (ServerNode server : servers) {
                        if (!server.getSource().isStoreInUserConfig()) continue;
                        DataChooser.this.removeServer(server);
                    }
                }
            }
        });
        this.toolBar.add(this.deleteButton);
        this.toolBar.add(Box.createHorizontalGlue());
        this.closeButton = SwarmUtil.createToolBarButton(Icons.close_view, "Close data chooser", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().setChooserVisible(false);
                DataChooser.this.closeButton.getModel().setRollover(false);
            }
        });
        this.toolBar.add(this.closeButton);
        this.add((Component)this.toolBar, "North");
    }

    private void addTimeToBox(String t) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.timeBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!model.getElementAt(i).equals(t)) continue;
            model.removeElementAt(i);
            break;
        }
        model.insertElementAt(t, 1);
        this.timeBox.setSelectedIndex(1);
    }

    public String[] getUserTimes() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.timeBox.getModel();
        String[] result = new String[model.getSize() - 1];
        for (int i = 1; i < model.getSize(); ++i) {
            result[i - 1] = (String)model.getElementAt(i);
        }
        return result;
    }

    private double getTime() {
        double j2k = Double.NaN;
        String t0 = ((JTextField)this.timeBox.getEditor().getEditorComponent()).getText();
        if (!t0.equals(TIME_VALUES[0])) {
            String t = t0;
            if (t.length() == 8) {
                t = t + "2359";
            }
            try {
                j2k = Time.parseEx("yyyyMMddHHmm", t);
                this.addTimeToBox(t0);
            }
            catch (ParseException e) {
                String message = "Invalid time; legal format is 'YYYYMMDD' or 'YYYYMMDDhhmm', using 'Now' instead.";
                JOptionPane.showMessageDialog(applicationFrame, message, "Time Error", 0);
            }
        }
        return j2k;
    }

    private void createActionBar() {
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        JPanel actionPanel = new JPanel(new GridLayout(1, 5));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        this.heliButton = new JButton(Icons.heli);
        this.heliButton.setFocusable(false);
        this.heliButton.setToolTipText(Messages.getString("DataChooser.heliButtonToolTip"));
        this.heliButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        List channels = DataChooser.this.getSelections();
                        if (channels != null) {
                            double j2k = DataChooser.this.getTime();
                            for (Pair pair : channels) {
                                Swarm.openHelicorder(((ServerNode)pair.item1).getSource(), (String)pair.item2, j2k);
                            }
                        }
                        return null;
                    }
                };
                worker.start();
            }
        });
        this.realtimeButton = new JButton(Icons.wave);
        this.realtimeButton.setFocusable(false);
        this.realtimeButton.setToolTipText(Messages.getString("DataChooser.waveButtonToolTip"));
        this.realtimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        List channels = DataChooser.this.getSelections();
                        if (channels != null) {
                            for (Pair pair : channels) {
                                Swarm.openRealtimeWave(((ServerNode)pair.item1).getSource(), (String)pair.item2);
                            }
                        }
                        return null;
                    }
                };
                worker.start();
            }
        });
        this.clipboardButton = new JButton(Icons.clipboard);
        this.clipboardButton.setFocusable(false);
        this.clipboardButton.setToolTipText(Messages.getString("DataChooser.clipboardButtonToolTip"));
        this.clipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        List channels = DataChooser.this.getSelections();
                        Collections.sort(channels, new Comparator<Pair<ServerNode, String>>(){

                            @Override
                            public int compare(Pair<ServerNode, String> o1, Pair<ServerNode, String> o2) {
                                return ((String)o1.item2).compareTo((String)o2.item2);
                            }
                        });
                        if (channels != null) {
                            for (Pair pair : channels) {
                                Swarm.loadClipboardWave(((ServerNode)pair.item1).getSource(), (String)pair.item2);
                            }
                        }
                        WaveClipboardFrame.getInstance().requestFocusInWindow();
                        return null;
                    }
                };
                worker.start();
            }
        });
        this.monitorButton = new JButton(Icons.monitor);
        this.monitorButton.setFocusable(false);
        this.monitorButton.setToolTipText(Messages.getString("DataChooser.monitorButtonToolTip"));
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        List channels = DataChooser.this.getSelections();
                        if (channels != null) {
                            for (Pair pair : channels) {
                                SwarmMultiMonitors.monitorChannelSelected(((ServerNode)pair.item1).getSource(), (String)pair.item2);
                            }
                        }
                        return null;
                    }
                };
                worker.start();
            }
        });
        this.mapButton = new JButton(Icons.earth);
        this.mapButton.setFocusable(false);
        this.mapButton.setToolTipText("Open map interface");
        this.mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        List channels = DataChooser.this.getSelections();
                        GeoRange gr = new GeoRange();
                        int nc = 0;
                        for (Pair pair : channels) {
                            Metadata md = SwarmConfig.getInstance().getMetadata((String)pair.item2);
                            Point2D.Double pt = md.getLonLat();
                            if (pt == null || Double.isNaN(pt.x) || Double.isNaN(pt.y)) continue;
                            ++nc;
                            gr.includePoint(pt, 1.0E-4);
                        }
                        if (nc == 1) {
                            gr.pad(0.1275, 0.1275);
                        } else {
                            gr.padPercent(1.2, 1.2);
                        }
                        if (gr.isValid()) {
                            MapFrame mapFrame = MapFrame.getInstance();
                            mapFrame.setVisible(true);
                            mapFrame.setView(gr);
                        }
                        return null;
                    }
                };
                worker.start();
            }
        });
        actionPanel.add(this.heliButton);
        actionPanel.add(this.clipboardButton);
        actionPanel.add(this.monitorButton);
        actionPanel.add(this.realtimeButton);
        actionPanel.add(this.mapButton);
        JPanel timePanel = new JPanel(new BorderLayout());
        this.timeBox = new JComboBox<String>(TIME_VALUES);
        for (String ut : SwarmConfig.getInstance().userTimes) {
            if (ut.length() <= 0) continue;
            this.timeBox.addItem(ut);
        }
        this.timeBox.setEditable(true);
        this.timeBox.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DataChooser.this.timeBox.getEditor().selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        timePanel.add((Component)new JLabel("Open to: "), "West");
        timePanel.add((Component)this.timeBox, "Center");
        bottomPanel.add(timePanel);
        bottomPanel.add(actionPanel);
        this.add((Component)bottomPanel, "South");
    }

    public int getDividerLocation() {
        return this.split.getDividerLocation();
    }

    public void setDividerLocation(int dl) {
        this.split.setDividerLocation(dl);
    }

    private ServerNode getServerNode(String svr) {
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            ServerNode node = (ServerNode)this.rootNode.getChildAt(i);
            if (!node.getSource().getName().equals(svr)) continue;
            return node;
        }
        return null;
    }

    private List<ServerNode> getSelectedServers() {
        TreePath[] paths = this.dataTree.getSelectionPaths();
        ArrayList<ServerNode> servers = new ArrayList<ServerNode>();
        if (paths != null) {
            for (TreePath path : paths) {
                if (path.getPathCount() != 2) continue;
                ServerNode node = (ServerNode)path.getLastPathComponent();
                servers.add(node);
            }
        }
        return servers;
    }

    private List<Pair<ServerNode, String>> getSelections() {
        TreePath[] paths = this.dataTree.getSelectionPaths();
        return this.getSelectedLeaves(paths);
    }

    private void collapseTree(JTree tree) {
        this.model.reload();
    }

    private boolean isOpened(ChooserNode node) {
        ChooserNode child = (ChooserNode)node.getChildAt(0);
        if (!(child instanceof MessageNode)) {
            return true;
        }
        return !((MessageNode)child).getLabel().equals(OPENING_MESSAGE);
    }

    public boolean isSourceOpened(String src) {
        return this.openedSources.contains(src);
    }

    private List<String> openSource(SeismicDataSource sds) {
        List<String> channels = null;
        try {
            sds.establish();
            channels = sds.getChannels();
            MapFrame.getInstance().reset(false);
            sds.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return channels;
    }

    private void dataSourceSelected(ServerNode source, ActionListener listener) {
        DataSourceOpener opener = new DataSourceOpener(source, listener);
        opener.start();
    }

    public void removeServer(final ServerNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwarmConfig.getInstance().removeSource(node.getSource().getName());
                DataChooser.this.model.removeNodeFromParent(node);
            }
        });
    }

    public void insertServer(final SeismicDataSource source) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String s;
                SwarmConfig.getInstance().addSource(source);
                String ns = source.getName();
                int i = 0;
                for (i = 0; i < DataChooser.this.rootNode.getChildCount() && ns.compareToIgnoreCase(s = ((ServerNode)DataChooser.this.rootNode.getChildAt(i)).getSource().getName()) > 0; ++i) {
                }
                ServerNode node = new ServerNode(source);
                node.add(new MessageNode(OPENING_MESSAGE));
                DataChooser.this.model.insertNodeInto(node, DataChooser.this.rootNode, i);
                DataChooser.this.model.reload();
            }
        });
    }

    public void addServers(final Map<String, SeismicDataSource> servers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> list = Collections.list(Collections.enumeration(servers.keySet()));
                Collections.sort(list, Util.getIgnoreCaseStringComparator());
                for (String key : list) {
                    SeismicDataSource sds = (SeismicDataSource)servers.get(key);
                    ServerNode node = new ServerNode(sds);
                    node.add(new MessageNode(OPENING_MESSAGE));
                    DataChooser.this.rootNode.add(node);
                }
                DataChooser.this.model.reload();
            }
        });
    }

    private void createTree() {
        this.rootNode = new RootNode();
        this.dataTree = new JTree(this.rootNode);
        this.dataTree.setRootVisible(false);
        this.dataTree.setBorder(BorderFactory.createEmptyBorder(1, 2, 0, 0));
        this.model = new DefaultTreeModel(this.rootNode);
        this.dataTree.setModel(this.model);
        this.treeScrollPane = new JScrollPane(this.dataTree);
        this.dataTree.addTreeSelectionListener(new MakeVisibileTSL());
        this.dataTree.addTreeExpansionListener(new ExpansionListener());
        this.dataTree.setCellRenderer(new CellRenderer());
        this.dataTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode node;
                TreePath path;
                if (e.getClickCount() == 1 && (path = DataChooser.this.dataTree.getSelectionPath()) != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) instanceof ChannelNode) {
                    ChannelNode cn = (ChannelNode)node;
                    DataChooser.this.setNearest(cn.getChannel());
                }
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && (path = DataChooser.this.dataTree.getSelectionPath()) != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null && node.isLeaf()) {
                    if (e.isShiftDown()) {
                        DataChooser.this.realtimeButton.doClick();
                    } else if (e.isControlDown()) {
                        DataChooser.this.clipboardButton.doClick();
                    } else {
                        DataChooser.this.heliButton.doClick();
                    }
                }
            }
        });
        this.dataTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    DataChooser.this.heliButton.doClick();
                }
            }
        });
    }

    public void setNearest(final String channel) {
        if (channel == null || channel.equals(this.lastNearest)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<Pair<Double, String>> nrst = Metadata.findNearest(SwarmConfig.getInstance().getMetadata(), channel);
                if (nrst == null) {
                    return;
                }
                DataChooser.this.lastNearest = channel;
                DataChooser.this.nearestLabel.setText("Distance to " + channel);
                DefaultListModel model = (DefaultListModel)DataChooser.this.nearestList.getModel();
                model.removeAllElements();
                for (Pair<Double, String> item : nrst) {
                    model.addElement(String.format("%s (%.1f km)", item.item2, (Double)item.item1 / 1000.0));
                }
            }
        });
    }

    private void createNearest() {
        this.nearestList = new JList(new DefaultListModel());
        this.nearestScrollPane = new JScrollPane(this.nearestList);
        this.nearestPanel = new JPanel(new BorderLayout());
        this.nearestPanel.add((Component)this.nearestScrollPane, "Center");
        this.nearestLabel = new JLabel("Distance");
        this.nearestPanel.add((Component)this.nearestLabel, "North");
        this.nearestList.setCellRenderer(new ListCellRenderer());
        this.nearestList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object[] sels = DataChooser.this.nearestList.getSelectedValues();
                    if (sels.length > 0) {
                        DataChooser.this.dataTree.clearSelection();
                    }
                    for (Object o : sels) {
                        String ch = (String)o;
                        ch = ch.substring(0, ch.indexOf("(")).trim();
                        TreePath tp = (TreePath)DataChooser.this.nearestPaths.get(ch);
                        DataChooser.this.dataTree.addSelectionPath(tp);
                    }
                }
            }
        });
    }

    private void populateServer(final ServerNode node, final List<String> channels, final boolean expandAll, final boolean saveProgress) {
        if (channels == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeMap<String, GroupNode> rootMap = new TreeMap<String, GroupNode>();
                HashMap<String, GroupNode> groupMap = new HashMap<String, GroupNode>();
                HashSet<GroupNode> openGroups = new HashSet<GroupNode>();
                GroupNode allNode = new GroupNode(Messages.getString("DataChooser.allGroup"));
                ServerNode rootNode = node;
                if (!saveProgress) {
                    rootNode.removeAllChildren();
                } else {
                    for (int i = 0; i < rootNode.getChildCount(); ++i) {
                        if (rootNode.getChildAt(i) instanceof ProgressNode) continue;
                        rootNode.remove(i);
                        --i;
                    }
                }
                rootNode.add(allNode);
                for (String channel : channels) {
                    ChannelNode newNode = new ChannelNode(channel);
                    allNode.add(newNode);
                    Metadata md = SwarmConfig.getInstance().getMetadata(channel);
                    if (md != null && md.getGroups() != null) {
                        Set<String> groups = md.getGroups();
                        for (String g : groups) {
                            GroupNode gn;
                            boolean forceOpen = false;
                            String[] ss = g.split("\\^");
                            if (ss[0].endsWith("!")) {
                                ss[0] = ss[0].substring(0, ss[0].length() - 1);
                                forceOpen = true;
                            }
                            if ((gn = (GroupNode)rootMap.get(ss[0])) == null) {
                                gn = new GroupNode(ss[0]);
                                rootMap.put(ss[0], gn);
                            }
                            if (forceOpen) {
                                openGroups.add(gn);
                            }
                            GroupNode cn = gn;
                            String cs = ss[0];
                            for (int i = 1; i < ss.length; ++i) {
                                GroupNode nn;
                                boolean fo = false;
                                if (ss[i].endsWith("!")) {
                                    ss[i] = ss[i].substring(0, ss[i].length() - 1);
                                    fo = true;
                                }
                                if ((nn = (GroupNode)groupMap.get(cs = cs + "^" + ss[i])) == null) {
                                    nn = new GroupNode(ss[i]);
                                    groupMap.put(cs, nn);
                                    int j = 0;
                                    for (j = 0; j < cn.getChildCount(); ++j) {
                                        if (!(cn.getChildAt(j) instanceof GroupNode)) continue;
                                        GroupNode ogn = (GroupNode)cn.getChildAt(j);
                                        if (nn.name.compareToIgnoreCase(ogn.name) <= 0) break;
                                    }
                                    if (j >= cn.getChildCount()) {
                                        cn.add(nn);
                                    } else {
                                        cn.insert(nn, j);
                                    }
                                }
                                if (fo) {
                                    openGroups.add(nn);
                                }
                                cn = nn;
                            }
                            ChannelNode ln = new ChannelNode(channel);
                            cn.add(ln);
                        }
                    }
                    DataChooser.this.nearestPaths.put(channel, new TreePath(newNode.getPath()));
                }
                for (String key : rootMap.keySet()) {
                    GroupNode n = (GroupNode)rootMap.get(key);
                    rootNode.add(n);
                }
                DataChooser.this.model.reload(rootNode);
                for (GroupNode gn : openGroups) {
                    DataChooser.this.dataTree.expandPath(new TreePath(gn.getPath()));
                }
                if (expandAll) {
                    DataChooser.this.dataTree.expandPath(new TreePath(allNode.getPath()));
                }
                DataChooser.this.nearestList.repaint();
            }
        });
    }

    private Set<String> getGroupChannels(GroupNode gn) {
        HashSet<String> channels = new HashSet<String>();
        Enumeration<TreeNode> e = gn.children();
        while (e.hasMoreElements()) {
            ChooserNode n = (ChooserNode)e.nextElement();
            if (n instanceof ChannelNode) {
                channels.add(((ChannelNode)n).channel);
                continue;
            }
            if (!(n instanceof GroupNode)) continue;
            channels.addAll(this.getGroupChannels((GroupNode)n));
        }
        return channels;
    }

    private List<Pair<ServerNode, String>> getSelectedLeaves(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        boolean countExceeded = false;
        ArrayList<Pair<ServerNode, String>> selections = new ArrayList<Pair<ServerNode, String>>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            if (path.getPathCount() <= 2) continue;
            ServerNode serverNode = (ServerNode)path.getPathComponent(1);
            ChooserNode node = (ChooserNode)path.getLastPathComponent();
            if (node.isLeaf() && node instanceof ChannelNode) {
                selections.add(new Pair<ServerNode, String>(serverNode, ((ChannelNode)node).channel));
                continue;
            }
            if (node.isLeaf()) continue;
            Set<String> channels = this.getGroupChannels((GroupNode)node);
            for (String ch : channels) {
                selections.add(new Pair<ServerNode, String>(serverNode, ch));
            }
        }
        if (countExceeded) {
            JOptionPane.showMessageDialog(applicationFrame, Messages.getString("DataChooser.maxChannelsAtOnceError") + 500, Messages.getString("DataChooser.errorBoxTitle"), 0);
        }
        return selections;
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private CellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            if (value instanceof ProgressNode) {
                ProgressNode node = (ProgressNode)value;
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 0));
                panel.setOpaque(false);
                panel.setBorder(null);
                panel.setBackground(Color.WHITE);
                panel.add(new JLabel(node.getIcon()));
                panel.add(node.getProgressBar());
                return panel;
            }
            if (value instanceof ChooserNode) {
                ChooserNode node = (ChooserNode)value;
                Icon icon = node.getIcon();
                super.getTreeCellRendererComponent(tree, node.getLabel(), sel, exp, leaf, row, focus);
                this.setIcon(icon);
                return this;
            }
            super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, focus);
            return this;
        }
    }

    private class ListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            String ch = (String)value;
            ch = ch.substring(0, ch.indexOf("(")).trim();
            ImageIcon icon = DataChooser.this.nearestPaths.containsKey(ch) ? Icons.bullet : Icons.redbullet;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            this.setIcon(icon);
            return this;
        }
    }

    private class ProgressNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;
        private JProgressBar progressBar;

        public ProgressNode() {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setPreferredSize(new Dimension(80, 10));
        }

        @Override
        public Icon getIcon() {
            return Icons.warning;
        }

        public void setProgress(double p) {
            this.progressBar.setValue((int)Math.round(p * 100.0));
        }

        public JProgressBar getProgressBar() {
            return this.progressBar;
        }

        @Override
        public String getLabel() {
            return "progress";
        }
    }

    private class GroupNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;
        private String name;

        public GroupNode(String n) {
            this.name = n;
        }

        @Override
        public Icon getIcon() {
            return Icons.wave_folder;
        }

        @Override
        public String getLabel() {
            return this.name;
        }
    }

    private class MessageNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;
        private String message;

        public MessageNode(String m) {
            this.message = m;
        }

        @Override
        public Icon getIcon() {
            return Icons.warning;
        }

        @Override
        public String getLabel() {
            return this.message;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    private class ChannelNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;
        private String channel;

        public ChannelNode(String c) {
            this.channel = c;
            DataChooser.this.setToolTipText(this.channel + "<br>2nd line: value");
        }

        @Override
        public Icon getIcon() {
            Metadata md = SwarmConfig.getInstance().getMetadata(this.channel);
            if (md == null || !md.isTouched()) {
                return Icons.graybullet;
            }
            if (md.hasLonLat()) {
                return Icons.bluebullet;
            }
            return Icons.bullet;
        }

        @Override
        public String getLabel() {
            return this.channel;
        }

        public String getChannel() {
            return this.channel;
        }
    }

    private class ServerNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;
        private boolean broken;
        private SeismicDataSource source;

        public ServerNode(SeismicDataSource sds) {
            this.source = sds;
        }

        public void setBroken(boolean b) {
            this.broken = b;
        }

        @Override
        public Icon getIcon() {
            if (this.source instanceof FileDataSource) {
                return Icons.wave_folder;
            }
            if (!this.broken) {
                if (this.source.isStoreInUserConfig()) {
                    return Icons.server;
                }
                return Icons.locked_server;
            }
            if (this.source.isStoreInUserConfig()) {
                return Icons.broken_server;
            }
            return Icons.broken_locked_server;
        }

        @Override
        public String getLabel() {
            return this.source.getName();
        }

        public SeismicDataSource getSource() {
            return this.source;
        }
    }

    private class RootNode
    extends ChooserNode {
        private static final long serialVersionUID = 1L;

        private RootNode() {
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getLabel() {
            return null;
        }
    }

    private abstract class ChooserNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;

        private ChooserNode() {
        }

        public abstract Icon getIcon();

        public abstract String getLabel();

        @Override
        public String toString() {
            return "chooserNode";
        }
    }

    private class DataSourceOpener
    extends SwingWorker {
        private List<String> channels;
        private ServerNode source;
        private ActionListener finishListener;
        private SeismicDataSourceListener listener = new SeismicDataSourceListener(){

            @Override
            public void channelsProgress(String id, final double progress) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)DataSourceOpener.this.source.getFirstChild();
                        if (node instanceof MessageNode) {
                            DataChooser.this.model.removeNodeFromParent(node);
                            ProgressNode pn = new ProgressNode();
                            DataSourceOpener.this.source.insert(pn, 0);
                            DataChooser.this.model.insertNodeInto(pn, DataSourceOpener.this.source, 0);
                            DataChooser.this.dataTree.expandPath(new TreePath(DataSourceOpener.this.source.getPath()));
                            DataChooser.this.dataTree.repaint();
                        } else if (node instanceof ProgressNode) {
                            ProgressNode pn = (ProgressNode)node;
                            pn.setProgress(progress);
                            DataChooser.this.dataTree.repaint();
                        }
                    }
                });
            }

            @Override
            public void channelsUpdated() {
            }

            @Override
            public void helicorderProgress(String channel, double progress) {
            }
        };

        public DataSourceOpener(ServerNode src, ActionListener fl) {
            this.source = src;
            this.finishListener = fl;
        }

        @Override
        public Object construct() {
            SeismicDataSource sds = this.source.getSource();
            sds.addListener(this.listener);
            this.channels = DataChooser.this.openSource(sds);
            return null;
        }

        @Override
        public void finished() {
            int id = 0;
            if (this.channels != null) {
                this.source.setBroken(false);
                DataChooser.this.model.reload(this.source);
                DataChooser.this.populateServer(this.source, this.channels, false, false);
                id = 0;
                DataChooser.this.openedSources.add(this.source.getSource().getName());
            } else {
                this.source.setBroken(true);
                DataChooser.this.model.reload(this.source);
                DataChooser.this.dataTree.collapsePath(new TreePath(this.source.getPath()));
                id = -2;
            }
            this.source.getSource().removeListener(this.listener);
            if (this.finishListener != null) {
                this.finishListener.actionPerformed(new ActionEvent(DataChooser.this, id, this.source.getSource().getName()));
            }
        }
    }

    private class ExpansionListener
    implements TreeExpansionListener {
        private ExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            ServerNode node;
            TreePath path = event.getPath();
            if (path.getPathCount() == 2 && !DataChooser.this.isOpened(node = (ServerNode)path.getLastPathComponent())) {
                DataChooser.this.dataSourceSelected(node, null);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    class MakeVisibileTSL
    implements TreeSelectionListener {
        MakeVisibileTSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.isAddedPath()) {
                TreePath[] paths = e.getPaths();
                ((JTree)e.getSource()).scrollPathToVisible(paths[0]);
            }
        }
    }

    private class FileSourceListener
    implements SeismicDataSourceListener {
        Map<String, ProgressNode> progressNodes = new HashMap<String, ProgressNode>();

        @Override
        public synchronized void channelsUpdated() {
            List<String> ch = DataChooser.this.filesNode.getSource().getChannels();
            if (ch == null && DataChooser.this.filesNodeInTree) {
                DataChooser.this.filesNode.removeAllChildren();
                DataChooser.this.removeServer(DataChooser.this.filesNode);
                DataChooser.this.filesNodeInTree = false;
            } else if (ch != null) {
                if (!DataChooser.this.filesNodeInTree) {
                    DataChooser.this.model.insertNodeInto(DataChooser.this.filesNode, DataChooser.this.rootNode, 0);
                }
                DataChooser.this.populateServer(DataChooser.this.filesNode, ch, true, true);
                DataChooser.this.filesNodeInTree = true;
            }
        }

        @Override
        public synchronized void channelsProgress(String id, double p) {
            ProgressNode pn = this.progressNodes.get(id);
            boolean ins = false;
            if (pn == null) {
                pn = new ProgressNode();
                this.progressNodes.put(id, pn);
                ins = true;
            }
            if (!DataChooser.this.filesNodeInTree) {
                DataChooser.this.model.insertNodeInto(DataChooser.this.filesNode, DataChooser.this.rootNode, 0);
                DataChooser.this.filesNodeInTree = true;
                ins = true;
            }
            pn.setProgress(p);
            if (ins) {
                DataChooser.this.model.insertNodeInto(pn, DataChooser.this.filesNode, 0);
                DataChooser.this.dataTree.expandPath(new TreePath(DataChooser.this.filesNode.getPath()));
            }
            if (p == 1.0) {
                this.progressNodes.remove(id);
                DataChooser.this.filesNode.remove(pn);
            }
            DataChooser.this.dataTree.repaint();
        }

        @Override
        public void helicorderProgress(String channel, double progress) {
        }
    }
}

