/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.fdsnWs;

import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.DataRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.swarm.ChannelInfo;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import gov.usgs.swarm.data.seedLink.SeedUtils;
import gov.usgs.util.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractDataRecordClient {
    private final SeismicDataSource source;

    public AbstractDataRecordClient(SeismicDataSource source) {
        this.source = source;
    }

    public List<Wave> addWaves(List<Wave> waves, DataRecord dr) throws UnsupportedCompressionType, CodecException {
        for (Blockette blockette : dr.getBlockettes(1000)) {
            if (!(blockette instanceof Blockette1000)) continue;
            waves.add(SeedUtils.createWave(dr, (Blockette1000)blockette));
        }
        return waves;
    }

    public void assignChannels(List<String> channels) {
        WebServiceUtils.assignChannels(channels, this.source);
    }

    public List<Wave> createWaves() {
        return new ArrayList<Wave>();
    }

    public abstract List<String> getChannels();

    protected Date getDate(double t) {
        return Util.j2KToDate(t);
    }

    protected String getDateText(Date date) {
        return WebServiceUtils.getDateText(date);
    }

    protected String getDateText(double t) {
        return this.getDateText(this.getDate(t));
    }

    public abstract Wave getRawData(ChannelInfo var1, double var2, double var4);

    public SeismicDataSource getSource() {
        return this.source;
    }

    public Wave join(List<Wave> waves) {
        return Wave.join(waves);
    }
}

