/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.seedLink;

import gov.usgs.swarm.data.Gulper;
import gov.usgs.swarm.data.GulperList;
import gov.usgs.swarm.data.seedLink.SeedLinkClient;
import gov.usgs.swarm.data.seedLink.SeedLinkSource;
import gov.usgs.swarm.data.seedLink.StartEndTime;

public class SeedLinkGulper
extends Gulper {
    private final SeedLinkClient client;
    private final StartEndTime startEndTime = new StartEndTime();

    public SeedLinkGulper(GulperList gl, String k, SeedLinkSource source, String ch, double t1, double t2, int size, int delay) {
        super(gl, k, source, ch, t1, t2, size, delay);
        this.client = source.createClient();
        this.client.init(ch, t1, Double.NaN);
        this.client.start();
    }

    @Override
    public boolean isKilled() {
        return super.isKilled() || this.client.isKilled();
    }

    @Override
    protected void kill() {
        this.client.kill();
        super.kill();
    }

    @Override
    protected void runLoop() {
        while (!this.isKilled()) {
            this.client.getStartEndTime(this.startEndTime);
            if (!this.startEndTime.isEmpty()) {
                this.fireGulped(this.startEndTime.getStartTime(), this.startEndTime.getEndTime(), true);
                this.startEndTime.clear();
            }
            this.delay();
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void update(double t1, double t2) {
    }
}

