/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map;

import gov.usgs.swarm.SwarmConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MapLinePreview
extends JPanel {
    SwarmConfig config = SwarmConfig.getInstance();
    LinePreviewPane linePreviewPane = new LinePreviewPane();
    LineWidthPane lineWidthPane = new LineWidthPane();
    int lineWidth;

    public MapLinePreview() {
        this.add(this.linePreviewPane);
        this.add(this.lineWidthPane);
        this.lineWidth = this.config.mapLineWidth;
    }

    @Override
    public void setForeground(Color c) {
        if (this.linePreviewPane != null) {
            this.linePreviewPane.setColor(c);
        }
    }

    public class LineWidthPane
    extends JPanel
    implements DocumentListener {
        JTextField widthBox;
        JLabel widthBoxLabel = new JLabel("Width");

        public LineWidthPane() {
            this.add(this.widthBoxLabel);
            this.widthBox = new JTextField(4);
            this.widthBox.getDocument().addDocumentListener(this);
            this.widthBox.setText("" + MapLinePreview.this.lineWidth);
            this.setPreferredSize(new Dimension(100, 50));
            this.add(this.widthBox);
        }

        @Override
        public void insertUpdate(DocumentEvent ignoredEvent) {
            this.updateLineWidth(this.widthBox.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent ignoredEvent) {
            this.updateLineWidth(this.widthBox.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateLineWidth(this.widthBox.getText());
        }

        private void updateLineWidth(String w) {
            System.out.println("-- " + w);
            try {
                MapLinePreview.this.lineWidth = Integer.parseInt(w);
                this.widthBox.setBackground(Color.white);
                MapLinePreview.this.linePreviewPane.repaint();
            }
            catch (NumberFormatException e) {
                this.widthBox.setBackground(new Color(253, 130, 130));
            }
        }
    }

    public class LinePreviewPane
    extends JPanel {
        Color lineColor;

        public LinePreviewPane() {
            this.setPreferredSize(new Dimension(200, 50));
            this.lineColor = new Color(MapLinePreview.this.config.mapLineColor);
        }

        @Override
        public void paintComponent(Graphics g) {
            Line2D.Double line = new Line2D.Double(0.0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
            Graphics2D g2 = (Graphics2D)g;
            System.out.println(this.lineColor + " : " + MapLinePreview.this.lineWidth);
            g2.setPaintMode();
            g2.setStroke(new BasicStroke(MapLinePreview.this.config.mapLineWidth));
            g2.setStroke(new BasicStroke(MapLinePreview.this.lineWidth));
            g2.setColor(this.lineColor);
            g2.draw(line);
        }

        public void setColor(Color c) {
            this.lineColor = c;
        }
    }
}

